/*\t*******************************************************************/
/*    Creation Date .......  Fri  06-04-1993  07:39:47                */
/*    Filename  ...........  fipfile.h                                */
/*    Project .............  File Utilities                           */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS/Windows                              */
/*    Processor  ..........  FIP - File Public definitions            */
/*    Function: Public constants used by fiufile.cpp                  */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
04-JUN-93  MJWR         Define useful related file constants and strings.

**\r*/

/*\m********************************************************************
**                       Definitions
***********************************************************************/

#ifndef _FIPFILE_H_
#define _FIPFILE_H_

#define FIP_NO_ALT_PATH NULL

#define FIP_MAX_NAME_LEN        120

/****************************************
* Maximum length of a prefix string
* for creating a unique temporary file
* name.
*/

#define FIP_MAX_PREFIX_LEN      5

#define FIP_DEFAULT_PREFIX      "$"

/****************************************
* Minimum file name length the user can
* pass in to FIUcreateUniqueFile function.
* Should be longer to accomodate full
* path to file.
*/

#define FIP_MIN_NAME_LEN 13

#define FIP_PATH_SEP 0x5C /* Path separator character '\\' */
#define FIP_DRIVE_SEP ':' /* Drive spec separator character */

/*******************************
* Use these with calls to FIUextractExt
*/
#define FIP_MAKE_WC TRUE_
#define FIP_EXT_ONLY FALSE_
#endif

