/*\t*******************************************************************
   Creation Date .......  Tue  06-07-1994  13:28:02
   Filename  ...........  fortdos.cpp
   Project .............  Util
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C++
   Operating System  ...  PORTABLE
   Prefix ..............  FCA - Fortune Cookie test Application
   Function:    Present a fortune cookie to the user, from DOS.

 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
07-Jun-94  MJWR         MS-DOS version of fortune cookie to test
                        capabilities of FIUlocateFile function.
**\r*/

/*\i******************** System Include Files *************************/
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/********************** Constant Include Files ************************/
#include "liidSys.h"    /* System portability typedefs & constants    */
#include "erapdefs.h"   /* Error logger standard definitions          */
#include "fipfile.h"
#include "mmplist.h"
/***************** External Variable Include Files ********************/

/***************** External Procedure Include Files *******************/
#include "eraprpt.h"    /* Error logger prototypes                    */
#include "fiufile.h"
#include "mmulist.h"
#include "mmuslist.h"
#include "fortune.h"

/*\i*/

/*\m********************** Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\m*/

/*\p********************************************************************
**                                                                    **
    NAME:  printFortuneCookie

    PURPOSE:  to print the pearls of wisdom from a fortune cookie

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

void printFortuneCookie ( int pasCookieNum, MMUslist *pasWords )
{
/*********** Local Constant & Variable Declarations *******************/
const char *fclLine=
"------------------------------------------------------------";
char    *fclPearl;
/************************* Procedure Body *****************************/

fclPearl = pasWords->First();
if (fclPearl)
  {
  printf("Honerable fortune cookie #%d says...\n",
          pasCookieNum );
  printf("%s\n", fclLine);
  while (fclPearl)
    {
    printf("%s\n", fclPearl);
    fclPearl = pasWords->Next();
    }
  printf("%s\n", fclLine);
  }
else
  {
  printf("Cookie #%d is BLANK?\n", pasCookieNum );
  }
} /* printFortuneCookie end */

/*\p********************************************************************
**                                                                    **
    NAME:  main

    PURPOSE:  to give the user a fortune cookie, a pearl of wisdom,
        a quotable quote, or a simply annoyance du-joure

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

int main ( int pasArgc, char **pasArgv )
{
/*********** Local Constant & Variable Declarations *******************/
FCAfortune      *fclCookie;
STAT_TYPE        fclErr;
int              fclCookie1;
int              fclCookie2;
int              fclCookieNum;
char             fclStr[80];
/************************* Procedure Body *****************************/
printf("Fortune Cookie for DOS\n");
printf("These Pearls-O-Wisdom brought to you by\n");
printf("Matthew J. W. Ratcliff, Ratware Softworks, July-1994\n\n");

fclCookie = new FCAfortune( pasArgv[0] );

if (pasArgc == 1)
  {
  fclErr = fclCookie->getFortuneCookieRandom();
  if (fclErr == FAILED_)
    {
    fprintf(stderr,"** ERROR ** Can't get a fortune cookie.\n");
    }
  else
    {
    printFortuneCookie( fclCookie->fcpFortuneCookieNum,
                        fclCookie->fcpFortune );
    }
  }
else
  {
  fclErr = SUCCEEDED_;
  if (strcmpi(pasArgv[1],"ALL")==0)
    {
    fclCookie1 = 0;
    fclCookie2 = FCP_LAST_FORTUNE;
    }
  else
    {
    fclCookie1 = atoi(pasArgv[1]);
    if ((fclCookie1 < 0) || (fclCookie1 > FCP_LAST_FORTUNE))
      {
      fclErr = FAILED_;
      fprintf(stderr,"Fortune Cookie # '%s' is out of range\n",
              pasArgv[1] );
      }
    if (fclErr == SUCCEEDED_)
      {
      fclCookie2 = fclCookie1;
      if (pasArgc > 2)
        {
        fclCookie2 = atoi(pasArgv[2]);
        if ((fclCookie2 < 0) || (fclCookie2 > FCP_LAST_FORTUNE))
          {
          fclErr = FAILED_;
          fprintf(stderr,"Fortune Cookie # '%s' is out of range\n",
                  pasArgv[2] );
          }
        }
      }
    }
  if (fclErr == SUCCEEDED_)
    {
    fclCookieNum = fclCookie1;
    while ((fclCookieNum <= fclCookie2) && (fclErr == SUCCEEDED_))
      {
      fclErr = fclCookie->getFortuneCookieNum( fclCookieNum++ );
      if (fclErr == SUCCEEDED_)
        {
        printFortuneCookie( fclCookie->fcpFortuneCookieNum,
                            fclCookie->fcpFortune );
        }
      if (fclCookieNum <= fclCookie2)
        {
        printf("\nPress [ENTER] to continue or ^C to quit ? ");
        gets(fclStr);
        printf("\n\n");
        }
      }
    }
  }

return(0);
} /* main end */

