/*\t*******************************************************************
   Creation Date .......  Mon  06-06-1994  10:53:42
   Filename  ...........  fortune.cpp
   Project .............  Util
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C++
   Operating System  ...  PORTABLE
   Prefix ..............  FCA - Fortune Cookie Application
   Function:    Demo program to test new FIUfile functions.
        The FORTUNE COOKIE class implementation.

 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
06-Jun-94  MJWR         Reconstruct C++ version of Fortune Cookie algorithm

**\r*/

/*\i******************** System Include Files *************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <ctype.h>
/********************** Constant Include Files ************************/
#include "liidSys.h"    /* System portability typedefs & constants    */
#include "erapdefs.h"   /* Error logger standard definitions          */
#include "fipfile.h"
#include "mmplist.h"

/***************** External Variable Include Files ********************/

/***************** External Procedure Include Files *******************/
#include "eraprpt.h"    /* Error logger prototypes                    */
#include "mmulist.h"
#include "mmuslist.h"
#include "fortune.h"
#include "fiufile.h"

/*\i*/

/*\m********************** Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/
long fcaGetLongSwapped( const unsigned char *refSwStr );

/*\m*/

/****************************************
* Unwind a LONG number from a high-low
* sequence, 4-character string.
*/


long fcaGetLongSwapped( const unsigned char *refSwStr )
{

long gllNum;

/****************************************
* File is high byte-low byte format, but
* PC thinks in opposite sequence. This
* code unravels the high-low sequence
* so that the PC can understand it. Actually
* this code works for ANY computer that
* represents LONG data types with 32 bits
* or more.
*/

gllNum = (long)refSwStr[3]+((long)refSwStr[2]<<8)+
         ((long)refSwStr[1] <<16) + ((long)refSwStr[0] <<24);

return(gllNum);

}


/*\p********************************************************************
**                                                                    **
    NAME:  FCAfortune::FCAfortune

    PURPOSE:  to create a fortune cookie class

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

FCAfortune::FCAfortune ( const char *pasDefaultPath )
{
/*********** Local Constant & Variable Declarations *******************/
STAT_TYPE       fclErr;

/************************* Procedure Body *****************************/
fchFilePath = new char[FIP_MAX_NAME_LEN+1];

fclErr = FIUlocateFile( pasDefaultPath, FCP_FORTUNE_FILE,
                        FIP_MAX_NAME_LEN,
                        fchFilePath );
fchGotFortune = FALSE_;

if (fclErr == SUCCEEDED_)
  {
  fchFptr = FIUfopen( fchFilePath, "rb" );
  if (fchFptr)
    {
    fchGotFortune = TRUE_;
    FIUfclose( &fchFptr );
    }
  }
else
  {
  fchFptr = NULL;
  }
fcpFortune = new MMUslist();
fcpFortune->AppendAfterTail("** Empty Fortune Cookie **");

} /* FCAfortune::FCAfortune end */

/*\p********************************************************************
**                                                                    **
    NAME:  FCAfortune::~FCAfortune

    PURPOSE:  to delete fortune cookie class

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

FCAfortune::~FCAfortune ( )
{
/************************* Procedure Body *****************************/
LIMDEL(fcpFortune);
if (fchFptr) FIUfclose(&fchFptr);
LIMDELA(fchFilePath);

} /* FCAfortune::~FCAfortune end */

/*\p********************************************************************
**                                                                    **
    NAME:  FCAfortune::getFortuneCookieRandom

    PURPOSE:  to get a random fortune cookie

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

static BOOLEAN fcmRandomized = FALSE_;

STAT_TYPE FCAfortune::getFortuneCookieRandom ( )
{
/*********** Local Constant & Variable Declarations *******************/
#define FCL_MAX_SHORT   32768
#define FCL_TIMER_INT   0x1A // timer interrupt
#define FCL_TIMER_FNC   0x00 // Read system timer
STAT_TYPE               fclErr;
short                   fclRandom;
unsigned                fclCounter;

/************************* Procedure Body *****************************/

/****************************************
* Seed the random-number generator
* with the current time so that
* numbers are different every time we run.
*/
if (!fcmRandomized) 
  {
  /****************************************
  * Get the ls-word of the system timer counter
  * this will be rapidly changing pseudo-random
  * vaule, suitable for randomizing the seed
  * for the random number generator.
  */
_asm  mov   ah,00
_asm  int   FCL_TIMER_INT
_asm  mov   fclCounter,dx

  srand( fclCounter );
  fcmRandomized = TRUE_;
  }

fclRandom = (short)rand();
fclRandom = (int)((long)fclRandom*(long)FCP_LAST_FORTUNE/(long)FCL_MAX_SHORT);
fclErr    = getCookieNum( fclRandom );

return(fclErr);
} /* FCAfortune::getFortuneCookieRandom end */

/*\p********************************************************************
**                                                                    **
    NAME:  FCAfortune::getFortuneCookieNum

    PURPOSE:  to get a particular fortune cookie number

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

STAT_TYPE FCAfortune::getFortuneCookieNum ( int pasFortuneCookieNum )
{
/*********** Local Constant & Variable Declarations *******************/
STAT_TYPE               fclErr;
/************************* Procedure Body *****************************/

if ((pasFortuneCookieNum >= FCP_FIRST_FORTUNE) &&
    (pasFortuneCookieNum <= FCP_LAST_FORTUNE))
  {
  fclErr = getCookieNum(pasFortuneCookieNum);
  }
else
  {
  /****************************************
  * Fetch a random cookie on bad index
  */
  getFortuneCookieRandom();
  /****************************************
  * But return failed because of bad index
  */
  fclErr = FAILED_;
  }

return(fclErr);
} /* FCAfortune::getFortuneCookieNum end */

/*\p********************************************************************
**                                                                    **
    NAME:  FCAfortune::getCookieNum

    PURPOSE:  to get a fortune cookie by the number specified

** By Matthew J. W. Ratcliff                                          **
**   Return Val         type/expected/description                     **
**   ------------       --------------------------------------------  **
**   fclErr             STAT_TYPE, SUCCEEDED_ or FAILED_              **
**\p*******************************************************************/

STAT_TYPE FCAfortune::getCookieNum( int pasCookieNum )
{
/*********** Local Constant & Variable Declarations *******************/
#define FCL_SLEN        512 // Max fortune cookie line length
#define FCL_PTR_SIZE    4
#define FCL_OFFSET      7 // Skip over header
#define FCL_SEEK_FAIL  -1

STAT_TYPE               fclErr        = SUCCEEDED_; /* Iniz ret val   */

char                   *fclLine;
long                    fclFpos;
int                     fclSeaErr;
unsigned char           fclModLong[4];
int                     fclNumModRead;
int                     fclModInx;
int                     fclModDone;
int                     fclModCh;

/************************* Procedure Body *****************************/
fclErr  = SUCCEEDED_;
fclLine = new char[FCL_SLEN+1];

fcpFortuneCookieNum = pasCookieNum;

fclFpos = FCL_PTR_SIZE * (pasCookieNum + FCL_OFFSET);

fchFptr   = FIUfopen( fchFilePath, "rb");
fcpFortune->DeleteList();

if (fchFptr)
  {
  fclSeaErr = fseek( fchFptr, fclFpos, SEEK_SET );
  if (fclSeaErr == FCL_SEEK_FAIL)
    {
    sprintf( fclLine, "Failed to fetch fortune cookie %d", pasCookieNum );
    fcpFortune->AppendAfterTail( fclLine );
    fclErr = FAILED_;
    }
  else
    {
    fclNumModRead = fread( fclModLong, sizeof(char), 4, fchFptr );
    if (fclNumModRead == FCL_PTR_SIZE)
      {
      /* seek to fortune string */
      fclFpos = fcaGetLongSwapped(fclModLong);
      fclSeaErr = fseek( fchFptr, fclFpos, SEEK_SET );
      if (fclSeaErr != FCL_SEEK_FAIL )
        {
        fclModInx   = 0;
        fclModDone  = FALSE_;
        *fclLine = '\0';
        while (!fclModDone)
          {
          fclModCh = fgetc( fchFptr );
          switch( fclModCh )
            {
            case EOF:
              fclModDone = TRUE_;
              break;
            case '\0':
              fclModDone = TRUE_;
              break;
            case '\n':
                fclLine[fclModInx++] = '\0';
                if (!(*fclLine)) { *fclLine = ' '; fclLine[1] = '\0'; }
                fcpFortune->AppendAfterTail( fclLine );
                fclModInx = 0;
                *fclLine  = '\0';
                break;
            default:
              if ( isprint (fclModCh) )
                {
                fclLine[fclModInx++] = fclModCh;
                if (fclModInx >= FCL_SLEN)
                  {
                  fclLine[fclModInx++] = '\0';
                  fcpFortune->AppendAfterTail( fclLine );
                  fclModInx = 0;
                  *fclLine = '\0';
                  }
                }
              break;
            } /* end switch */
          } /* end while */
        if (*fclLine)
          {
          fclLine[fclModInx] = '\0';
          fcpFortune->AppendAfterTail( fclLine );
          }
        }
      }
    }
  FIUfclose( &fchFptr );
  }
else
  {
  sprintf( fclLine, "Failed open fortune cookie file %s",
           fchFilePath );
  fcpFortune->AppendAfterTail( fclLine );
  ERAerrorReport( ER_WARNING, "getCookieNum",
                  "Failed to open fortune cookie file.");
  fclErr = FAILED_;
  }
LIMDELA(fclLine);

return(fclErr);
} /* FCAfortune::getCookieNum end */

