/*\t*******************************************************************
   Creation Date .......  Mon  06-06-1994  10:49:52
   Filename  ...........  FORTUNE.H
   Project .............  Utilities
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C++
   Operating System  ...  PORTABLE
   Prefix ..............  FCA - Fortune Cookie Application
   Function:    Demo program to test new FIUFILE functions.

 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------

**\r*/
#ifndef _FORTUNE_H_
#define _FORTUNE_H_

/*\m******************** Include Requirements *************************
* List of files which must be included BEFORE this file can be included:
* #include "liidsys.h"
* #include "mmulist.h"
* #include "mmuslist.h"
*/


/*\m******************** Definitions **********************************/

#define FCP_FIRST_FORTUNE       0
#define FCP_LAST_FORTUNE        2141

#define FCP_FORTUNE_FILE        "FORTUNE.DAT"


/*\p********************************************************************
**                                                                    **
    NAME:  FCAfortune_class

    PURPOSE:  to fortune cookie class
**                                                                    **
** Matthew J. W. Ratcliff                                             **
**\p*******************************************************************/

class  FCAfortune

{
/********************** public declarations ***************************/
public:

        MMUslist        *fcpFortune;

        int              fcpFortuneCookieNum;

        FCAfortune( const char *pasDefaultPath );

       ~FCAfortune();

        /****************************************
        * Get a fortune cookie. Stick results in
        * fcpFortune list.  If failed, empty
        * fcpFortune list and return FAILED_;
        */

        STAT_TYPE getFortuneCookieRandom();

        STAT_TYPE getFortuneCookieNum( int pasFortuneNum );

/********************** private declarations **************************/
private:

        BOOLEAN  fchGotFortune;
        FILE    *fchFptr;

        char    *fchFilePath;

        STAT_TYPE getCookieNum( int pasFortuneNum );
}; /* FCAfortune end class */


/*\m****************** END Definitions ********************************/
#endif

