/*\t*******************************************************************
   Creation Date .......  Mon  06-06-1994  09:55:04
   Filename  ...........  fortunew.cpp
   Project .............  Utilities
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C or C++
   Operating System  ...  UNIX or DOS or Windows or ANY ...
   Prefix ..............  FCA - Fortune Cookie Application
   Function:    Test program to exercise the new FIUFILE function
        FIUgetCwd and test my prowess at using Microsoft Visual
        C++ 1.5 (although this program should be equally easy
        with any flavor of Borland Windows compiler)

        The Fortune Cookie for Windows & DOS.  The Fortune Cookie
        data comes from the internet somewhere - floating around
        out there for eons.  I captured it and, with the help of
        Doug Trimble, deciphered it and wrote both DOS and Windows
        programs to display fortune cookie messages.  The FORTUNE.DEF
        file specifies FORTDOS.EXE (in the DOS subdirectory relative
        to this current project directory) as the STUB.  Thus, when
        run from the command line, the fortune cookie program works.
        When run from windows, it also works.  Cool, eh?  Also
        illustrates the use of a DIALOG BOX ONLY application on top
        of the Windows API using C++.  (No OWL or MFC dependancies here!)

        Take a close look at the file functions in FIUFILE.CPP.
        HANDY DANDY STUFF!
 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
06-Jun-94  MJWR         Test new FIUfile support.

**\r*/

/*\i******************** System Include Files *************************/
#include <windows.h>
#include <string.h>
/********************** Constant Include Files ************************/
#include "liidSys.h"    /* System portability typedefs & constants    */
#include "erapdefs.h"   /* Error logger standard definitions          */
#include "resource.h"
#include "mmplist.h"
#include "fipfile.h"

/***************** External Variable Include Files ********************/

/***************** External Procedure Include Files *******************/
#include "eraprpt.h"    /* Error logger prototypes                    */
#include "mmulist.h"
#include "mmuslist.h"
#include "fiufile.h"
#include "fortune.h"

/*\i*/

/*\m********************** Module Constants ***************************/
#define FCM_DEBUG       0 // 1=DEBUG 0=RELEASE
/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

long FAR PASCAL WndProc( HWND pasHwindow,
                         WORD pasMessage,
                         WORD pasWparam,
                         LONG pasLparam );

void fcaCutNpaste( HWND      pasHwindow,
                   MMUslist *pasList );

/*\m*/

/*\p********************************************************************
**                                                                    **
    NAME:  WinMain

    PURPOSE:  to fire up the main application for fortune cookie

** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

static char *fcmSzAppname="FORTUNE";

int PASCAL WinMain( HANDLE pasInstance,
                    HANDLE pasPrevInstance,
                    LPSTR  , // pasCmdLine, - ignored
                    int    pasCmdShow )
{
/*********** Local Constant & Variable Declarations *******************/
int             fclOpenOk;
WNDCLASS        fclWndclass;
HWND            fclHwnd;
MSG             fclMsg;

/************************* Procedure Body *****************************/

if (!pasPrevInstance)
  {
  fclWndclass.style           = CS_HREDRAW | CS_VREDRAW;
  fclWndclass.lpfnWndProc     = (WNDPROC)WndProc;
  fclWndclass.cbClsExtra      = 0;
  fclWndclass.cbWndExtra      = DLGWINDOWEXTRA;
  fclWndclass.hInstance       = pasInstance;
  fclWndclass.hIcon           = LoadIcon(pasInstance,"FORTUNEICON");
  fclWndclass.hCursor         = LoadCursor( NULL, IDC_ARROW );
  fclWndclass.hbrBackground   = GetStockObject(LTGRAY_BRUSH);
  fclWndclass.lpszMenuName    = NULL; // No menu
  fclWndclass.lpszClassName   = fcmSzAppname;

  RegisterClass( &fclWndclass );

  fclHwnd = CreateDialog( pasInstance, fcmSzAppname, 0, NULL );

  }

ShowWindow ( fclHwnd, pasCmdShow );

while (GetMessage( &fclMsg, NULL, 0, 0))
  {
  TranslateMessage( &fclMsg );
  DispatchMessage( &fclMsg );
  }
fclOpenOk = fclMsg.wParam;

return(fclOpenOk);
} /* WinMain end */

/*\p********************************************************************
**                                                                    **
    NAME:  WndProc

    PURPOSE:  to handle window message processing for this
      dialog box application

** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/
static char          *fcmMsg;

long FAR PASCAL WndProc( HWND pasHwindow,
                         WORD pasMessage,
                         WORD pasWparam,
                         LONG pasLparam )
{
/*********** Local Constant & Variable Declarations *******************/
#define FCL_SLEN    120

static long           fclReturnVal      = NULL;
static HANDLE         fclHinstance      = NULL;
static HWND           fclHwndList       = NULL;
static FCAfortune    *fclFortune        = NULL;
static char          *fclPearlOfWisdom  = NULL;
static char          *fclFpath          = NULL;
static STAT_TYPE      fclErr;

/************************* Procedure Body *****************************/
fclReturnVal = 0;

switch ( pasMessage )
  {
  case WM_CREATE:
#if FCM_DEBUG
    MessageBox( pasHwindow, "WM_CREATE",
    "Ready to load fortune now.", MB_OK | MB_ICONASTERISK );
#endif
    fclHinstance = ((LPCREATESTRUCT)pasLparam)->hInstance;
    fclFpath = new char[FIP_MAX_NAME_LEN+1];
    *fclFpath = '\0';
    GetModuleFileName( fclHinstance, fclFpath, FIP_MAX_NAME_LEN);
    fclFortune = new FCAfortune( fclFpath );
    fclErr     = fclFortune->getFortuneCookieRandom();
    LIMDELA( fclFpath );    
    fcmMsg = new char[FCL_SLEN];
    break;
    
  case WM_PAINT:
    fclHwndList  = GetDlgItem( pasHwindow,
                               IDC_LIST1 );
    if (fclHwndList)
      {
      SendMessage( fclHwndList, LB_RESETCONTENT, 0, 0);
      sprintf(fcmMsg,"Honorable fortune cookie #%d says...",
              fclFortune->fcpFortuneCookieNum );
      SendMessage( fclHwndList, LB_INSERTSTRING,
                   (WPARAM)-1, (LPARAM)fcmMsg );
      fclPearlOfWisdom = fclFortune->fcpFortune->First();
      while (fclPearlOfWisdom)
        {
        SendMessage( fclHwndList, LB_INSERTSTRING,
                     (WPARAM)-1, (LPARAM)fclPearlOfWisdom );
        fclPearlOfWisdom = fclFortune->fcpFortune->Next();
        }
      // Highlight first line of list box that shows the current
      // Pearl-O-Wisdom
      SendMessage( fclHwndList, LB_SETCURSEL, 0, 0 );
      }
    else
      {
      MessageBox( pasHwindow, "Can't get List Box Handle!", NULL, MB_OK );
      }  
    fclReturnVal = DefWindowProc( pasHwindow, pasMessage,
                                  pasWparam, pasLparam );
    break;
    
  case WM_COMMAND:
    switch( pasWparam )
      {
      case IDOK:
      case IDCANCEL:
        LIMDEL( fclFortune );
        LIMDELA(fcmMsg);
        PostQuitMessage(0);
        break;
      case IDC_AGAIN_AGAIN:
        fclErr     = fclFortune->getFortuneCookieRandom();
        InvalidateRect( pasHwindow, NULL, TRUE );
        UpdateWindow( pasHwindow );
        break;
      case IDC_CUT:
        fcaCutNpaste( pasHwindow, fclFortune->fcpFortune );
        break;
      }
    break;

  case WM_DESTROY:
    LIMDEL( fclFortune );
    LIMDELA(fcmMsg);
    PostQuitMessage(0);
    break;

  default:
    fclReturnVal = DefWindowProc( pasHwindow, pasMessage,
                                  pasWparam, pasLparam );
    break;
  }

return(fclReturnVal);
} /* WndProc end */

/*\p********************************************************************
**                                                                    **
    NAME:  fcaCutNpaste

    PURPOSE:  to copy the list to the clipboard buffer.

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**\p*******************************************************************/

void fcaCutNpaste( HWND      pasHwindow,
                   MMUslist *pasList )
{
/*********** Local Constant & Variable Declarations *******************/
#define FCL_CRLF_LEN 2

HANDLE         fclHGMem ;
char          *fclPasteStr;

LPSTR         fclClStr;
long          fclSize;

/************************* Procedure Body *****************************/
OpenClipboard (pasHwindow);
EmptyClipboard();
fclPasteStr = pasList->First();

if (fclPasteStr)
  {
  fclSize = strlen(fcmMsg) + FCL_CRLF_LEN;
  while (fclPasteStr)
    {
    fclSize = fclSize + (long)strlen(fclPasteStr) + FCL_CRLF_LEN;
    fclPasteStr = pasList->Next();
    }
  fclSize += FCL_CRLF_LEN;
  fclHGMem = GlobalAlloc( GMEM_MOVEABLE | GMEM_DISCARDABLE,
                          fclSize+1 );
  if (fclHGMem)
    {
    fclClStr = GlobalLock(fclHGMem);
    if (fclClStr)
      {
      strcpy(fclClStr,fcmMsg);
      strcat(fclClStr,"\r\n");
      fclPasteStr = pasList->First();
      while (fclPasteStr)
        {
        strcat(fclClStr,fclPasteStr);
        strcat(fclClStr,"\r\n");
        fclPasteStr = pasList->Next();
        }
      GlobalUnlock(fclHGMem);
      SetClipboardData( CF_TEXT, fclHGMem );
      }
    }
  }

CloseClipboard();
MessageBeep(0);
}

