/*\t*******************************************************************/
/*    Last Edited .........  26-JAN-89 11:09:18                       */
/*    Filename  ...........  liidSys.h                                */
/*    Project .............  Library                                  */
/*    Author  .............  Dept. 257G                               */
/*    Drawing Number  .....  n/a                                      */
/*    Revision  ...........  01.00                                    */
/*    Language  ...........  C                                        */
/*    Operating System  ...  NONE                                     */
/*    Processor  ..........  NONE                                     */
/*    Function:                                                       */
/*                                                                    */
/*       Common type declarations and definitions.                    */
/*                                                                    */
/*\t*******************************************************************/

/*\r*******************************************************************/
/*                      REVISION HISTORY:                             */
/**********************************************************************/
/*
Date        By    Change Description
---------   ---   -------------------------------------------------
01-MAY-93   MJWR  Generate version specific to MSDOS & Windows
16-Sep-93   MJWR  Add DELETE and DELETEA macros for deleting
                  storage allocated with 'new'.  These macros
                  also set the pointer to NULL when done.
                  DELETEA is used for deleting ARRAYS of storage.
                  DELETE is used for all others.  For example:

                  int *oneInt = new int;
                  int *intAry = new int[20];
                  ...
                  DELETE(oneInt); // == delete oneInt; oneInt = NULL;
                  DELETEA(intAry);// == delete [] intAry; intAry = NULL;
06-Jun-94    MJWR DELETE and DELETEA macros conflict with Microsoft Foundation
                  Classes.  Consider these obsolete and use LIMDEL and LIMDELA
                  respectively.                  

 *\r*/

/**********************************************************************/
/*                             Definitions                            */
/**********************************************************************/

#ifndef _LIIDSYS_H_                     /* tell other include files   */
#define _LIIDSYS_H_                     /* this was included.         */

typedef  unsigned short     BOOLEAN;
typedef  unsigned char      BITS;
typedef  char               CHAR;

// Character pointer, 'far' modifier
// for IBM PC's so they are stuck
// in separate segments, not in
// automatic data segment along with
// the stack.

#define CHARPTR char *

typedef  signed char        INT8;

/**** 'ifdef' and 'ifndef' only work
* on #define's, they don't work on typedef.
* So we use a separate #define to indicate
* that a particular type has been
* defined
*/

#ifndef INT16_DEF
#define INT16_DEF
typedef int                 INT16;
#endif

#ifndef INT32_DEF
#define INT32_DEF
typedef  long int           INT32;
#endif

typedef  unsigned char      UINT8;
typedef  unsigned int       UINT16;
typedef  unsigned long int  UINT32;
typedef  float              FLOAT32;
typedef  double             FLOAT64;
typedef  int                INT;
typedef  void               VOID_RTN;

#define  FALSE_             (0)
#define  TRUE_              (1)

#define  GLOBAL

enum STAT { SUCCEEDED_ = 1,
            FAILED_    = -1 };

typedef enum STAT STAT_TYPE;

/****************************************
* STAT_TYPE is the commonly used error
* (or status) return type. However,
* some older software used the two
* definitions below. Accomodate them too.
*/

#define STAT_TY     STAT_TYPE
#define STATUS_TYPE STAT_TYPE

#define  RET_CODE_TY        INT32
#define  RET_CODE_TYPE      INT32

#define VOID_TYPE         void


/****************************************
* Common character definitioins.
*/

#define LIP_CHAR_PCT    37 /* The '%' character */


/******************************************
* C++ Support macros
*/             

#define LIMDEL(A)  if (A) { delete A; A = NULL; }
#define LIMDELA(A) if (A) { delete [] A; A = NULL; }

/****************************************
* For MS-DOS define LOCAL as 'static far'
* which allows us to have more static
* data storage.  For all otehr computers
* define LOCAL as 'static'
*/                    

/* NOTE: Microsoft and Borland used to implement
   DOS specific functions exactly the SAME. Now
   Microsoft has decided to use an underscore
   prefix.  Stoooopid.  Use defines in the section
   below to handle this.
*/
   
#ifdef _MSC_VER
#define LOCAL static

#define mkdir _mkdir
#define getdisk _getdrive
#define getcwd _getcwd
#define FP_OFF _FP_OFF
#define FP_SEG _FP_SEG
#define MK_FP _MK_FP
#define REGS _REGS
#define SREGS _SREGS
#define int86 _int86
#define int86x _int86x

#else
#define LOCAL static far
#endif

#endif
