/*\t*******************************************************************/
/*    Last Edited .........  26-Sep-90   09:04:15                     */
/*    Filename  ...........  liuStrg.h                                */
/*    Project .............  AIS                                      */
/*    Author  .............  S. Balsarotti & M. Ratcliff              */
/*    Drawing Number  .....  n/a                                      */
/*    Revision  ...........  1.00                                     */
/*    Language  ...........  C                                        */
/*    Operating System  ...  NONE                                     */
/*    Processor  ..........  n/a                                      */
/*    Function:                                                       */
/*      String processing utilities                                   */
/*                                                                    */
/*\t*******************************************************************/

/*\r*******************************************************************/
/*                         Revision History                           */
/**********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
10-NOV-92  MJWR         Add LIUstripLeadingBlanks, LIUstripTrailingBlanks
                        prototypes.

**\r*/

/*\m*******************************************************************/
/*                       Definitions                                  */
/**********************************************************************/

STAT_TYPE LIUmakeUppercase 
(                            /* Copy string using all uppercase characters  */
   const CHAR  *pasInstringPtr,
   CHAR        *refOutstringPtr
 );

STAT_TYPE LIUreplaceChar  /* Translate specified character in string  */
(  CHAR  *refText,   
   CHAR   pasSrc,
   CHAR   pasTar     
   );

STAT_TYPE LIUintToString
(                      /* Get ASCII string for integer & add decimal point  */
   INT32  pasInt,     
   INT32  pasShift,   
   INT32  pasStrLen,  
   CHAR  *refStr      
   );

INT32 LIUstrcmpi                 /* Compare strings, case-insensitive  */
(  const CHAR  *pasStr1,
   const CHAR  *pasStr2
   );

INT32 LIUstrcmp                 /* Compare strings, case-sensitive  */
(  const CHAR  *pasStr1,
   const CHAR  *pasStr2
   );

CHAR *LIUstrstr (                      /* Find substring within string  */
   const CHAR  *pasStr1,
   const CHAR  *pasStr2
   );

STAT_TYPE LIUfindSubfield
(                              /* Get number of subfield matching template  */
   const CHAR       *pasListPtr,
   const CHAR       *pasItemPtr,
   INT32            *refPosition    
   );

STAT_TYPE LIUsort(         /* Sort an array of strings alphabetically  */
   INT32  pasNumItems,        
   CHAR  *refItemListPtr[]    
   );

INT32 LIUstrncmpi (               /* Compare strings, case-insensitive  */
   const CHAR  *pasStr1,
   const CHAR  *pasStr2,
   INT32        pasNum
);

CHAR *LIUstrstri (                     /* Find substring within string  */
   const CHAR  *pasStr1,
   const CHAR  *pasStr2
);

CHAR *LIUstrchri (                /* Compare strings, case-insensitive  */
   const CHAR  *pasStr,
   CHAR         pasChar
);

STAT_TYPE LIUstripLeadingBlanks
( CHAR *refStr );

STAT_TYPE LIUstripTrailingBlanks
( CHAR *refStr );

STAT_TYPE LIUstripLTblanks /* strip leading & trailing blanks */
( CHAR *refStr );

INT32 LIUisWhiteSpace
( INT32 pasCh ); /* TRUE_ if blank character such as ' ' or '\n' */

/****************************************
* Same as 'strncpy' but guarantees the
* destination string is "NULL terminated"
*/

STAT_TYPE LIUstrncpy(CHAR            *refDest,
                     const CHAR      *pasSrc,
                     INT32            pasDestBufSize );

/****************************************
* Strip leading and trailing blanks, then
* convert all embedded blanks to
* underscore characters.
*/

STAT_TYPE LIUstripULblanks( CHAR *refStr );

STAT_TYPE LIUstripLeadingChars( int     pasCharToStrip,
                                CHAR   *refStr );

STAT_TYPE LIUstripTrailingChars( int    pasCharToStrip,
                                 CHAR  *refStr );

STAT_TYPE LIUstripLTchars ( int   pasCharToStrip,
                            CHAR *refStr );

/* Is the string all one character, each
 * character being equal to pasCharToCheck.
 * If so, return TRUE_, else return FALSE_.
 */

BOOLEAN LIUisAllOneChar( int            pasCharToCheck,
                         const CHAR    *pasStr );

STAT_TYPE LIUfortranToCstr
(INT32          pasFortranStringLen,
 const CHAR    *pasFortranString,
 CHAR          *refCstring );

STAT_TYPE LIUcToFortranStr
(INT32          pasFortranStringLen,
 const CHAR    *pasCstring,
 CHAR          *refFortranString );

/****************************************
* Find last occurrence of pasChar in
* pasStr. Return pointer to it or NULL
*/
CHAR *LIUstrchrLast
(const CHAR *pasStr,
 CHAR        pasChar);

/****************************************
* Same as above but case insensitive.
*/
CHAR *LIUstrchriLast
(const CHAR    *pasStr,
 CHAR           pasChar);

/****************************************
* If the passed integer value == 1 then
* return an empty string, else return "s".
*/
const char *LIUgetPlural( INT32 pasCount );

const char *LIUgetAblankStr( );

char *LIUgetAcharStr( int pasCharToGet,
                      int pasLenOfStr );

STAT_TYPE LIUdeleteAcharStr( char **pasAcharStr );

