/*\t*******************************************************************/
/*    Creation Date .......  Thu  05-20-1993  12:52:35                */
/*    Filename  ...........  mmulist.cpp                              */
/*    Project .............  Memory Management                        */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS/Windows                              */
/*    Processor  ..........  MMU - Memory Management Utilities        */
/*    Function:         Linked list package.                          */
/*                                                                    */
/* Matthew Ratcliff's linked list class definitions. There are NO     */
/* INHERENT LIMITATIONS to this doubly linked list class.  Can't say  */
/* that about most other link list functions provided by Microsoft &  */
/* Borland libraries.                                                 */
/*                                                                    */
/* As of July 1994 I have over 150,000 lines of Windows & DOS         */
/* application C++ software that depend on this linked list class and */
/* its subclasses.  It works flawlessly.  It has been used in a Windoz*/
/* file viewer utility to view the entire contents of an ASCII file   */
/* containing 560 character lines, a total of 14 megabytes in size!   */
/* Try that with your Borland or Microsoft tools!                     */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
20-May-93  MJWR         Implement C++ linked list package.

**\r*/

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/********************** Constant Include Files ************************/
#include "liidSys.h"
#include "mmplist.h"
#include "mmglist.h"

/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/
#include "mmulist.h"


/*\i*/

/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\m*/

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::MMUllist

    PURPOSE:  to construct a linked list.

**                                                                    **
**                                                                    **
**\p*******************************************************************/

MMUllist::MMUllist()

{ /* MMUllist::MMUllist procedure */

/******************* Local Constant Declarations **********************/
/* Proc name for error log */
//CHARPTR MML_PROC_NAME = "MMUllist::MMUllist";

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

head            = NULL;
tail            = NULL;
current         = NULL;
numEntries      = 0L;

} /* MMUllist::MMUllist end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::~MMUllist

    PURPOSE:  to destroy an existing list.

**                                                                    **
**                                                                    **
**\p*******************************************************************/

MMUllist::~MMUllist()

{ /* MMUllist::~MMUllist procedure */

/******************* Local Constant Declarations **********************/
/* Proc name for error log */
//CHARPTR MML_PROC_NAME = "MMUllist::~MMUllist";

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

if (numEntries != 0L)
  {
  DeleteList();
  }

} /* MMUllist::~MMUllist end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::mmuSetFirstEntry

    PURPOSE:  to set the first entry in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::mmuSetFirstEntry( MMG_LLIST_TY *pasEntry )

{ /* MMUllist::mmuSetFirstEntry procedure */
/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = SUCCEEDED_;

numEntries              =       1L;
pasEntry->prev          =       NULL;
pasEntry->next          =       NULL;
current                 =       pasEntry;
head                    =       current;
tail                    =       current;

return(mmlErr);
} /* MMUllist::mmuSetFirstEntry end */


/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::mmuCreateEntry

    PURPOSE:  to create storage for a new entry and return a pointer
      to it.  If unable to allocate the storage, return a NULL
      pointer.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlPtr             FNC    MMG_LLIST_TY *, new buffer dude.       **
**\p*******************************************************************/

MMG_LLIST_TY *MMUllist::mmuCreateEntry( INT32     pasSizeofBuf,
                                         void     *pasBufPtr )

{ /* mmuCreateEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMG_LLIST_TY    *mmlPtr;

/************************* Procedure Body *****************************/

mmlPtr = NULL;

if (pasSizeofBuf > 0 && pasBufPtr != NULL)
  {
  mmlPtr = new MMG_LLIST_TY;

  if (mmlPtr)
    {
    mmlPtr->prev          = NULL;
    mmlPtr->next          = NULL;
    mmlPtr->buf.size      = pasSizeofBuf;
    mmlPtr->buf.body      = new char[(unsigned)pasSizeofBuf];
    if (mmlPtr->buf.body)
      {
      memcpy(mmlPtr->buf.body, pasBufPtr, (unsigned)pasSizeofBuf);
      }
    }

  }
return(mmlPtr);
} /* mmuCreateEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::mmuDestroyEntry

    PURPOSE:  to destroy an existing list entry.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::mmuDestroyEntry( MMG_LLIST_TY *refEntry )

{ /* mmuDestroyEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = FAILED_;

if (refEntry != NULL)
  {
  mmlErr = SUCCEEDED_;
  if (refEntry->buf.body)
    {
    LIMDELA(refEntry->buf.body);
    refEntry->buf.body = NULL;
    }
  LIMDEL(refEntry);
  }

return(mmlErr);
} /* mmuDestroyEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertBeforeHead

    PURPOSE:  to insert a new entry before the head of the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertBeforeHead( MMP_DATA_TY &pasEntry )

{ /* MMUllist::InsertBeforeHead procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/

mmlErr = InsertBeforeHead( pasEntry.size, pasEntry.body );

return(mmlErr);
} /* MMUllist::InsertBeforeHead end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::AppendAfterTail

    PURPOSE:  to insert a new entry after the end of the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::AppendAfterTail( MMP_DATA_TY &pasEntry )

{ /* MMUllist::AppendAfterTail procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/

mmlErr = AppendAfterTail( pasEntry.size, pasEntry.body );

return(mmlErr);
} /* MMUllist::AppendAfterTail end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertBeforeCurrent

    PURPOSE:  to insert a new entry before the current entry
        in the list

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertBeforeCurrent( MMP_DATA_TY &pasEntry )

{ /* MMUllist::InsertBeforeCurrent procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/

mmlErr = InsertBeforeCurrent( pasEntry.size, pasEntry.body );

return(mmlErr);
} /* MMUllist::InsertBeforeCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertAfterCurrent

    PURPOSE:  to insert a new entry after the current entry
        in the list

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertAfterCurrent( MMP_DATA_TY &pasEntry )

{ /* MMUllist::InsertAfterCurrent procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/

mmlErr = InsertAfterCurrent( pasEntry.size, pasEntry.body );

return(mmlErr);
} /* MMUllist::InsertAfterCurrent end */


/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertBeforeHead

    PURPOSE:  to insert a new entry before the head of the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertBeforeHead( INT32             pasSizeofBuf,
                                      void             *pasBufPtr )

{ /* MMUllist::InsertBeforeHead procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;
MMG_LLIST_TY           *mmlEntry;
MMG_LLIST_TY           *mmlPtr;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = FAILED_;

if (pasSizeofBuf > 0)
  {
  mmlEntry = mmuCreateEntry( pasSizeofBuf, pasBufPtr );
  if (mmlEntry != NULL && head != NULL)
    {
    mmlErr              = SUCCEEDED_;
    mmlPtr              = head;
    mmlPtr->prev        = mmlEntry;
    mmlEntry->prev      = NULL;
    mmlEntry->next      = head;
    current             = mmlEntry;
    head                = mmlEntry;
    numEntries++;
    }
  else if (mmlEntry != NULL) // first entry
    {
    mmlErr = mmuSetFirstEntry( mmlEntry );
    }
  }

return(mmlErr);
} /* MMUllist::InsertBeforeHead end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::AppendAfterTail

    PURPOSE:  to insert a new entry after the end of the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::AppendAfterTail( INT32             pasSizeofBuf,
                                      void             *pasBufPtr )

{ /* MMUllist::AppendAfterTail procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;
MMG_LLIST_TY           *mmlEntry;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = FAILED_;

if (pasSizeofBuf > 0)
  {
  mmlEntry = mmuCreateEntry( pasSizeofBuf, pasBufPtr );
  if (mmlEntry != NULL && tail != NULL)
    {
    mmlErr              = SUCCEEDED_;
    tail->next          = mmlEntry;
    mmlEntry->prev      = tail;
    mmlEntry->next      = NULL;
    tail                = mmlEntry;
    current             = mmlEntry;
    numEntries++;
    }
  else if (mmlEntry != NULL) // first entry
    {
    mmlErr = mmuSetFirstEntry( mmlEntry );
    }
  }

return(mmlErr);
} /* MMUllist::AppendAfterTail end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertBeforeCurrent

    PURPOSE:  to insert a new entry before the current entry in
       the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertBeforeCurrent( INT32             pasSizeofBuf,
                                         void             *pasBufPtr )

{ /* MMUllist::InsertBeforeCurrent procedure */

/******************* Local Constant Declarations **********************/
/* Proc name for error log */
//CHARPTR MML_PROC_NAME = "MMUllist::InsertBeforeCurrent";

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;
MMG_LLIST_TY           *mmlEntry;
MMG_LLIST_TY           *mmlPrev;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = FAILED_;

if (pasSizeofBuf > 0)
  {
  if (current == head)
    {
    mmlErr = InsertBeforeHead( pasSizeofBuf, pasBufPtr );
    }
  else
    {
    mmlErr = SUCCEEDED_;
    mmlEntry = mmuCreateEntry( pasSizeofBuf, pasBufPtr );
    if (mmlEntry != NULL && current != NULL)
      {
      mmlPrev             = current->prev;
      mmlEntry->prev      = current->prev;
      mmlEntry->next      = current;
      current->prev       = mmlEntry;
      if (mmlPrev != NULL)
        {
        mmlPrev->next = mmlEntry;
        }
      current = mmlEntry;
      numEntries++;
      }
    else if (mmlEntry != NULL) // first entry
      {
      mmlErr = mmuSetFirstEntry( mmlEntry );
      }
    }
  }

return(mmlErr);
} /* MMUllist::InsertBeforeCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertAfterCurrent

    PURPOSE:  to insert a new entry after the current entry in
       the list, such that Next() will return THIS entry,
       without affecting what is NOW CURRENT.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertAfterCurrent( INT32             pasSizeofBuf,
                                         void             *pasBufPtr )

{ /* MMUllist::InsertAfterCurrent procedure */
/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;
MMG_LLIST_TY           *mmlEntry;
MMG_LLIST_TY           *mmlNext;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = FAILED_;

if (pasSizeofBuf > 0)
  {
  if (current == tail)
    {
    mmlErr = AppendAfterTail( pasSizeofBuf, pasBufPtr );
    Prev();
    }
  else
    {
    mmlErr = SUCCEEDED_;
    mmlEntry = mmuCreateEntry( pasSizeofBuf, pasBufPtr );
    if (mmlEntry != NULL && current != NULL)
      {
      mmlNext             = current->next;
      current->next       = mmlEntry;
      mmlEntry->next      = mmlNext;
      mmlEntry->prev      = current;
      numEntries++;
      }
    else if (mmlEntry != NULL) // first entry
      {
      mmlErr = mmuSetFirstEntry( mmlEntry );
      }
    }
  }

return(mmlErr);
} /* MMUllist::InsertAfterCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::DeleteCurrentEntry

    PURPOSE:  to delete the current entry in the list.
      Current becomes current->next.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::DeleteCurrentEntry()

{ /* MMUllist::DeleteCurrentEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;
MMG_LLIST_TY           *mmlEntry;
MMG_LLIST_TY           *mmlCurrent0;
MMG_LLIST_TY           *mmlCurrent1;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = SUCCEEDED_;

if (current != NULL && numEntries != 0)
  {
  if (numEntries == 1)
    {
    mmlEntry   = head;
    mmlErr     = mmuDestroyEntry( mmlEntry );
    numEntries = 0;
    head       = NULL;
    tail       = NULL;
    current    = NULL;
    }
  else
    {
    if (current == head)
      { // delete head entry
      mmlEntry = head;
      head     = head->next;
      current  = head;
      mmlErr   = mmuDestroyEntry( mmlEntry );
      }
    else if (current == tail)
      {
      mmlEntry = tail;
      tail     = tail->prev;
      current  = tail;
      mmlErr   = mmuDestroyEntry( mmlEntry );
      }
    else
      { // Extract entry and mend over the hole
      mmlEntry          = current;
      mmlCurrent0       = current->prev;
      mmlCurrent1       = current->next;
      mmlCurrent0->next = mmlCurrent1;
      mmlCurrent1->prev = mmlCurrent0;
      mmlErr            = mmuDestroyEntry( mmlEntry );
      current           = mmlCurrent1;
      }
    numEntries--;
    }
  }

return(mmlErr);
} /* MMUllist::DeleteCurrentEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::DeleteList

    PURPOSE:  to delete all entries entry in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::DeleteList()

{ /* MMUllist::DeleteList procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE               mmlErr;
MMG_LLIST_TY           *mmlEntry;
MMG_LLIST_TY           *mmlNext;

/************************* Procedure Body *****************************/
/* Initialize return val   */
mmlErr = SUCCEEDED_;

if (current != NULL && numEntries != 0)
  {
  mmlEntry = head;
  mmlNext  = head->next;
  while (mmlEntry != NULL)
    {
    mmlErr   = mmuDestroyEntry( mmlEntry );
    mmlEntry = mmlNext;
    if (mmlNext != NULL)
      {
      mmlNext  = mmlNext->next;
      }
    }
  numEntries = 0;
  head       = NULL;
  tail       = NULL;
  current    = NULL;
  }

return(mmlErr);
} /* MMUllist::DeleteList end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::First

    PURPOSE:  to return the address of the first data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    MMP_DATA_TY *, address of data buffer  **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::First( )

{ /* MMUllist::First procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;

/************************* Procedure Body *****************************/

if (numEntries != 0L)
  {
  mmlDat  = &head->buf;
  current = head;
  }

return(mmlDat);
} /* MMUllist::First end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::Last

    PURPOSE:  to return the address of the last data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    MMP_DATA_TY *, address of data buffer  **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::Last( )

{ /* MMUllist::Last procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;

/************************* Procedure Body *****************************/

if (numEntries != 0L)
  {
  mmlDat  = &tail->buf;
  current = tail;
  }

return(mmlDat);
} /* MMUllist::Last end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::Next

    PURPOSE:  to return the address of the next data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    MMP_DATA_TY *, address of data buffer  **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::Next( )

{ /* MMUllist::Next procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;

/************************* Procedure Body *****************************/

if (numEntries != 0L)
  {
  if (current != tail)
    {
    current = current->next;
    mmlDat  = &current->buf;
    }
  }

return(mmlDat);
} /* MMUllist::Next end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::Prev

    PURPOSE:  to return the address of the previous data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    MMP_DATA_TY *, address of data buffer  **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::Prev( )

{ /* MMUllist::Prev procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;

/************************* Procedure Body *****************************/

if (numEntries != 0L)
  {
  if (current != head)
    {
    current = current->prev;
    mmlDat  = &current->buf;
    }
  }

return(mmlDat);
} /* MMUllist::Prev end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::Current

    PURPOSE:  to return the address of the current data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    MMP_DATA_TY *, address of data buffer  **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::Current( )

{ /* MMUllist::Current procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;

/************************* Procedure Body *****************************/

if (numEntries != 0L)
  {
  if (current != NULL)
    {
    mmlDat  = &current->buf;
    }
  }

return(mmlDat);
} /* MMUllist::Current end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::NumEntries

    PURPOSE:  to return the count of the number of entries
      currently in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   numEntries         FNC    # of entries in list, currently        **
**\p*******************************************************************/

INT32 MMUllist::NumEntries( )

{ /* MMUllist::NumEntries procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

return(numEntries );

} /* MMUllist::NumEntries end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::Indexed

    PURPOSE:  to return the address of the indexed data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    MMP_DATA_TY *, address of data buffer  **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::Indexed( INT32 pasIndex )

{ /* MMUllist::Indexed procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
INT32        mmlCt;

/************************* Procedure Body *****************************/

if (numEntries > pasIndex)
  {
  current = head;
  mmlCt   = pasIndex;
  while (mmlCt != 0 && current != NULL)
    {
    current = current->next;
    mmlCt--;
    }
  if (current != NULL)
    {
    mmlDat = &current->buf;
    }
  }

return(mmlDat);
} /* MMUllist::Indexed end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertSorted

    PURPOSE:  to insert a record sorted, based on the user's
      "compare" function pointer



**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE  MMUllist::InsertSorted
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  INT32  pasSizeOfBuf,
  void  *pasBufPtr )

{ /* MMUllist::InsertSorted procedure */

/******************* Local Constant Declarations **********************/
/* Proc name for error log */

#define MML_INSERT_AT_HEAD      0
#define MML_INSERT_AT_CURRENT   1
#define MML_INSERT_AT_TAIL      2

/******************* Local Variable Declarations **********************/
/* error return flag       */
STAT_TYPE                mmlErr;
MMG_LLIST_TY            *mmlEntry;
int                      mmlCmp;
int                      mmlExit;
int                      mmlCommand;

/************************* Procedure Body *****************************/
mmlErr = FAILED_;

if (numEntries == 0)
  {
  mmlErr = AppendAfterTail( pasSizeOfBuf, pasBufPtr );
  }
else
  {
  mmlEntry     = head;
  mmlExit      = FALSE_;
  mmlCommand   = MML_INSERT_AT_HEAD;
  while (mmlExit == FALSE_)
    {
    mmlCmp = pasFncCompare( pasBufPtr, mmlEntry->buf.body );
    if (mmlCmp >= 0)
      {
      mmlExit     = TRUE_;
      mmlCommand  = MML_INSERT_AT_CURRENT;
      current     = mmlEntry;
      }
    else
      {
      mmlEntry = mmlEntry->next;
      if (mmlEntry == NULL)
        {
        mmlExit = TRUE_;
        mmlCommand = MML_INSERT_AT_TAIL;
        }
      }
    }
  if (mmlCommand == MML_INSERT_AT_HEAD)
    {
    mmlErr = InsertBeforeHead( pasSizeOfBuf, pasBufPtr );
    }
  else if (mmlCommand == MML_INSERT_AT_CURRENT)
    {
    mmlErr = InsertBeforeCurrent( pasSizeOfBuf, pasBufPtr );
    }
  else // MML_INSERT_AT_TAIL
    {
    mmlErr = AppendAfterTail( pasSizeOfBuf, pasBufPtr );
    }
  }

return(mmlErr);
} /* MMUllist::InsertSorted end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::InsertSorted

    PURPOSE:  to insert a record sorted, based on the user's
      "compare" function pointer



**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUllist::InsertSorted
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  MMP_DATA_TY &pasEntry )

{ /* MMUllist::InsertSorted procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/

/************************* Procedure Body *****************************/

return( InsertSorted( pasFncCompare, pasEntry.size, pasEntry.body ));

} /* MMUllist::InsertSorted end */


/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::FindFirstEntry

    PURPOSE:  to find the first ocurrence of an entry in the list.
      The caller provides the address of a function that performs
      the comparison.  We step through the list, starting at
      the head, performing the compare. When the compare returns
      a 0, we return the current datum pointer.  If end of list
      is reached first, return a NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDatum           FNC    MMP_DATA_TY *, addr of matched value   **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::FindFirstEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr,
  INT32 &refIndexFound )

{ /* MMUllist::FindFirstEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMG_LLIST_TY            *mmlEntry;
MMP_DATA_TY             *mmlDatum;
int                      mmlExit;
int                      mmlCmp;
/************************* Procedure Body *****************************/
mmlDatum        = NULL;
refIndexFound   = -1L;

if (pasBufPtr != NULL)
  {
  if (numEntries == 1)
    {
    mmlDatum = First();
    mmlCmp = pasFncCompare( (void*)mmlDatum->body, pasBufPtr );
    if (mmlCmp != 0) mmlDatum = NULL;
    else             refIndexFound = 0L;
    }
  else if (numEntries > 1)
    {
    mmlEntry     = head;
    refIndexFound= 0L;
    mmlExit      = FALSE_;
    while (mmlExit == FALSE_)
      {
      mmlCmp = pasFncCompare( pasBufPtr, mmlEntry->buf.body );
      if (mmlCmp == 0)
        {
        mmlExit     = TRUE_;
        mmlDatum    = &mmlEntry->buf;
        }
      else
        {
        mmlEntry = mmlEntry->next;
        refIndexFound++;
        if (mmlEntry == NULL)
          {
          mmlExit       = TRUE_;
          refIndexFound = -1L;
          }
        }
      }
    }
  }

if (mmlDatum != NULL)
  {
  current = mmlEntry;
  }

return(mmlDatum);
} /* MMUllist::FindFirstEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::FindFirstEntry

    PURPOSE:  to find the first ocurrence of an entry in the list.
      The caller provides the address of a function that performs
      the comparison.  We step through the list, starting at
      the head, performing the compare. When the compare returns
      a 0, we return the current datum pointer.  If end of list
      is reached first, return a NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDatum           FNC    MMP_DATA_TY *, addr of matched value   **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::FindFirstEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr )

{ /* MMUllist::FindFirstEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
INT32                   mmlBurnIt;
MMP_DATA_TY            *mmlDatum;

/************************* Procedure Body *****************************/

mmlDatum = FindFirstEntry( pasFncCompare, pasBufPtr, mmlBurnIt );

return(mmlDatum);

} /* MMUllist::FindFirstEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::FindNextEntry

    PURPOSE:  to find the next ocurrence of an entry in the list.
      The caller provides the address of a function that performs
      the comparison.  We step through the list, starting at
      the current->next entry, performing the compare. When the compare
      returns a 0, we return the current datum pointer.  If end of list
      is reached first, return a NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDatum           FNC    MMP_DATA_TY *, addr of matched value   **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::FindNextEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr )

{ /* MMUllist::FindNextEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMG_LLIST_TY            *mmlEntry;
MMP_DATA_TY             *mmlDatum;

int                      mmlExit;
int                      mmlCmp;
/************************* Procedure Body *****************************/
mmlDatum        = NULL;
if (numEntries > 0)
  {
  mmlEntry     = current->next;
  if (mmlEntry != NULL)
    {
    mmlExit      = FALSE_;
    while (mmlExit == FALSE_)
      {
      mmlCmp = pasFncCompare( pasBufPtr, mmlEntry->buf.body );
      if (mmlCmp == 0)
        {
        mmlExit     = TRUE_;
        mmlDatum    = &mmlEntry->buf;
        }
      else
        {
        mmlEntry = mmlEntry->next;
        if (mmlEntry == NULL)
          {
          mmlExit = TRUE_;
          }
        }
      }
    }
  }

if (mmlDatum != NULL)
  {
  current = mmlEntry;
  }

return(mmlDatum);
} /* MMUllist::FindNextEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::FindNextEntry

    PURPOSE:  to find the next ocurrence of an entry in the list.
      The caller provides the address of a function that performs
      the comparison.  We step through the list, starting at
      the current->next entry, performing the compare. When the compare
      returns a 0, we return the current datum pointer.  If end of list
      is reached first, return a NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDatum           FNC    MMP_DATA_TY *, addr of matched value   **
**\p*******************************************************************/

MMP_DATA_TY *MMUllist::FindNextEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr,
  INT32 &refIndexFound )

{ /* MMUllist::FindNextEntry procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY             *mmlDatum;
/************************* Procedure Body *****************************/

refIndexFound   = -1L;
mmlDatum        = FindNextEntry( pasFncCompare, pasBufPtr );

if (mmlDatum != NULL)
  {
  refIndexFound = GetIndexOfCurrent();
  }

return(mmlDatum);
} /* MMUllist::FindNextEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::GetIndexOfCurrent

    PURPOSE:  to get the numerical index of the current entry.
      This can be SLOW.  That is, this package does not maintain
      an index of the current entry....for speed considerations.
      However, sometimes you want to know the "n'th" position of
      the current entry.  This guy can find it.  It uses
      pointer comparisons, so it isn't too bad.  If it is VERY
      IMPORTANT to maintain a current index to the current
      entry, then add it to the private: portion of this class
      and modify ALL member functions which modify the 'current'
      entry. Return -1 if empty list or other error.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlInx             FNC    INT32, index of current entry          **
**\p*******************************************************************/

INT32 MMUllist::GetIndexOfCurrent()

{ /* MMUllist::GetIndexOfCurrent procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
INT32           mmlInx;
MMG_LLIST_TY   *mmlEntry;

/************************* Procedure Body *****************************/

if (numEntries == 0)
  {
  mmlInx = -1;
  }
else if (current == head)
  {
  mmlInx = 0;
  }
else if (current == tail)
  {
  mmlInx = numEntries-1;
  }
else
  {
  mmlEntry = head->next;
  mmlInx   = 1;
  while (mmlEntry != NULL && mmlEntry != current)
    {
    mmlEntry = mmlEntry->next;
    mmlInx++;
    }
  if (mmlEntry == NULL)
    {
    mmlInx = -1;
    }
  }

return(mmlInx);
} /* MMUllist::GetIndexOfCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist::CopyTo

    PURPOSE:  to copy contents of this list to the specified
      destination list.
**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    STAT_TYPE, SUCCEEDED or FAILED         **
**\p*******************************************************************/

STAT_TYPE MMUllist::CopyTo( MMUllist *refList )

{
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
STAT_TYPE    mmlErr;

/************************* Procedure Body *****************************/

if (numEntries > 0)
  {
  mmlDat = MMUllist::First();
  mmlErr = SUCCEEDED_;
  while (mmlDat && mmlErr == SUCCEEDED_)
    {
    mmlErr = refList->AppendAfterTail( mmlDat->size,
                                       mmlDat->body );
    if (mmlErr == SUCCEEDED_)
      {
      mmlDat = MMUllist::Next();
      }
    }
  }

return(mmlErr);
}

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::MMUvlist

    PURPOSE:  to construct a linked list.

**                                                                    **
**                                                                    **
**\p*******************************************************************/

MMUvlist::MMUvlist()

{ /* MMUvlist::MMUvlist procedure */
/************************* Procedure Body *****************************/

mmhList = new MMUllist();

} /* MMUvlist::MMUvlist end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::~MMUvlist

    PURPOSE:  to destroy an existing list.

**                                                                    **
**                                                                    **
**\p*******************************************************************/

MMUvlist::~MMUvlist()

{ /* MMUvlist::~MMUvlist procedure */

LIMDEL(mmhList);

} /* MMUvlist::~MMUvlist end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::InsertBeforeHead

    PURPOSE:  to insert a new entry before the head of the list.
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUvlist::InsertBeforeHead( INT32             pasSizeofBuf,
                                      void             *pasBufPtr )

{ /* MMUvlist::InsertBeforeHead procedure */
/************************* Procedure Body *****************************/

return(mmhList->InsertBeforeHead( pasSizeofBuf, pasBufPtr ));

} /* MMUvlist::InsertBeforeHead end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::AppendAfterTail

    PURPOSE:  to insert a new entry after the end of the list.
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUvlist::AppendAfterTail( INT32             pasSizeofBuf,
                                      void             *pasBufPtr )

{ /* MMUvlist::AppendAfterTail procedure */
/************************* Procedure Body *****************************/
return(mmhList->AppendAfterTail( pasSizeofBuf, pasBufPtr ));
} /* MMUvlist::AppendAfterTail end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::InsertBeforeCurrent

    PURPOSE:  to insert a new entry before the current entry in
       the list.
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUvlist::InsertBeforeCurrent( INT32             pasSizeofBuf,
                                         void             *pasBufPtr )

{ /* MMUvlist::InsertBeforeCurrent procedure */
/************************* Procedure Body *****************************/
return(mmhList->InsertBeforeCurrent( pasSizeofBuf, pasBufPtr));
} /* MMUvlist::InsertBeforeCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::InsertAfterCurrent

    PURPOSE:  to insert a new entry after the current entry in
       the list
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUvlist::InsertAfterCurrent( INT32             pasSizeofBuf,
                                         void             *pasBufPtr )

{ /* MMUvlist::InsertAfterCurrent procedure */
/************************* Procedure Body *****************************/
return(mmhList->InsertAfterCurrent( pasSizeofBuf, pasBufPtr));
} /* MMUvlist::InsertAfterCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::DeleteCurrentEntry

    PURPOSE:  to delete the current entry in the list.
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUvlist::DeleteCurrentEntry()

{ /* MMUvlist::DeleteCurrentEntry procedure */
return(mmhList->DeleteCurrentEntry());
} /* MMUvlist::DeleteCurrentEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::DeleteList

    PURPOSE:  to delete all entries entry in the list.
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUvlist::DeleteList()

{ /* MMUvlist::DeleteList procedure */
/************************* Procedure Body *****************************/
return(mmhList->DeleteList());
} /* MMUvlist::DeleteList end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::First
    NAME:  MMUvlist::Last
    NAME:  MMUvlist::Next
    NAME:  MMUvlist::Prev
    NAME:  MMUvlist::Current
    NAME:  MMUvlist::Indexed

    PURPOSE:  to return the address of the indicated data item
      in the list.  On error return NULL.
**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlVdat            FNC    void *, address of data buffer         **
**\p*******************************************************************/

void *MMUvlist::First( )

{ /* MMUvlist::First procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
void        *mmlVdat= NULL;

/************************* Procedure Body *****************************/
mmlDat = mmhList->First();

if (mmlDat)
  {
  mmlVdat = mmlDat->body;
  }
return(mmlVdat);
} /* MMUvlist::First end */

/****************************************
* Last
*/
void *MMUvlist::Last( )

{ /* MMUvlist::Last procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
void        *mmlVdat= NULL;

/************************* Procedure Body *****************************/
mmlDat = mmhList->Last();

if (mmlDat)
  {
  mmlVdat = mmlDat->body;
  }
return(mmlVdat);
} /* MMUvlist::Last end */

/****************************************
* Next
*/
void *MMUvlist::Next( )
{ /* MMUvlist::Next procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
void        *mmlVdat= NULL;

/************************* Procedure Body *****************************/
mmlDat = mmhList->Next();

if (mmlDat)
  {
  mmlVdat = mmlDat->body;
  }
return(mmlVdat);
} /* MMUvlist::Next end */

/****************************************
* Prev
*/
void *MMUvlist::Prev( )

{ /* MMUvlist::Prev procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
void        *mmlVdat= NULL;

/************************* Procedure Body *****************************/
mmlDat = mmhList->Prev();

if (mmlDat)
  {
  mmlVdat = mmlDat->body;
  }
return(mmlVdat);
} /* MMUvlist::Prev end */

/****************************************
* Current
*/
void *MMUvlist::Current( )

{ /* MMUvlist::Current procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
void        *mmlVdat= NULL;

/************************* Procedure Body *****************************/
mmlDat = mmhList->Current();

if (mmlDat)
  {
  mmlVdat = mmlDat->body;
  }
return(mmlVdat);
} /* MMUvlist::Current end */
/****************************************
* Indexed
*/
void *MMUvlist::Indexed( INT32 pasIndex )

{ /* MMUvlist::Indexed procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
void        *mmlVdat= NULL;
/************************* Procedure Body *****************************/
mmlDat = mmhList->Indexed( pasIndex );

if (mmlDat)
  {
  mmlVdat = mmlDat->body;
  }
return(mmlVdat);
} /* MMUvlist::Indexed end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::NumEntries

    PURPOSE:  to return the count of the number of entries
      currently in the list.
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    # of entries in list, currently	      **
**\p*******************************************************************/

INT32 MMUvlist::NumEntries( )

{ /* MMUvlist::NumEntries procedure */
return(mmhList->NumEntries());
} /* MMUvlist::NumEntries end */


/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::InsertSorted

    PURPOSE:  to insert a record sorted, based on the user's
      "compare" function pointer
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE  MMUvlist::InsertSorted
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  INT32  pasSizeOfBuf,
  void  *pasBufPtr )

{ /* MMUvlist::InsertSorted procedure */
return( mmhList->InsertSorted( pasFncCompare, pasSizeOfBuf, pasBufPtr ));
} /* MMUvlist::InsertSorted end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::FindFirstEntry

    PURPOSE:  to find the first ocurrence of an entry in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlVdat		FNC    void *, addr of matched value	      **
**\p*******************************************************************/

void *MMUvlist::FindFirstEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr,
  INT32 &refIndexFound )

{ /* MMUvlist::FindFirstEntry procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY             *mmlDatum;
void			*mmlVdat = NULL;

/************************* Procedure Body *****************************/

mmlDatum = mmhList->FindFirstEntry( pasFncCompare, pasBufPtr, refIndexFound );
if (mmlDatum)
  {
  mmlVdat = mmlDatum->body;
  }

return(mmlVdat);
} /* MMUvlist::FindFirstEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::FindFirstEntry

    PURPOSE:  to find the first ocurrence of an entry in the list.
**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlVat		FNC    void *, addr of matched value	      **
**\p*******************************************************************/

void *MMUvlist::FindFirstEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr )

{ /* MMUvlist::FindFirstEntry procedure */
/******************* Local Variable Declarations **********************/
INT32                   mmlBurnIt;
/************************* Procedure Body *****************************/

return( MMUvlist::FindFirstEntry( pasFncCompare, pasBufPtr, mmlBurnIt ));

} /* MMUvlist::FindFirstEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::FindNextEntry

    PURPOSE:  to find the next ocurrence of an entry in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlVdat		FNC    void *, addr of matched value	      **
**\p*******************************************************************/

void *MMUvlist::FindNextEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr )

{ /* MMUvlist::FindNextEntry procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY             *mmlDatum;
INT32			 mmlBurnIt;
void			*mmlVdat = NULL;
/************************* Procedure Body *****************************/

mmlDatum = mmhList->FindNextEntry( pasFncCompare, pasBufPtr, mmlBurnIt);
if (mmlDatum)
  {
  mmlVdat = mmlDatum->body;
  }

return(mmlVdat);
} /* MMUvlist::FindNextEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::FindNextEntry

    PURPOSE:  to find the next ocurrence of an entry in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlVdat		FNC    void *, addr of matched value	      **
**\p*******************************************************************/

void *MMUvlist::FindNextEntry
( int (* pasFncCompare) (const void *pasStru1,
                         const void *pasStru2 ),
  void  *pasBufPtr,
  INT32 &refIndexFound )

{ /* MMUvlist::FindNextEntry procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY             *mmlDatum;
void			*mmlVdat = NULL;
/************************* Procedure Body *****************************/

mmlDatum = mmhList->FindNextEntry( pasFncCompare, pasBufPtr, refIndexFound );
if (mmlDatum)
  {
  mmlVdat = mmlDatum->body;
  }

return(mmlVdat);
} /* MMUvlist::FindNextEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::GetIndexOfCurrent

    PURPOSE:  to get the numerical index of the current entry.
      This can be SLOW.
**								      **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**			FNC    INT32, index of current entry	      **
**\p*******************************************************************/

INT32 MMUvlist::GetIndexOfCurrent()

{ /* MMUvlist::GetIndexOfCurrent procedure */
return(mmhList->GetIndexOfCurrent());
} /* MMUvlist::GetIndexOfCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist::CopyTo

    PURPOSE:  to copy contents of this list to the specified
      destination list.
**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    STAT_TYPE, SUCCEEDED or FAILED         **
**\p*******************************************************************/

STAT_TYPE MMUvlist::CopyTo( MMUvlist *refList )

{
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDat = NULL;
STAT_TYPE    mmlErr;

/************************* Procedure Body *****************************/

mmlDat = mmhList->First();
mmlErr = SUCCEEDED_;
while (mmlDat && mmlErr == SUCCEEDED_)
  {
  mmlErr = refList->AppendAfterTail( mmlDat->size,
				     mmlDat->body );
  if (mmlErr == SUCCEEDED_)
    {
    mmlDat = mmhList->Next();
    }
  }

return(mmlErr);
}

