/*\t*******************************************************************/
/*    Creation Date .......  Thu  05-20-1993  11:46:17                */
/*    Filename  ...........  mmulist.cpp                              */
/*    Project .............  Utilities                                */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS/Windows                              */
/*    Processor  ..........  MMU - Memory Management Utilities        */
/*    Function:         C++ Linked List class.                        */
/*                                                                    */
/* Matthew Ratcliff's linked list class definitions. There are NO     */
/* INHERENT LIMITATIONS to this doubly linked list class.  Can't say  */
/* that about most other link list functions provided by Microsoft &  */
/* Borland libraries.                                                 */
/*                                                                    */
/* As of July 1994 I have over 150,000 lines of Windows & DOS         */
/* application C++ software that depend on this linked list class and */
/* its subclasses.  It works flawlessly.  It has been used in a Windoz*/
/* file viewer utility to view the entire contents of an ASCII file   */
/* containing 560 character lines, a total of 14 megabytes in size!   */
/* Try that with your Borland or Microsoft tools!                     */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
20-May-93  MJWR         Linked list class.

**\r*/


#ifndef _MMULIST_H_
#define _MMULIST_H_

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/


/********************** Constant Include Files ************************/
#include "liidSys.h"


/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/


/*\i*/

/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\m*/

#include "mmplist.h" // public definitions for linked list package
#include "mmglist.h"


/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUllist_class

    PURPOSE:  to declare a linked list class that makes it easy
      to generate and maintain a linked list.

**                                                                    **
**                                                                    **
**                                                                    **
**\p*******************************************************************/

class  MMUllist

{ /* MMUllist class */

/********************** friend declarations ***************************/

/********************** public declarations ***************************/
public:

                        MMUllist();
                        ~MMUllist();

// Copy contents of this linked list to the
// referenced destination. Start at FIRST of
// this list and APPEND all to refList.
STAT_TYPE               CopyTo( MMUllist *refList );
MMP_DATA_TY            *First();
MMP_DATA_TY            *Last();
MMP_DATA_TY            *Next();
MMP_DATA_TY            *Prev();
MMP_DATA_TY            *Current();
INT32                   NumEntries();
MMP_DATA_TY            *Indexed( INT32 pasIndex );
INT32                   GetIndexOfCurrent();

/****************************************
* This list makes copies of the data
* passed in.  Thus, your data entries
* can be stored in a single local
* variable, update it, and stick each
* version of the variable into the list.
* That is, you needn't allocate storage
* for the bodies of the entries added
* to this list.
*/

STAT_TYPE               InsertBeforeHead   ( MMP_DATA_TY &pasEntry );

STAT_TYPE               AppendAfterTail    ( MMP_DATA_TY &pasEntry );

STAT_TYPE               InsertBeforeCurrent( MMP_DATA_TY &pasEntry );

STAT_TYPE               InsertAfterCurrent( MMP_DATA_TY &pasEntry );

STAT_TYPE               InsertBeforeHead   ( INT32       pasSizeOfBuf,
                                             void       *pasBufPtr );

STAT_TYPE               AppendAfterTail    ( INT32       pasSizeOfBuf,
                                             void       *pasBufPtr );

STAT_TYPE               InsertBeforeCurrent( INT32       pasSizeOfBuf,
                                             void       *pasBufPtr );

STAT_TYPE               InsertAfterCurrent( INT32       pasSizeOfBuf,
                                            void       *pasBufPtr );
/****************************************
* Delete current entry from the list
*/

STAT_TYPE               DeleteCurrentEntry();

/****************************************
* Delete the entire list.  Empties the
* list, but does not delete the linked
* list itself - you can immediately
* start adding new entries afterwards
* if desired.
*/

STAT_TYPE               DeleteList();


/****************************************
* This method is used to build a list,
* sorted by ascii identifier strings.
* For example, to let the user
* build a list of sorted strings:
*
* #include <string.h>
*
* MMP_LLIST_TY *mmlList;
* MMP_DATA_TY  *mmlDatum;
* do
*  {
*   gets(instr);
*   if (*instr)
*     {
*     mmlList.InsertSorted( strcmp, strlen(instr), instr );
*     }
*   }
* while (*instr);
*
* // Print the sorted list now
*
* mmlDatum = mmlList.First();
* while (mmlDatum)
*   {
*   printf("%s\n", (char *)mmlDatum->body;
*   }
* mmlList.DeleteList();
*
*
*
* Now, suppose you have a STRUCTURE, such as file names,
* size, date, etc.
*
* typedef struct { char fileName[13];
*                  INT32 fileSize;
*                  char date[20];
*                } FIP_FILE_TY;
*
* Then build a sorted list like this:
*
* When using structures instead of strings,
* the only REQUIREMENT is that the first
* record of the buffer is the string
* used for comparison.  If this rule
* is not followed, unpredictable
* results will occur.
*
* int fileCompare( const void *f1, const void *f2 )
* {
* FIP_FILE_TY *ff1, *ff2;
* int cmp;
*
* ff1 = (FIP_FILE_TY *)f1;
* ff2 = (FIP_FILE_TY *)f2;
* cmp = strcmpi(ff1->fileName, ff2->fileName);
* if (cmp == 0)
*   {
*   cmp = strcmpi(ff1->fileDate, ff2->fileDate);
*   if (cmp == 0)
*     {
*     lcmp = ff2->fileSize - ff1->fileSize;
*     if (lcmp < 0)      cmp = -1;
*     else if (lcmp > 0) cmp = 1;
*     else               cmp = 0;
*     }
*   }
* return(cmp);
* }
*
* buildFlist()
* {
* FIP_FILE_TY filInfo;
* int         filStatus;
* MMUllist    filFlist;
* MMP_DATA_TY *filEntry;
* FIP_FILE_TY *filPtr;
*
* do
*   {
*   filStatus = fiuGetFileInfo( &filInfo );
*   if (filStatus != FIP_END_OF_DIR)
*     {
*     filFlist.InsertAsciiSorted(fileCompare,
*                                sizeof(FIP_FILE_TY),
*                                &filInfo );
*     }
*   }
* while (filStatus != FIL_END_OF_DIR);
*
* // Now print entire, sorted file list -
*
* filEntry = filFlist.First();
*
* while (filEntry)
*   {
*   filPtr = (FIP_FILE_TY *)filFlist->body;
*   printf( "File: %s, Size: %7ld, Date: %s\n",
*            filPtr->fileName,
*            filPtr->fileSize,
*            filPtr->date );
*   filEntry = filFlist.Next();
*   }
* filFlist.DeleteList();
* }
*
* You must construct the list sorted.  If you start
* with a partially built list before using this
* function, your list won't be completely sorted.
*
*/

STAT_TYPE        InsertSorted( int (* pasFncCompare) (const void *pasStru1,
                                                      const void *pasStru2 ),
                                       INT32  pasSizeOfBuf,
                                       void  *pasBufPtr );


// Also provide this method, although the 'compare'
// function MUST be based on the pasEntry.body only,
// not &pasEntry!

STAT_TYPE        InsertSorted( int (* pasFncCompare) (const void *pasStru1,
                                                      const void *pasStru2 ),
                                MMP_DATA_TY &pasEntry );


/****************************************
* You provide a function to compare
* two entries in your list.  Then
* this function will find that entry
* based on your matching algorithm
* implemented at 'pasFncCompare'. This
* allows you to see if an 'equivalent
* item exists' in a list before adding
* another, for example.  It's up to
* you to ensure that all "oranges"
* are being added to the list so
* that 'pasFncCompare' is comparing
* "oranges" to "oranges".  Or, if
* comparing "oranges" and "apples"
* (e.g. two different structure
* types being stored in the same list),
* your compare function can handle
* it. You may wish to subclass this
* puppy so that another layer can
* ensure such consistency.
*
* If the entry isn't found, a NULL
* is returned.  The 'pasFncCompare'
* function must return a 0 for
* what you consider an "exact match"
* (such as the result of 'strcmpi'
* for example).
*
* If the item is found a pointer
* that list entry is returned,
* and that list entry becomes
* current.  If not found,
* NULL is returned and
* 'current' remains unchanged.
*
*/

/****************************************
* Search for first and next occurrences
* of an entry in a list.  You provide
* the comparison function. If not found
* or error, a NULL is returned. Else
* pointer to the stored data is returned.
*/

// Start search from head of list

MMP_DATA_TY  *FindFirstEntry( int (* pasFncCompare) (const void *pasStru1,
                                                     const void *pasStru2 ),
                              void *pasBufPtr );

// Start search from current list position

MMP_DATA_TY  *FindNextEntry ( int (* pasFncCompare) (const void *pasStru1,
                                                     const void *pasStru2 ),
                              void *pasBufPtr );

/****************************************
* Same as search functions above, but
* they also return an index to the entry
* found.  The "FindNextEntry" algorithm
* could be rather slow when fetching the
* index as well, so don't use it unless
* you really need the index value back too.
*/

// Start search from head of list

MMP_DATA_TY  *FindFirstEntry( int (* pasFncCompare) (const void *pasStru1,
                                                     const void *pasStru2 ),
                              void *pasBufPtr,
                              INT32 &refIndexFound );

// Start search from current list position

MMP_DATA_TY  *FindNextEntry ( int (* pasFncCompare) (const void *pasStru1,
                                                     const void *pasStru2 ),
                              void *pasBufPtr,
                              INT32 &refIndexFound );

/********************** private declarations **************************/
private:

MMG_LLIST_TY  *head;
MMG_LLIST_TY  *tail;
MMG_LLIST_TY  *current;
INT32          numEntries;

MMG_LLIST_TY *mmuCreateEntry( INT32     pasSizeofBuf,
                              void     *pasBufPtr );

STAT_TYPE     mmuSetFirstEntry( MMG_LLIST_TY *pasEntry );
STAT_TYPE     mmuDestroyEntry( MMG_LLIST_TY *refEntry );

/********************* protected declarations *************************/

protected:

}; /* MMUllist end class */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUvlist_class

    PURPOSE:  to declare a linked list class that makes it easy
      to generate and maintain a linked list, returning VOID POINTERS
      instead of pointers to MMP_DATA_TY structures.  This one is
      easy to subclass for whatever specific data type you wish to
      implement a list for.

**                                                                    **
**                                                                    **
**                                                                    **
**\p*******************************************************************/

class  MMUvlist

{ /* MMUvlist class */

/********************** friend declarations ***************************/

/********************** public declarations ***************************/
public:

                        MMUvlist();
                        ~MMUvlist();

// Copy contents of this linked list to the
// referenced destination. Start at FIRST of
// this list and APPEND all to refList.
        STAT_TYPE        CopyTo( MMUvlist *refList );
virtual void            *First();
virtual void            *Last();
virtual void            *Next();
virtual void            *Prev();
virtual void            *Current();
        INT32            NumEntries();
virtual void            *Indexed( INT32 pasIndex );
        INT32            GetIndexOfCurrent();

virtual STAT_TYPE               InsertBeforeHead   ( INT32       pasSizeOfBuf,
                                                     void       *pasBufPtr );

virtual STAT_TYPE               AppendAfterTail    ( INT32       pasSizeOfBuf,
                                                     void       *pasBufPtr );

virtual STAT_TYPE               InsertBeforeCurrent( INT32       pasSizeOfBuf,
                                                     void       *pasBufPtr );

virtual STAT_TYPE               InsertAfterCurrent( INT32       pasSizeOfBuf,
                                                    void       *pasBufPtr );
STAT_TYPE               DeleteCurrentEntry();

STAT_TYPE               DeleteList();



virtual STAT_TYPE     InsertSorted( int (* pasFncCompare) (const void *pasStru1,
                                                           const void *pasStru2 ),
                                     INT32  pasSizeOfBuf,
                                     void  *pasBufPtr );

virtual void  *FindFirstEntry( int (* pasFncCompare) (const void *pasStru1,
                                                      const void *pasStru2 ),
                                                      void *pasBufPtr );

virtual void  *FindNextEntry ( int (* pasFncCompare) (const void *pasStru1,
                                                      const void *pasStru2 ),
                                                      void *pasBufPtr );


virtual void  *FindFirstEntry( int (* pasFncCompare) (const void *pasStru1,
                                                      const void *pasStru2 ),
                                                      void *pasBufPtr,
                                                      INT32 &refIndexFound );

virtual void  *FindNextEntry ( int (* pasFncCompare) (const void *pasStru1,
                                                      const void *pasStru2 ),
                                                      void *pasBufPtr,
                                                      INT32 &refIndexFound );

/********************** private declarations **************************/
private:

MMUllist        *mmhList;

/********************* protected declarations *************************/

protected:

}; /* MMUvlist end class */

#endif

