/*\t*******************************************************************/
/*    Creation Date .......  Tue  08-10-1993  21:57:27                */
/*    Filename  ...........  mmuslist.cpp                             */
/*    Project .............  Memory Management                        */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS/Windows                              */
/*    Processor  ..........  MMU - Memory Management Utilities        */
/*    Function:         String linked list package.                   */
/*      This subclasses MMUslist to create a linked list              */
/*      specific to null terminated strings!                          */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
10-Aug-93  MJWR         Sublcass MMUllist to create a linked list
                        package specific to null terminated C string
                        storage.
**\r*/

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/********************** Constant Include Files ************************/
#include "liidSys.h"
#include "mmplist.h"

/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/
#include "liustrg.h"
#include "mmulist.h"
#include "mmuslist.h"

/*\i*/

/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\m*/

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::InsertBeforeHead

    PURPOSE:  to insert a new string before the head of the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUslist::InsertBeforeHead( char *pasBufPtr )

{ /* MMUslist::InsertBeforeHead procedure */

/******************* Local Variable Declarations **********************/
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/


if (pasBufPtr)
  {
  mmlErr = MMUllist::InsertBeforeHead( (INT32)strlen(pasBufPtr)+1,
                                       (void *)pasBufPtr );
  }
else
  {
  mmlErr = FAILED_;
  // bad parameter
  }

return(mmlErr);
} /* MMUslist::InsertBeforeHead end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::AppendAfterTail

    PURPOSE:  to insert a new entry after the end of the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUslist::AppendAfterTail( char *pasBufPtr )

{ /* MMUslist::AppendAfterTail procedure */

/******************* Local Constant Declarations **********************/
/* Proc name for error log */
//CHARPTR MML_PROC_NAME = "MMUslist::AppendAfterTail";

/******************* Local Variable Declarations **********************/
STAT_TYPE               mmlErr;

/************************* Procedure Body *****************************/
if (pasBufPtr)
  {
  mmlErr = MMUllist::AppendAfterTail( (INT32)strlen(pasBufPtr)+1,
                                      (void *)pasBufPtr );
  }
else
  { // parameter error
  mmlErr = FAILED_;
  }

return(mmlErr);
} /* MMUslist::AppendAfterTail end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::InsertBeforeCurrent

    PURPOSE:  to insert a new entry before the current entry in
       the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

STAT_TYPE MMUslist::InsertBeforeCurrent( char *pasBufPtr )

{ /* MMUslist::InsertBeforeCurrent procedure */

/******************* Local Variable Declarations **********************/
STAT_TYPE               mmlErr;
/************************* Procedure Body *****************************/

if (pasBufPtr)
  {
  mmlErr = MMUllist::InsertBeforeCurrent( (INT32)strlen(pasBufPtr)+1,
                                          (void *)pasBufPtr );
  }
else
  {
  mmlErr = FAILED_; // parameter error
  }
return(mmlErr);
} /* MMUslist::InsertBeforeCurrent end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::First

    PURPOSE:  to return the address of the first data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    char *, address of data buffer  **
**\p*******************************************************************/

char *MMUslist::First( )

{ /* MMUslist::First procedure */

/******************* Local Constant Declarations **********************/

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatum;

char *mmlDat = NULL;

/************************* Procedure Body *****************************/

mmlDatum = MMUllist::First();
if (mmlDatum)
  {
  mmlDat = (char *)mmlDatum->body;
  }

return(mmlDat);
} /* MMUslist::First end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::Last

    PURPOSE:  to return the address of the last string
      in the list.  On error return NULL.

**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    char *, address of data buffer  **
**\p*******************************************************************/

char *MMUslist::Last( )

{ /* MMUslist::Last procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatum;
char *mmlDat = NULL;
/************************* Procedure Body *****************************/

mmlDatum = MMUllist::Last();
if (mmlDatum)
  {
  mmlDat = (char *)mmlDatum->body;
  }

return(mmlDat);
} /* MMUslist::Last end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::Next

    PURPOSE:  to return the address of the next data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    char *, address of data buffer  **
**\p*******************************************************************/

char *MMUslist::Next( )

{ /* MMUslist::Next procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatum;
char *mmlDat = NULL;
/************************* Procedure Body *****************************/

mmlDatum = MMUllist::Next();
if (mmlDatum)
  {
  mmlDat = (char *)mmlDatum->body;
  }

return(mmlDat);
} /* MMUslist::Next end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::Prev

    PURPOSE:  to return the address of the previous data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    char *, address of data buffer  **
**\p*******************************************************************/

char *MMUslist::Prev( )

{ /* MMUslist::Prev procedure */

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatum;
char *mmlDat = NULL;
/************************* Procedure Body *****************************/

mmlDatum = MMUllist::Prev();
if (mmlDatum)
  {
  mmlDat = (char *)mmlDatum->body;
  }
return(mmlDat);
} /* MMUslist::Prev end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::Current

    PURPOSE:  to return the address of the current data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    char *, address of data buffer  **
**\p*******************************************************************/

char *MMUslist::Current( )

{ /* MMUslist::Current procedure */

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatum;
char *mmlDat = NULL;

/************************* Procedure Body *****************************/
mmlDatum = MMUllist::Current();
if (mmlDatum)
  {
  mmlDat = (char *)mmlDatum->body;
  }

return(mmlDat);
} /* MMUslist::Current end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::Indexed

    PURPOSE:  to return the address of the indexed data item
      in the list.  On error return NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDat             FNC    char *, address of data buffer  **
**\p*******************************************************************/

char *MMUslist::Indexed( INT32 pasIndex )

{ /* MMUslist::Indexed procedure */

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatum;
char *mmlDat = NULL;
/************************* Procedure Body *****************************/

mmlDatum = MMUllist::Indexed( pasIndex );
if (mmlDatum)
  {
  mmlDat = (char *)mmlDatum->body;
  }
return(mmlDat);
} /* MMUslist::Indexed end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::InsertSorted

    PURPOSE:  to insert a record sorted, based on the user's
      "compare" function pointer



**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    (SUCCEEDED_ / FAILED_) error return    **
**\p*******************************************************************/

//-------------------------------------------------------------------//
//------  Compare Methods  ------------------------------------------//

// NAME: mmuIAcomapre - ignore case, ascending order
int mmuIAcompare( const void *pasStr1, const void *pasStr2 )
{ return (strcmpi( (const char *)pasStr2, (const char *)pasStr1 ) ); }

// NAME: mmuIDcompare - ignore case, descending order
int mmuIDcompare( const void *pasStr1, const void *pasStr2 )
{ return (strcmpi( (const char *)pasStr1, (const char *)pasStr2 ) ); }

// NAME: mmuSAcomapre - case sensitive, ascending order
int mmuSAcompare( const void *pasStr1, const void *pasStr2 )
{ return (strcmp( (const char *)pasStr2, (const char *)pasStr1 ) ); }

// NAME: mmuSDcompare - case sensitive, descending order
int mmuSDcompare( const void *pasStr1, const void *pasStr2 )
{ return (strcmp( (const char *)pasStr1, (const char *)pasStr2 ) ); }
//-------------------------------------------------------------------//

STAT_TYPE MMUslist::InsertSorted( char *pasBufPtr,
                                  BOOLEAN pasCaseSensitive,//  = TRUE_,
                                  BOOLEAN pasAscendingOrder)// = TRUE_ )

{ /* MMUslist::InsertSorted procedure */

/******************* Local Variable Declarations **********************/
STAT_TYPE mmlErr;

/************************* Procedure Body *****************************/

if (pasBufPtr)
  {
       if ( pasCaseSensitive &&  pasAscendingOrder)
    {
    mmlErr = MMUllist::InsertSorted( mmuSAcompare,
                                     (INT32)(strlen(pasBufPtr)+1),
                                     (void *)pasBufPtr );
    }
  else if ( pasCaseSensitive && !pasAscendingOrder)
    {
    mmlErr = MMUllist::InsertSorted( mmuSDcompare,
                                     (INT32)strlen(pasBufPtr)+1,
                                     (void *)pasBufPtr );
    }
  else if (!pasCaseSensitive &&  pasAscendingOrder)
    {
    mmlErr = MMUllist::InsertSorted( mmuIAcompare,
                                     (INT32)strlen(pasBufPtr)+1,
                                     (void *)pasBufPtr );
    }
  else if (!pasCaseSensitive && !pasAscendingOrder)
    {
    mmlErr = MMUllist::InsertSorted( mmuIDcompare,
                                     (INT32)strlen(pasBufPtr)+1,
                                     (void *)pasBufPtr );
    }
  }
else
  {
  mmlErr = FAILED_; // bad parameter
  }

return(mmlErr);
} /* MMUslist::InsertSorted end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::FindFirstEntry

    PURPOSE:  to find the first ocurrence of a string in the list.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDatum           FNC    char *, addr of matched value   **
**\p*******************************************************************/

char  *MMUslist::FindFirstEntry( char     *pasBufPtr,
                                 INT32    *refIndexFound, //   = NULL,
                                 BOOLEAN pasCaseSensitive ) //  = TRUE_ )

{ /* MMUslist::FindFirstEntry procedure */

/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatPtr;
char        *mmlDatum;
INT32        mmlIndex;
/************************* Procedure Body *****************************/

if (pasBufPtr)
  {
  if (refIndexFound)
    {
    *refIndexFound = -1L;
    }
  mmlIndex = -1L;
  mmlDatum = NULL;
  if (pasCaseSensitive)
    {
    mmlDatPtr = MMUllist::FindFirstEntry( mmuSAcompare,
                                          (void *)pasBufPtr,
                                          mmlIndex );
    }
  else
    {
    mmlDatPtr = MMUllist::FindFirstEntry( mmuIAcompare,
                                          (void *)pasBufPtr,
                                          mmlIndex );
    }
  if (mmlDatPtr)
    {
    mmlDatum = (char *)mmlDatPtr->body;
    if (refIndexFound)
      {
      *refIndexFound = mmlIndex;
      }
    }
  }
else
  {
  mmlDatum = NULL; // bad parameter
  }

return(mmlDatum);
} /* MMUslist::FindFirstEntry end */

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::FindNextEntry

    PURPOSE:  to find the next ocurrence of an entry in the list.
      The caller provides the address of a function that performs
      the comparison.  We step through the list, starting at
      the current->next entry, performing the compare. When the compare
      returns a 0, we return the current datum pointer.  If end of list
      is reached first, return a NULL.

**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlDatum           FNC    char *, addr of matched value   **
**\p*******************************************************************/

char  *MMUslist::FindNextEntry ( char *pasBufPtr,
                                 INT32    *refIndexFound, //  = NULL,
                                 BOOLEAN pasCaseSensitive ) // = TRUE_ )

{ /* MMUslist::FindNextEntry procedure */
/******************* Local Variable Declarations **********************/
MMP_DATA_TY *mmlDatPtr;
char        *mmlDatum;
INT32        mmlIndex;
/************************* Procedure Body *****************************/

if (pasBufPtr)
  {
  if (refIndexFound)
    {
    *refIndexFound = -1L;
    }
  mmlIndex = -1L;
  mmlDatum = NULL;
  if (pasCaseSensitive)
    {
    mmlDatPtr = MMUllist::FindNextEntry(  mmuSAcompare,
                                          (void *)pasBufPtr,
                                          mmlIndex );
    }
  else
    {
    mmlDatPtr = MMUllist::FindNextEntry(  mmuIAcompare,
                                          (void *)pasBufPtr,
                                          mmlIndex );
    }
  if (mmlDatPtr)
    {
    mmlDatum = (char *)mmlDatPtr->body;
    if (refIndexFound)
      {
      *refIndexFound = mmlIndex;
      }
    }
  }
else
  {
  mmlDatum = NULL; // bad parameter
  }

return(mmlDatum);
} /* MMUslist::FindNextEntry end */

/*\p********************************************************************
**                                                                    **
    NAME:  MMUslist::FindFirstSubstring

    PURPOSE:  to find first entry containing the specified substring

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**   Return Val         type/expected/description                     **
**   ------------       --------------------------------------------  **
**   iflCptr            const char *, matched substr entry or NULL    **
**\p*******************************************************************/

char *MMUslist::FindFirstSubstring 
  ( char     *pasSubstrPtr,
    int      *refStartInx,  // character index where substr begins
    INT32    *refIndexFound,
    BOOLEAN   pasCaseSensitive )
{
/*********** Local Constant & Variable Declarations *******************/
char            *mmlStr;
const char      *mmlSstr;
int              mmlStartInx;
/************************* Procedure Body *****************************/

mmlStr = NULL;
if ((pasSubstrPtr) && (refStartInx))
  {
  mmlStr  = First();
  mmlSstr = NULL;

  while ((mmlStr) && (!mmlSstr))
    {
    if (pasCaseSensitive)
      {
      mmlSstr = strstr( mmlStr, pasSubstrPtr );
      }
    else
      {
      mmlSstr = LIUstrstri( mmlStr, pasSubstrPtr );
      }
    if (!mmlSstr) mmlStr = Next();
    }

  if (refIndexFound)
    {
    if (mmlStr) *refIndexFound = GetIndexOfCurrent();
    else        *refIndexFound = -1L;
    }
  if (mmlStr) mmlStartInx = mmlSstr-mmlStr;
  *refStartInx = mmlStartInx;
  }  

return(mmlStr);
} /* MMUslist::FindFirstSubstring end */

/*\p********************************************************************
**                                                                    **
    NAME:  MMUslist::FindNextSubstring 

    PURPOSE:  to find next entry containing the specified substring

**                                                                    **
** By Matthew J. W. Ratcliff                                          **
**   Return Val         type/expected/description                     **
**   ------------       --------------------------------------------  **
**   iflCptr            const char *, matched substr entry or NULL    **
**\p*******************************************************************/

char *MMUslist::FindNextSubstring
  ( char     *pasSubstrPtr,
    int      *refStartInx,  // character index where substr begins
    INT32    *refIndexFound,
    BOOLEAN   pasCaseSensitive )
{
/*********** Local Constant & Variable Declarations *******************/
char            *mmlStr;
const char      *mmlSstr;
int              mmlStartInx;
/************************* Procedure Body *****************************/

mmlStr = NULL;
if ((pasSubstrPtr) && (refStartInx))
  {
  mmlStr  = Next();
  mmlSstr = NULL;

  while ((mmlStr) && (!mmlSstr))
    {
    if (pasCaseSensitive)
      {
      mmlSstr = strstr( mmlStr, pasSubstrPtr );
      }
    else
      {
      mmlSstr = LIUstrstri( mmlStr, pasSubstrPtr );
      }
    if (!mmlSstr) mmlStr = Next();
    }

  if (refIndexFound)
    {
    if (mmlStr) *refIndexFound = GetIndexOfCurrent();
    else        *refIndexFound = -1L;
    }
  if (mmlStr) mmlStartInx = mmlSstr-mmlStr;
  *refStartInx = mmlStartInx;
  }  

return(mmlStr);
} /* MMUslist::FindNextSubstring  end */


/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist::CopyTo

    PURPOSE:  to copy contents of this list to the specified
      destination list.
**                                                                    **
**                                                                    **
**  INTERFACE DEFINITION:                                             **
**     variable         def.          expected/description            **
**   ------------       -----  -------------------------------------  **
**   mmlErr             FNC    STAT_TYPE, SUCCEEDED or FAILED         **
**\p*******************************************************************/

STAT_TYPE MMUslist::CopyTo( MMUslist *refList )

{
/******************* Local Variable Declarations **********************/
char                 *mmlDat = NULL;
STAT_TYPE             mmlErr;

/************************* Procedure Body *****************************/

if (NumEntries() > 0)
  {
  mmlDat = MMUslist::First();
  mmlErr = SUCCEEDED_;
  while (mmlDat && mmlErr == SUCCEEDED_)
    {
    mmlErr = refList->AppendAfterTail( mmlDat );
    if (mmlErr == SUCCEEDED_)
      {
      mmlDat = MMUslist::Next();
      }
    }
  }

return(mmlErr);
}
