/*\t*******************************************************************/
/*    Creation Date .......  Tue  08-10-1993  21:58:22                */
/*    Filename  ...........  mmuslist.cpp                             */
/*    Project .............  Utilities                                */
/*    Author  .............  Matthew J. W. Ratcliff                   */
/*    Language  ...........  C++                                      */
/*    Operating System  ...  DOS/Windows                              */
/*    Processor  ..........  MMU - Memory Management Utilities        */
/*    Function:         C++ Linked List class.                        */
/*              Subclassed for linked list of strings.                */
/*                                                                    */
/*\t*******************************************************************/

/*\r********************************************************************
**                         Revision History
***********************************************************************/
/*

   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
10-AUG-93  MJWR         Include order:

                                #include "liidsys.h"
                                #include "mmplist.h"
                                #include "mmulist.h"
                                #include "mmuslist.h"

**\r*/


#ifndef _MMUSLIST_H_
#define _MMUSLIST_H_

/*\i********************************************************************
**                       Module Include Files
***********************************************************************/

/*********************** System Include Files *************************/


/********************** Constant Include Files ************************/


/***************** External Variable Include Files ********************/



/***************** External Procedure Include Files *******************/


/*\i*/

/*\m********************************************************************
**                       Module Declarations
***********************************************************************/

/************************* Module Constants ***************************/

/************************* Module Variables ***************************/

/************************* Module Procedures **************************/

/*\m*/

/*\p********************************************************************
**                                                                    **
**                                                                    **
    NAME:  MMUslist_class

    PURPOSE:  to declare a linked list class of strings
      to generate and maintain a linked list.

**                                                                    **
**                                                                    **
**                                                                    **
**\p*******************************************************************/

class  MMUslist : public MMUllist

{ /* MMUslist class */

/********************** friend declarations ***************************/

/********************** public declarations ***************************/
public:

MMUslist():MMUllist() {};

// Copy contents of this linked list to the
// referenced destination. Start at FIRST of
// this list and APPEND all to refList.
STAT_TYPE       CopyTo( MMUslist *refList );
char    *First();
char    *Last();
char    *Next();
char    *Prev();
char    *Current();

char    *Indexed( INT32 pasIndex );

/****************************************
* This list makes copies of the data
* passed in.  Thus, your data entries
* can be stored in a single local
* variable, update it, and stick each
* version of the variable into the list.
* That is, you needn't allocate storage
* for the bodies of the entries added
* to this list.
*/

STAT_TYPE               InsertBeforeHead   ( char *pasEntry );

STAT_TYPE               AppendAfterTail    ( char *pasEntry );

STAT_TYPE               InsertBeforeCurrent( char *pasEntry );


STAT_TYPE       InsertSorted( char *pasBufPtr,
                              BOOLEAN pasCaseSensitive  = TRUE_,
                              BOOLEAN pasAscendingOrder = TRUE_ );


// Start search from head of list

char  *FindFirstEntry( char     *pasBufPtr,
                       INT32    *refIndexFound   = NULL,
                       BOOLEAN pasCaseSensitive  = TRUE_ );

// Start search from current list position

char  *FindNextEntry ( char *pasBufPtr,
                       INT32    *refIndexFound  = NULL,
                       BOOLEAN pasCaseSensitive = TRUE_ );

// Start search from head of list for the first string
// in the list that contains pasSubstrPtr

char  *FindFirstSubstring( char     *pasSubstrPtr,          
                           int      *refStartInx,  // character index where substr begins
                           INT32    *refIndexFound   = NULL,
                           BOOLEAN   pasCaseSensitive  = TRUE_ );

// Start search from current list position 
// for the next string in the list that contains pasSubstrPtr

char  *FindNextSubstring ( char     *pasSubstrPtr,
                           int      *refStartInx,  // character index where substr begins
                           INT32    *refIndexFound  = NULL,
                           BOOLEAN   pasCaseSensitive = TRUE_ );


}; /* MMUslist end class */


#endif


