///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: modem.h                                              //
//                  (project version).                                   //
//            started on: 23/2/92                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                                                                       //                                                                     //
///////////////////////////////////////////////////////////////////////////

#ifndef __MODEM_H
#define __MODEM_H

#include "serial.h" ; // SERIAL_PORT

class MODEM: public SERIAL_PORT {


protected:

       // overloads the msr_int from serial_port.
       //
       virtual void msr_int(const BYTE msr);

       // overloads the extended init (called by activate!).
       //
       virtual void extended_init();

       // overloads the flow control function.
       //
       virtual inline void flow_check();

       // called by msr_int when a ring is indicated.
       //
       virtual void ring_int(BYTE msr);

       // called by msr_int when a modem status is indicated (DSR, CTS).
       //
       virtual void modem_status_change(BYTE msr);

       // called by msr_int when DCD changes (up or down).
       //
       virtual void dcd_status_change(BYTE msr);

public:
       MODEM(): SERIAL_PORT() {};
       ~MODEM();

       // called to enquire as to the state of the modem.
       //
       BYTE get_MSR();

       // this function is called to disconnect from the modem.
       //
       virtual void disconnect( BOOLEAN boot_enable= TRUE,
                                const char *escape_sequence= "",
                                const char *disconnect_string= "",
                                const char *disconnect_reply_string= "",
                                const unsigned timeout= 0);

       // wait until DCD is down/ timout expired.
       virtual void wait(unsigned miliseconds);

};

#endif
