///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: modem.cpp                                            //
//            started on: 24/2/92                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  This class submits to DSR and CTS requests and so is compatible      //
//  with modems. Useful for hardware flow control, also... Also          //
//  transmits MODEM init and hangup strings.                            //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                    by Ofer Laor (AKA LeucroTTA)                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#include <bios.h>;   // biostime.
#include <dos.h>;    // inportb, delay.
#include "modem.h";  // MODEM.

// this class is serial port compatible submitting to DSRs and CTSs from
// modems on receive.


// extending the init.
//
void MODEM::extended_init(void)
{
    // turn on DTR, RTS.
    //
    set_controls(0x3);
}

// destructor.
//
MODEM::~MODEM()
{
    // turn off DTR, RTS.
    //
    set_controls(0);
}

void MODEM::flow_check(void)
{
    // check flow control.
    // if both DSR && CTS are activated:- flow is enabled.
    //
    flow_enabled= ((get_MSR()& 0x30)== 0x30)?TRUE: FALSE;
}

void MODEM::wait(unsigned miliseconds)
{
    unsigned long start= biostime(0, 0L);

    do {
       if (!(get_MSR()& 0x80))
          return;
    } while ((biostime(0, 0L)- start* 55)< miliseconds);
}

void MODEM::disconnect( BOOLEAN boot_enable,
                        const char *escape_sequence,
                        const char *disconnect_string,
                        const char *disconnect_reply_string,
                        const unsigned timeout)
{
    INDEX i;

    empty_io_buffers();

    for (i=0; escape_sequence[i]!='\x0'; i++) {
        if (escape_sequence[i]!='~')
           *this<< escape_sequence[i];
        else
            delay (500);
    }
    for (i=0; disconnect_string[i]!='\x0'; i++) {
        if (disconnect_string[i]!='~')
           *this<< disconnect_string[i];
        else
            delay(500);
    }

    if ((get_MSR()& 0x80)) {
       set_controls(0);
       wait (2000);
       set_controls(0x3);
    }
    else { // disconnected...
         empty_io_buffers();
         return;
    }


    // WAIT FOR OK_STRING.
    long begin_clock, timeout_begin_clock;
    BYTE temp;

    i= 0;
    timeout_begin_clock= begin_clock= biostime(0, 0L);

    do {
       if (!disconnect_reply_string[i]) // finished receiving OK string.
          break;

       if (*this>> temp) { // if a byte is available check it.
          if (temp== disconnect_reply_string[i])
             i++;
          else {
               i= 0;
               if (temp== disconnect_reply_string[i]) // could be that the char was the start of the string...
                  i++;
          }

          begin_clock= biostime(0,0L); // a byte was received (reset pend_ticks timeout).
       }
    } while (((biostime(0,0L)- begin_clock)< timeout)&&
             ((biostime(0,0L)- timeout_begin_clock)< timeout));

    if (disconnect_reply_string[i]) { // did not receive OK string.
       // now, if line is still up, boot!
       //
       if ((get_MSR()& 0x80))
          if (boot_enable)
             ; // boot();
    }
}

void MODEM::msr_int(const BYTE msr)
{
    if ((msr& 0x44)== 0x44) // ring is up and the interrupt is because of it.
       ring_int (msr);

    if (msr& 0x3)   // DSR or CTS changed!
       modem_status_change (msr);

    if ((msr& 0x8)) // DCD changed.
       dcd_status_change (msr);
}

void MODEM::dcd_status_change(BYTE /* msr */)
{
    // if DCD or CTS changed...

    // to be overloaded.
}

void MODEM::modem_status_change(BYTE /* msr */)
{
    // if DSR or CTS changed...

    // to be overloaded.
}

void MODEM::ring_int(BYTE /* msr */)
{
    // to be overloaded.
}

BYTE MODEM::get_MSR(void)
{
    return ((BYTE) inportb(com_port+ MSR));
}
