/***********************************************************************
	listdemo.cpp is a demonstration of l_list.  It will create a doubly
	linked list of Lot_draw objects.  The first list will contain duplicate
	keys.  It will display the list, then delete the duplicate keys.  It
	will then redisplay the list.  It will position to the first key in the
	list and display that element with a Lot_draw function, it will do the
	same for the last element in the list.  It will then locate elements in
	the list (where possible) and display those items.  Finally it will
	delete itself.  l_list may be used with any memory model.
************************************************************************/
#include <stdio.h>
#include <conio.h>			//needed for getch() & clrscr()
#include <l_list.hpp>		//header file for linked list
#include <lottlist.hpp>		//header file for lottery object
/***********************************************************************/
//	function prototypes
void load_list(void);
void dump_forward(void);
int lot_compare(void *std,void *ins);	//compare function whose address is
													//passed to the insert function
void delete_dupes(void);	//make a pass through the list deleting duplicates
int locate_comp(void *std,long locate_key);  //this is the compare function
//whose address is passed to the derived class locate() function
/***********************************************************************/
Lot_list *lot_list;
Lot_draw *cur_rec,current_draw;
main()
{
long locater;
	lot_list = new Lot_list();
   dump_forward();
	load_list();
	clrscr();
	dump_forward();		//display the whole list
	lot_list->reset();	//position to the first element
	cur_rec = lot_list->value();
	printf("the first key in the list is %ld\n",cur_rec->key);
	cur_rec->printer();	//use a Lot_draw function do display the element
	lot_list->reset_end();	//now do the last element in the list
	cur_rec = lot_list->value();
	printf("the last key in the list is %ld\n",cur_rec->key);
	cur_rec->printer();	//use a Lot_draw function do display the element
	delete_dupes();		//delete the duplicate keys
	dump_forward();		//display the list again
	current_draw.key = 901202;
	cur_rec = &current_draw;
	//use the l_list::locate() to find an element
	printf("trying to find what was drawn on %ld\n",cur_rec->key);
	if(lot_list->locate((void *)cur_rec,lot_compare))
		{
		cur_rec = lot_list->value();
		cur_rec->printer();
		}
	else
		printf("I don't know what was drawn on %ld\n",cur_rec->key);
	//or use your own locate function to find an element
	locater = 901130;
	printf("using derived class locate function to find %ld\n",locater);
	if(lot_list->locate(locater,locate_comp))
		{
		cur_rec = lot_list->value();
		cur_rec->printer();
		}
	else
		printf("I don't know what was drawn on %ld\n",cur_rec->key);
	current_draw.key = 951031;
	cur_rec = &current_draw;
	if(lot_list->locate((void *)cur_rec,lot_compare))
		{
		cur_rec = lot_list->value();
		cur_rec->printer();
		}
	else
		printf("I don't know what was drawn on %ld\n",cur_rec->key);
	cur_rec = lot_list->value();
	printf("cursor points to %ld\n",cur_rec->key);
	delete lot_list;
}

/**************************************************************************
*	this is the function that is passed to the linked list object, it
*	compares the keys to control how records are inserted.
**************************************************************************/
int lot_compare(void *std_rec,void *ins_rec)
{
Lot_draw *std,*ins;
	std = (Lot_draw *) std_rec;		//be sure to cast the pointers
	ins = (Lot_draw *) ins_rec;
	if(ins->key < std->key)
		return 1;
	else
		if(ins->key > std->key)
			return -1;
		else
			return 0;
}
/**************************************************************************
*	This is the function that is passed to the Lot_list::my_locate function.
*  Turbo C++ typechecking is very precise.  It is not good enough just to
*	pass locate() the address of a function returning an integer.  The
*	function whose address is passed must have the same signature as the
*	compare function in the prototype.
**************************************************************************/
int locate_comp(void *std_rec,long locate_key)
{
Lot_draw *std;
	std = (Lot_draw *) std_rec;		//be sure to cast the pointers
	if(locate_key < std->key)
		return 1;
	else
		if(locate_key > std->key)
			return -1;
		else
			return 0;
}
/**************************************************************************
	dump_forward() will dump the list to the screen in sorted order
**************************************************************************/
void dump_forward(void)
{
Lot_draw *cur_draw;
	lot_list->reset();
	if(lot_list->end())
		{//don't try to dump an empty list
		printf("the list is empty\n");
		return;
		}
	printf("dumping list\n");
	do
		{
		cur_draw = lot_list->value();
		printf("%ld %2d %2d %2d %2d %2d %2d\n",cur_draw->key,
			cur_draw->number[0],cur_draw->number[1],cur_draw->number[2],
			cur_draw->number[3],cur_draw->number[4],cur_draw->number[5]);
		}while(lot_list->next());
	printf("hit a key to proceed\n");
	getch();
	clrscr();
}
/************************************************************************
	delete_dupes() will step through the list deleting the duplicate keys.
	It will delete the 2nd occurrence of each key value.
************************************************************************/
void delete_dupes(void)
{
long hold_key;
Lot_draw *cur_draw;
	lot_list->reset();
	do
		{
		cur_draw = lot_list->value();
		hold_key = cur_draw->key;
		lot_list->next();
		cur_draw = lot_list->value();
		if(cur_draw->key == hold_key)
			{
			printf("deleting duplicate key %ld\n",cur_draw->key);
			lot_list->remove();
			}
		}while(!lot_list->end());
}
/*************************************************************************
	load_list() will load the list with some hardcoded values.
	Please note that the order in which the records are inserted is
	unimportant.
*************************************************************************/
void load_list(void)
{
Lot_draw *add_draw;
	add_draw = new Lot_draw;	//l_list store pointers to the data,
	add_draw->key = 901202;		//be sure to allocate a new object for each
	add_draw->number[0] = 1;	//linked list element. If you reuse the same
	add_draw->number[1] = 7;	//address, each element will point to the final
	add_draw->number[2] = 12;	//value at that address.
	add_draw->number[3] = 20;
	add_draw->number[4] = 36;
	add_draw->number[5] = 54;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 901005;
	add_draw->number[0] = 4;
	add_draw->number[1] = 6;
	add_draw->number[2] = 11;
	add_draw->number[3] = 19;
	add_draw->number[4] = 35;
	add_draw->number[5] = 53;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 901216;
	add_draw->number[0] = 3;
	add_draw->number[1] = 5;
	add_draw->number[2] = 10;
	add_draw->number[3] = 22;
	add_draw->number[4] = 34;
	add_draw->number[5] = 52;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
/*	the following duplicate key demonstrates how the list handles duplicates
	note that the first one has a 1 in number[0] and the second has 2 in
	number[0] */
	add_draw = new Lot_draw;
	add_draw->key = 901202;
	add_draw->number[0] = 2;
	add_draw->number[1] = 7;
	add_draw->number[2] = 12;
	add_draw->number[3] = 20;
	add_draw->number[4] = 36;
	add_draw->number[5] = 54;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 901216;
	add_draw->number[0] = 2;
	add_draw->number[1] = 11;
	add_draw->number[2] = 13;
	add_draw->number[3] = 27;
	add_draw->number[4] = 33;
	add_draw->number[5] = 50;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 901130;
	add_draw->number[0] = 1;
	add_draw->number[1] = 2;
	add_draw->number[2] = 32;
	add_draw->number[3] = 40;
	add_draw->number[4] = 46;
	add_draw->number[5] = 54;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 910102;
	add_draw->number[0] = 5;
	add_draw->number[1] = 7;
	add_draw->number[2] = 12;
	add_draw->number[3] = 20;
	add_draw->number[4] = 36;
	add_draw->number[5] = 54;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 891230;
	add_draw->number[0] = 1;
	add_draw->number[1] = 2;
	add_draw->number[2] = 3;
	add_draw->number[3] = 4;
	add_draw->number[4] = 5;
	add_draw->number[5] = 6;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 900705;
	add_draw->number[0] = 15;
	add_draw->number[1] = 17;
	add_draw->number[2] = 19;
	add_draw->number[3] = 20;
	add_draw->number[4] = 36;
	add_draw->number[5] = 48;
	printf("inserting %ld\n",add_draw->key);
	lot_list->insert((void *)add_draw,lot_compare);
	add_draw = new Lot_draw;
	add_draw->key = 891230;
	add_draw->number[0] = 2;
	add_draw->number[1] = 2;
	add_draw->number[2] = 3;
	add_draw->number[3] = 4;
	add_draw->number[4] = 5;
	add_draw->number[5] = 6;
	lot_list->insert((void *)add_draw,lot_compare);
	printf("inserting %ld\n",add_draw->key);
	printf("hit a key to continue\n");
	getch();
}