#include <l_list.hpp>
//	this constructor will build an empty list
l_list::l_list()
{
	head = new ll_element;
	cursor = head;
	head->data = 0;
	head->prev = 0;
	head->next = 0;
}
//	this constructor will build a list containing only the item whose
// pointer is passed to it.
l_list::l_list(void *data_ptr)
{
	head = new ll_element;
	cursor = new ll_element;
	cursor->data = data_ptr;
	cursor->next = 0;
	cursor->prev = 0;
	head->next = cursor;
	head->prev = cursor;
}
// this destructor will free the entire list
l_list::~l_list()
{
	reset();
	while(!end())
		remove();
	delete head;
}
//	this function should be replaced with a virtual function that derefences
// the void pointer.
void *l_list::value()
{
	return cursor->data;
}
// this is the main workhorse of the linked list.  Pass it a void pointer
// to the data item to be inserted as well as the address of a compare
// function that returns an integer in the range of -1 to +1.
void l_list::insert(void *insert_rec,int(*comp)(void *,void *))
{
int ins_test;
ll_element *beginning;
ll_element *ending;
ll_element *tail;
	tail = new ll_element;		// allocate a linked list element
	tail->data = insert_rec;	// set the pointer to the item to be added
	tail->next = 0;				// don't know what do with the pointers yet
	tail->prev = 0;
	beginning = head->prev;	//these are set to the start and finish
	ending = head->next;		//of the list
	if(beginning == 0 && ending == 0)//this is the very first record
		{
		head->data = tail->data;
		head->prev = tail;
		head->next = tail;
		cursor = tail;
		return;
		}
	if(comp(beginning->data,tail->data) > 0)
		{// new element at beginning of list
		tail->next = head->prev;
		beginning->prev = tail;
		head->prev = tail;
		tail->prev = 0;
		return;
		}
	else
		{
		if(comp(ending->data,tail->data) <= 0)
			{// new element at end of list
			tail->next = 0;
			ending->next = tail;
			head->next = tail;
			tail->prev = ending;
			ending = tail;
			cursor = tail;
			return;
			}
		}
// we get here when the record to be inserted is less than the highest key
// and greater than the smallest key
	ins_test = -1;	// beginning of the list
	reset();
	while(ins_test <= 0)
		{//advance the cursor until the cursor is greater than the insert rec
		ins_test = comp(cursor->data,tail->data);
		if(ins_test <= 0)
			{
			if(cursor->next)
				{
				cursor = cursor->next;
				}
			else
				{
				head->prev = tail;
				head->next = tail;
				tail->prev = 0;
				tail->next = 0;
				cursor = tail;
				return;
				}
			}
		}
//when we get here the cursor should be pointing to the next greater record
	tail->next = cursor;
	tail->prev = cursor->prev;
	cursor->prev = tail;
	ending = tail->prev;
	ending->next = tail;
	return;
}
/************************************************************************
	locate will search the list for the key passed in locate_key.
	it will return 1 if the key can be found and cursor will be positioned
	to that element in the list.  If the key cannot be found this function
	will return 0 and the cursor will be at the next highest key.
************************************************************************/
int l_list::locate(void *locate_key,int(*comp)(void*,void*))
{
int ins_test;
ll_element *beginning;
ll_element *ending;
	beginning = head->prev;	//these are set to the start and finish
	ending = head->next;		//of the list
	ins_test = comp(beginning->data,locate_key);
	if(ins_test > 0)
		{// the key is less than any in the list
		cursor = head->prev;
		return 0;
		}
	else
		{
		if(ins_test == 0)
			{
			cursor = beginning;
			return 1;
			}
		}
	ins_test = comp(ending->data,locate_key);
	if(ins_test == 0)
		{
		cursor = head->next;
		return 1;
		}
	if(ins_test < 0)
		{// the key is greater than any in the list
		cursor = head->next;
		return 0;
		}
	ins_test = -1;
	reset();
	while(ins_test <= 0)
		{//advance the cursor until the cursor is greater than the insert rec
		ins_test = comp(cursor->data,locate_key);
		if(ins_test == 0)
			return 1;
		else
			{
			if(cursor->next)
				cursor = cursor->next;
			else
				break;
			}
		}
	return 0;
}
/*************************************************************************
	prev() will move the cursor back one element and return 1, when possible.
	If cursor points to the first element in the list it will leave cursor
	unchanged and return 0.
*************************************************************************/
int l_list::prev()
{
	if(cursor == head->prev)
		return 0;
	cursor = cursor->prev;
	return 1;
}
/************************************************************************
	next() works just like prev() except that it will move cursor forward
	when possible.
************************************************************************/
int l_list::next()
{
	if(cursor->next)
		{
		cursor = cursor->next;
		return 1;
		}
	else
		return 0;
}
/**********************************************************************
	end() will return 1 when cursor is positioned at the end of the list.
**********************************************************************/
l_list::end()
{
	if(!cursor->next)
		return 1;
	else
		return 0;
}
/***********************************************************************
	remove() should be used to delete the list element pointed to by
	cursor.  It will handle the pointers automatically.
***********************************************************************/
int l_list::remove()
{
ll_element *hold,*hold_prev,*hold_next;
	if(cursor == head->prev)
		{//special case for the first element in the list
		delete_data(cursor->data);	// delete the data item
		cursor = cursor->next;		// move forward
		head->prev = cursor;			// change the pointer in the head
		delete cursor->prev;			// delete the ll_element
		cursor->prev = 0;
		return 0;
		}
	if(cursor == head->next)
		{//special case for the last element in the list
		delete_data(cursor->data);	// delete the data item
		cursor = cursor->prev;		// move backward
		head->next = cursor;			// change the pointer in the head
		delete cursor->next;			// delete the ll_element
		cursor->next = 0;
		return 0;
		}
	if((cursor->next) && (cursor->prev))
		{//this element is somewhere in the middle of the list
		hold_prev = cursor->prev;
		hold_next = cursor->next;
		delete_data(cursor->data);
		delete cursor;
		cursor = hold_prev;
		cursor->next = hold_next;
		cursor = cursor->next;
		cursor->prev = hold_prev;
		return 0;
		}
	return 1;	//this is antibugging, this line should never be reached.
					//if you ever get a 1 back from remove() then the list
					//is corrupt
}
/*************************************************************************
	delete_data() is a virtual function.  Write one which will delete a
	properly cast pointer to whatever kind of data is stored in the list.
*************************************************************************/
void l_list::delete_data(void*){}

/*************************************************************************
	reset() will position cursor to the beginning of the list.
*************************************************************************/
void l_list::reset()
{	if(head->prev)
		cursor = head->prev;
}
/*************************************************************************
	reset_end() will position cursor to the last element in the list
*************************************************************************/
void l_list::reset_end()
{
	if(head->next)
		cursor = head->next;
}
