	// sbdrdem1.cpp
	// Demo Streamable Binder with streamable nodes
	// Redirect cout to a file for this demo!
	// Link with binder.obj and sbinder.obj

	#include <fstream.h>
	#include <iomanip.h>
	#include "sbinder.hpp"


	#define ID_StreamableInt 4
	#define ID_SINT_CMP  1
	#define ORIG_NODES   4

	class StreamableInt : Streamable  {
		int i;
	protected:
		void construct(int i)
			{ this->i = i; }
	public:
		STREAMABLE(StreamableInt,
			ID_StreamableInt,
			Streamable);
		StreamableInt(int i)
			: Streamable(UNIQUE_STREAMABLE,
			ID_CLASS)
			{ construct(i); }
		int Int() { return i; }
		~StreamableInt() {}
	};
	typedef StreamableInt * StreamableInT;
	#define StreamableInT0 ((StreamableInT)0)


	ostream& StreamableInt::store(ostream& os)
		{ return os << i << endm; }

	StreamablE StreamableInt::load(istream& is,
		StreamablE InstancE)
	{
		int i;

		if (!(is >> i >> nextm))  {
			lserror("loading StreamableInt",
				ID_CLASS);
			return StreamablE0;
		}
		if (!InstancE)
			if ((InstancE =	(StreamablE)
				new StreamableInt
				(UNIQUE_STREAMABLE))
				== StreamablE0)  {
				lserror("unable to construct"
					" StreamableInt",
					ID_CLASS);
				return StreamablE0;
			}
		((StreamableInT)InstancE)->construct(i);
		return InstancE;

	}

	int sintcmp(const StreamableInT I1,
		const StreamableInT I2)
		{ return (I1->Int() - I2->Int()); }

	void display(StreamableInT I)
	{
		cout << "Address of node: "
			<< setw(6) << I
			<< "   Contents of node: "
			<< setw(6) << I->Int() << endl;
	}

	main()
	{
		SBinder::registerClass();
		StreamableInt::registerClass();

		// When debugging redirect cout to a file
		// so that you can examine the trace!
		cerr = cout;
		// Let's watch on cerr for stream errors!
		Streamable::streamDebug = 1;
		// Let's watch the multiple linking -
		// unlinking on cerr!
		Streamable::refDebug = 1;
		// Let's watch StreamableClassRegistry 
		// errors on cerr!
		StreamableClassRegistry::debug = 1;

		SBinder B(BDR_OK_FREE,ORIG_NODES);

		int i = 0;

		while (B.vacancyNonElastic())
			B.push(new StreamableInt(i++));

		B.setMaxNodes();
		
		cout << "\n\nBinder with streamable "
			<< "nodes and \nmultiple links "
			<< "to those nodes, unsorted:\n\n";

		i = 0;

		while (i < ORIG_NODES)

			B.atIns(ORIG_NODES,B[i++]);

			// Like pushing a stack
			// at ORIG_NODES.


		cout << endl << endl;

		B.forEach((BDRforEachBlocK)display);

		B.setComparE((BDRcomparE)sintcmp);
		
		B.link();  // can't stream unless linked!

		RegisterFunction(ID_SINT_CMP,
			(GenericFnC)sintcmp);

		ofstream oS("sbdrdem1.txt");
		if (oS)  {

		  oS << (StreamablE) B;

		  B.restream();

		  // Don't stream B again
		  // without restreaming!!!

		  oS.close();
		  ifstream iS("sbdrdem1.txt");
		  if (iS)  {

		    StreamablE C;
		    
		    cout << "\n\nStreamed and "
			<< "reloaded Binder with "
			<< "multiple links maintained "
			<< "\nand sorted with streamed "
			<< "compare fnc: \n\n";
		    
		    iS >> C;
		    iS.close();

		    RestreamRegistry();

		    // Don't load again from
		    // any stream with
		    // restreaming
		    // Registry!!!

		    if (C)
		    {
		      ((SBindeR)C)->sort();
		      cout << endl << endl;
		      ((SBindeR)C)->forEach(
			(BDRforEachBlocK)display);
		      delete (SBindeR) C;
		    }
		    else
		      cout << "\n\nUnable to reload"
			<< " Binder \n\n";
		  }
		  else
		    cout << "\n\nUnable to reopen"
		      << " stream for input of"
		      << " of Binder \n\n";
		}
		
		B.unlink();  // not really necessary here


		return 0;
	}