//	Copyright (C) 1996, 1997 Meta Four Software.  All rights reserved.
//
//  This is the simplified header for use with the MetaKit library.
//
//  There is no point in exporting the bulky and complex conditional header
//  structure used within the library itself, but the definitions below will
//  have to be changed substantially to support new compilers, etc.
//
//! rev="$Id: k4conf.h,v 1.17 1997/06/02 16:07:52 jcw Rel $"

#ifndef __K4CONF_H__
#define __K4CONF_H__

    // Microsoft C++ prefers MFC, everything else defaults to Universal version
#if !_MSC_VER && !q4_MFC && !q4_STD && !defined (q4_UNIV)
	#define q4_UNIV 1
#endif

    // by default, if MFC is linked as a DLL, then so is MetaKit
#if defined (_AFXDLL) && !defined (q4_KITDLL)
    #define q4_KITDLL _AFXDLL
#endif

    // default is to add typedefs for uchar, etc.
#if !defined (q4_TYPES)
    #define q4_TYPES 1
#endif

    // omit floating point in small model builds
#if defined (_DOS) && defined (_M_I86SM) && !defined (q4_TINY)
    #define q4_TINY 1
#endif

/////////////////////////////////////////////////////////////////////////////

	// Borland C++ and C++ Builder
#if defined (__BORLANDC__)
	    // by default, if runtime is linked as a DLL, then so is MetaKit
	#if defined (_RTLDLL) && !defined (q4_KITDLL)
    	#define q4_KITDLL 1
	#endif

        // use explicit import specifier if MetaKit is in a DLL
    #if q4_KITDLL && !defined (q4_EXPORT)
        #define q4_EXPORT 1
		#define d4_DLLSPEC(t) t	// only class _import in BC 4.52 (?)
	#endif

		// Borland 5.0 supports the bool datatype
	#if __BORLANDC__ >= 0x500
		#define q4_BOOL 1
	#endif
#endif

    // Metrowerks CodeWarrior
#if defined (__MWERKS__)
    #if __option(bool)
        #define q4_BOOL 1       // bool datatype is optionally supported
            // undef, these conflict with c4_Storage::c4_Storage overloading
        #undef bool
        #undef true
        #undef false
    #endif
#endif

    // Microsoft Visual C++
#if defined (_MSC_VER)
        // MSVC 4.0 can specify the library it needs to link here
	#if _MSC_VER >= 1000 && !defined(_MAC)
        #if q4_STD
            #if q4_KITDLL
                #ifdef _DEBUG
                    #pragma comment(lib, "mk4nvsyd.lib")
                #else
                    #pragma comment(lib, "mk4nvsy.lib")
                #endif
            #else
                #ifdef _DEBUG
                    #pragma comment(lib, "mk4nvssd.lib")
                #else
                    #pragma comment(lib, "mk4nvss.lib")
                #endif
            #endif
        #elif q4_UNIV
            #if q4_KITDLL
                #ifdef _DEBUG
                    #pragma comment(lib, "mk4nvuyd.lib")
                #else
                    #pragma comment(lib, "mk4nvuy.lib")
                #endif
            #else
                #ifdef _DEBUG
                    #pragma comment(lib, "mk4nvusd.lib")
                #else
                    #pragma comment(lib, "mk4nvus.lib")
                #endif
            #endif
        #else // q4_MFC
            #if q4_KITDLL
                #ifdef _DEBUG
                    #pragma comment(lib, "mk4nvmxd.lib")
                #else
                    #pragma comment(lib, "mk4nvmx.lib")
                #endif
            #else
                #ifdef _DEBUG
                    #pragma comment(lib, "mk4nvmsd.lib")
                #else
                    #pragma comment(lib, "mk4nvms.lib")
                #endif
            #endif
        #endif
    #endif

        // MSVC 5.0 supports the bool datatype
    #if _MSC_VER >= 1100
        #define q4_BOOL 1
    #endif
#endif

/////////////////////////////////////////////////////////////////////////////
// Other definitions needed by the public MetaKit library header files

#if !q4_BOOL                    // define a bool datatype
    #define false 0
    #define true 1
    #define bool int
#endif

#if q4_EXPORT					// add declaration specifiers
	#include "k4dll.h"
#endif

#if q4_INLINE                   // enable inline expansion
    #define d4_inline inline
#else
    #define d4_inline
#endif

#if q4_TYPES                    // create typedefs for uchar, etc.
    typedef unsigned char uchar;
    typedef unsigned short ushort;
    typedef unsigned int uint;
    typedef unsigned long ulong;
#endif

/////////////////////////////////////////////////////////////////////////////
// Framework classes

#if q4_STD						// STL and standard streams (not yet)

    #include "m4string.h"
    #include "m4wrap.h"

//    #include <fstream>
//    typedef std::fstream c4_File;
    #include <stdio.h>
    typedef FILE c4_File;

#elif q4_UNIV					// Universal replacement classes

    #ifdef _MSC_VER
        #pragma warning(disable: 4100 4127 4135 4244 4511 4512 4514)
    #endif

    #include "m4string.h"
    #include "m4coll.h"

    #include <stdio.h>
    typedef FILE c4_File;

#else // q4_MFC					// Microsoft Foundation Classes
    
    #ifdef _WINDOWS
        #include <afxwin.h>
    #else
        #include <afxcoll.h>
    #endif

    typedef class CFile         c4_File;
    typedef class CString       c4_String;
    typedef class CPtrArray     c4_PtrArray;

        // MSVC 1.52 thinks a typedef has no constructor, use define instead
    #if _MSC_VER == 800
        #define c4_String CString
    #endif

#endif

/////////////////////////////////////////////////////////////////////////////

#endif
