//	Copyright (C) 1996, 1997 Meta Four Software.  All rights reserved.
//
//	Strategy declarations
//
//! rev="$Id: k4strat.h,v 1.18 1997/05/25 20:00:27 jcw Rel $"

#ifndef __K4STRAT_H__
#define __K4STRAT_H__

/////////////////////////////////////////////////////////////////////////////
// Declarations in this file

    class c4_Strategy;                  // system and file interface

    class c4_Column;                    // not defined here
    class c4_ColCache;                  // not defined here

/////////////////////////////////////////////////////////////////////////////
//: A strategy encapsulates code dealing with file I/O and the system.

class c4_Strategy
{     
public:
    c4_Strategy (c4_File* file_ =0);
        //: Constructs a new strategy object.
    virtual ~c4_Strategy ();

    virtual bool DataOpen(const char* fileName_, bool allowWriting_);
        //: Opens a data file by name.

    virtual void DataSeek(long position_);
        //: Sets file position.
    virtual int  DataRead(void* buffer_, int length_);
        //: Reads a number of bytes.
    virtual void DataLoad(void* buffer_, int length_);
        //: Reads an exact number of bytes.
    virtual void DataWrite(const void* buffer_, int length_);
        //: Writes a number of bytes.
    virtual void DataCommit(long newSize_);
        //: Flushes and truncate file.

    virtual int  StreamRead(void* auxArg_, void* buffer_, int length_);
        //: Consumes some bytes sequentially.
    virtual void StreamWrite(void* auxArg_, const void* buffer_, int length_);
        //: Produces some bytes sequentially.

    c4_ColCache* _colCache;
        //: Holds a cache manager for all columns.

    bool _keepAfterCommit;
        //: Keep data in memory after each commit (default is false).
    bool _bytesFlipped;
        //: True if the storage format is not native (default is false).

    const uchar* _mapStart;
        //: First byte in file mapping, zero if not active.
    const uchar* _mapLimit;
        //: Past last byte in file mapping, zero if not active.

	/* bool _copyOnDetach; */
		/*: Copy to view when storage goes away (default is false). */

protected:
    c4_File* _file;
        //: Pointer to file object.

private:
    void ResetFileMapping();

    c4_File* _cleanup;
};

/////////////////////////////////////////////////////////////////////////////  

#endif
