//	Copyright (C) 1996, 1997 Meta Four Software.  All rights reserved.
//
//  This file contains the declaration of the MFC replacement collections.
//
//! rev="$Id: m4coll.h,v 1.7 1997/05/25 20:00:41 jcw Rel $"

#ifndef __M4COLL_H__
#define __M4COLL_H__

/////////////////////////////////////////////////////////////////////////////
// Declarations in this file

    class c4_BaseArray;
    class c4_WordArray;
    class c4_DWordArray;
    class c4_PtrArray;
    class c4_StringArray;

/////////////////////////////////////////////////////////////////////////////

class c4_BaseArray
{
public:
    c4_BaseArray ();
    ~c4_BaseArray ();

    int GetLength() const;
    void SetLength(int nNewSize);

    const void* GetData(int nIndex) const;
    void* GetData(int nIndex);

    void Grow(int nIndex);

    void InsertAt(int nIndex, int nCount);
    void RemoveAt(int nIndex, int nCount);

private:
    char* _data;
    int _size;
};

class c4_WordArray
{
public:
    c4_WordArray ();
    ~c4_WordArray ();

    int GetSize() const;
    void SetSize(int nNewSize, int nGrowBy = -1);

    ushort GetAt(int nIndex) const;
    void SetAt(int nIndex, ushort newElement);
    ushort& ElementAt(int nIndex);

    int Add(ushort newElement);

    void InsertAt(int nIndex, ushort newElement, int nCount = 1);
    void RemoveAt(int nIndex, int nCount = 1);

private:
    static int Off(int n_);

    c4_BaseArray _base;
};

class c4_DWordArray
{
public:
    c4_DWordArray ();
    ~c4_DWordArray ();

    int GetSize() const;
    void SetSize(int nNewSize, int nGrowBy = -1);

    ulong GetAt(int nIndex) const;
    void SetAt(int nIndex, ulong newElement);
    ulong& ElementAt(int nIndex);

    int Add(ulong newElement);

    void InsertAt(int nIndex, ulong newElement, int nCount = 1);
    void RemoveAt(int nIndex, int nCount = 1);

private:
    static int Off(int n_);

    c4_BaseArray _base;
};

class c4_PtrArray
{
public:
    c4_PtrArray ();
    ~c4_PtrArray ();

    int GetSize() const;
    void SetSize(int nNewSize, int nGrowBy = -1);

    void* GetAt(int nIndex) const;
    void SetAt(int nIndex, void* newElement);
    void*& ElementAt(int nIndex);

    int Add(void* newElement);

    void InsertAt(int nIndex, void* newElement, int nCount = 1);
    void RemoveAt(int nIndex, int nCount = 1);

private:
    static int Off(int n_);

    c4_BaseArray _base;
};

class c4_StringArray
{
public:
    c4_StringArray ();
    ~c4_StringArray ();

    int GetSize() const;
    void SetSize(int nNewSize, int nGrowBy = -1);

    c4_String GetAt(int nIndex) const;
    void SetAt(int nIndex, const char* newElement);
//  c4_String& ElementAt(int nIndex);

    int Add(const char* newElement);

    void InsertAt(int nIndex, const char* newElement, int nCount = 1);
    void RemoveAt(int nIndex, int nCount = 1);

private:
    c4_PtrArray _ptrs;
};

/////////////////////////////////////////////////////////////////////////////

#if q4_INLINE
    #include "m4coll.inl"
#endif

/////////////////////////////////////////////////////////////////////////////

#endif
