//	Copyright (C) 1996, 1997 Meta Four Software.  All rights reserved.
//
//	Main library include file
//
//! rev="$Id: m4kit.h,v 1.14 1997/05/27 18:20:52 jcw Rel $"

#ifndef __M4KIT_H__
#define __M4KIT_H__

/////////////////////////////////////////////////////////////////////////////
//
//  TITLE
//                                
//      The MetaKit Library, by Jean-Claude Wippler, Meta Four Software, NL.
//      
//  DESCRIPTION
//                                
//      Structured data storage with commit / rollback and on-demand loading.
//  
//  DISCLAIMER
//
//      The author makes no warranties, either expressed or implied, with
//      respect to this software, its quality, performance, merchantability,
//      or fitness for any particular purpose. This software is distributed
//      AS IS. The user of this software assumes all risks as to its quality
//      and performance. In no event shall the author be liable for any
//      direct, indirect or consequential damages, even if the author has
//      been advised as to the possibility of such damages.
//            
//  ACKNOWLEDGEMENTS
//                                                                        
//      To Liesbeth and Myra, for making this possible.
//
//      Thanks to Alexander Stigsen and Kirill Denisenko for their feedback.
//                               
//  Do you have any suggestions, ideas, fixes? All valuable feedback will be
//  rewarded with an honorable mention in this section. It's up to *YOU* now.
//
/////////////////////////////////////////////////////////////////////////////
//
//  NAMING CONVENTIONS        PREFIX    REMARKS
//                              
//      Compile time options    q4_     Always defined as 1 or 0, capitalized
//      Preprocessor defines    d4_     Use with "#ifdef" or "#if defined()"
//      Classes                 c4_     Classes, listed at start of headers
//      Global functions        f4_     Internal, these are rarely defined
//
//      Member functions                Start in uppercase
//      Instance variables      _       And start in lowercase
//      Static members          _       And start in uppercase
//
//      Local variable names            Start in lowercase
//      Formal parameter names          Start lowercase, end with underscore
//
/////////////////////////////////////////////////////////////////////////////

    // current release = 100 * major + 10 * minor + maintenance
#define d4_MetaKitLibraryVersion    170		// May 28, 1997

#include "k4conf.h"     // configuration, compatibility, elementary types
#include "k4view.h"     // views, cursors, rows, properties, storage

/////////////////////////////////////////////////////////////////////////////

#endif
