//	Copyright (C) 1996, 1997 Meta Four Software.  All rights reserved.
//
//	This file contains the declaration of the optional string class.
//
//! rev="$Id: m4string.h,v 1.7 1997/05/25 20:00:46 jcw Rel $"

#ifndef __M4STRING_H__
#define __M4STRING_H__

/////////////////////////////////////////////////////////////////////////////
// Declarations in this file

	class c4_String;					// general string handling class

/////////////////////////////////////////////////////////////////////////////
// Yet another string class (protocol similar to MFC)

class c4_String
{
public:
	c4_String ();
	c4_String (char ch, int nDup =1);
	c4_String (const char* str);
	c4_String (const unsigned char* str);
	c4_String (const void* ptr, int len);
	c4_String (const c4_String& s);
	~c4_String ();

	const c4_String& operator= (const c4_String&);

	operator const char* () const;
	operator const unsigned char* () const;
	
	char operator[] (int i) const;
	
	friend c4_String operator+ (const c4_String&, const c4_String&);
	friend c4_String operator+ (const c4_String&, const char*);
	friend c4_String operator+ (const char*, const c4_String&);
//	friend c4_String operator+ (const c4_String&, char);
//	friend c4_String operator+ (char, const c4_String&);

	const c4_String& operator+= (const c4_String& s);
	const c4_String& operator+= (const char* s);
//	const c4_String& operator+= (char c);
	
	int GetLength() const;
	bool IsEmpty() const;
	void Empty(); // free up the data
	
	c4_String Mid(int nFirst, int nCount =25000) const;
	c4_String Left(int nCount) const; // first nCount chars
	c4_String Right(int nCount) const; // last nCount chars
					
	friend bool operator== (const c4_String&, const c4_String&); // memcmp
	friend bool operator!= (const c4_String&, const c4_String&); // opposite
	
		// only defined for strings having no zero bytes inside them:
		
	int Compare(const char* str) const; // strcmp
	int CompareNoCase(const char* str) const; // stricmp
	
	bool operator< (const c4_String& str) const;

	int Find(char ch) const; // strchr
	int ReverseFind(char ch) const; // strrchr
	int FindOneOf(const char* set) const; // strpbrk
	
	int Find(const char* sub) const; // strstr
	
	c4_String SpanIncluding(const char* set) const; // strspn
	c4_String SpanExcluding(const char* set) const; // strcspn
	
private:
	void Init(const void* p, int n);
	const char* Data() const;
	int FullLength() const;
	
	unsigned char* _value;
};

bool operator== (const c4_String& s1, const char* s2);
bool operator== (const char* s1, const c4_String& s2);

bool operator!= (const c4_String& s1, const char* s2);
bool operator!= (const char* s1, const c4_String& s2);

//	bool operator== (const c4_String& s1, char s2);
//	bool operator== (char s1, const c4_String& s2);

//	bool operator!= (const c4_String& s1, char s2);
//	bool operator!= (char s1, const c4_String& s2);

/////////////////////////////////////////////////////////////////////////////

#if q4_INLINE
	#include "m4string.inl"
#endif

/////////////////////////////////////////////////////////////////////////////

#endif
