#include <iostream.h>

class Matrix {

  private:
    int rows,cols;
    int **p;    // base of array

  public:
    Matrix(void);
    Matrix(int,int);
    ~Matrix(void);
    void LoadMat(void);
    void DisplayMat(void);
    void operator= (Matrix&);
    Matrix operator+ (Matrix&);
    Matrix operator- (Matrix&);
};

Matrix::Matrix(void) {
    cout << "Enter the number of rows";
    cin >> rows;
    cout << "Enter the number of columns";
    cin >> cols;
    p = new *[rows];
    for (int i=0; i < rows; ++i)
        p[i] = new int[cols];
}
Matrix::Matrix(int inrows, int incols) {
    rows = inrows;
    cols = incols;
    p = new *[rows];
    for (int i=0; i < rows; ++i)
        p[i] = new int[cols];
    cout << " Contructor " << p << "\n";
}

Matrix::~Matrix(void) {
    cout << " Destructor " << p << "\n";
    for (int i=0; i < rows; ++i)
        delete p[i];
    delete p;
}

void Matrix::DisplayMat(void) {
    for (int i=0; i < rows; ++i) {
        for (int j=0; j < cols; ++j) {
            cout << p[i][j] << " ";
        }
        cout << "\n";
    }
    cout << "\n";
}

void Matrix::LoadMat(void) {
    for (int i=0; i < rows; ++i)
        p[i] = new int[cols];
    for (int j=0; j<rows; ++j) {
        for (int k=0; k < cols; ++k) {
            cout << "Enter (" << j << "," << k << ")";
            cin >> p[j][k];
        }
    }
}

void Matrix::operator= (Matrix& RightOp) {
    if (rows == RightOp.rows && cols == RightOp.cols) {
        for (int i=0; i < rows; ++i) {
            for (int j=0; j < cols; ++j) {
                p[i][j] = RightOp.p[i][j];
            }
        }
    }
    else {
        delete p;
        rows = RightOp.rows;
        cols = RightOp.cols;
        p = new *[rows];
        for (int i=0; i < rows; ++i)
            p[i] = new int[cols];
        for (int j=0; j<rows; ++j) {
            for (int k=0; k < cols; ++k) {
                p[j][k] = RightOp.p[j][k];
            }
        }
    }
}

Matrix Matrix::operator+ (Matrix& RightOp) {
    if (rows == RightOp.rows && cols == RightOp.cols) {
        Matrix temp(rows,cols);
        for (int i=0; i < rows; ++i) {
            for (int j=0; j < cols; ++j) {
                temp.p[i][j] = p[i][j] + RightOp.p[i][j];
            }
        }
        return (temp);
    }
    else {
        cout << "Mismatched Matrix sizes in addition function\n";
    }
}

Matrix Matrix::operator- (Matrix& RightOp) {
    if (rows == RightOp.rows && cols == RightOp.cols) {
        Matrix temp(rows,cols);
        for (int i=0; i < rows; ++i) {
            for (int j=0; j < cols; ++j) {
                temp.p[i][j] = p[i][j] - RightOp.p[i][j];
            }
        }
        return (temp);
    }
    else {
        cout << "Mismatched Matrix sizes in subtraction function\n";
    }
}
    

main() {

    Matrix a(2,2),b(2,2),c(2,2);

    a.LoadMat();
    b.LoadMat();

    c=a+b+a+b;

    a.DisplayMat();
    b.DisplayMat();
    c.DisplayMat();           

}