// This code, matrix9.cpp belongs to Rick Bischoff Jr.
// You may use it, change it, whatever to it,
// But do not re-release it under your name, and if you do
// re-release it, please leave it how it was..
// Copyright 1997 Rick Bischoff Jr.
// rick.bischoff@toltbbs.com
// jello4th@aol.com

#include <iostream.h>
#include <stdlib.h>
#include <time.h>

#define ERR -999
#define POS (i*dimC + j)

class Matrix
{
	public:
	Matrix(int r = 0, int c=0)
	{
        if (r>10 || c>11) { dimR=0;dimC=0;dimM=0;}
		else { dimR = r;dimC = c;dimM = dimR*dimC; }
        randomize();
	}

    int addMatrix(Matrix &c, Matrix &a);
	int changeDim(int newR, int newC);
    int detMatrix(void);
	int identMatrix(void);
	int inverseMatrix(void);
	int multiMatrix(Matrix &c, Matrix &a);
    void dispMatrix(void);
	void fillMatrix(float matrix[]);
    int fillMatrix(Matrix &f);
	void rrefMatrix(void);
	void randMatrix(int max);

	protected:

	int dimR;	//Rows, columns, and members
	int dimC;
	int dimM;
	float matrix[101];
	int det2Matrix(void);
    int det3Matrix(void);
};


void Matrix::dispMatrix(void)
{
	int i=0, j=0;
	for (i=0;i<dimR;i++) {
		for (j=0;j<dimC;j++) cout << matrix[POS] << "\t";
		cout << endl;
	}

	return;
}


int Matrix::changeDim(int newR, int newC)
{
        if (newR>10 || newC>11) return (ERR);
	if (newR<0 || newC<0) return (ERR);

	dimR = newR;
	dimC = newC;
        dimM = dimR * dimC;

	return(0);
}

void Matrix::fillMatrix(float newMatrix[])
{
	int i=0, j=0;
    int k=0;

	for (i=0;i<dimR;i++) {
		for (j=0;j<dimC;j++) {
			matrix[k] = newMatrix[k++];
		}
	}

	return;
}

int Matrix::fillMatrix(Matrix &f)
{
	int i=0;

	if (dimR!=f.dimR) return (ERR);
	if (dimC!=f.dimC) return (ERR);

	for (i=0;i<dimM;i++)
		matrix[i] = f.matrix[i];

	return(1);
}

void Matrix::rrefMatrix(void)       //Row reduced Echelon form
{
	int i=0, j=0, k=0;
	float l=0, n[10]={0};
    float m[10][11] = {0};

	for (i=0;i<dimR;i++)
		for (j=0;j<dimC;j++)
			m[i][j] = matrix[k++];

	for (i=0;i<dimR;i++)
	{
		l = m[i][i];
        if (l!=0) {
			for (j=0;j<dimC;j++) m[i][j] = m[i][j]/l;
		}

		for (j=0;j<dimR;j++) {
			if (j!=i) {
				n[j] = -1 * m[j][i];
				for (k=0;k<dimC;k++) m[j][k]= m[j][k] + n[j] * m[i][k];
            }

		}
	}

	k = 0;

	for (i=0;i<dimR;i++)
		for (j=0;j<dimC;j++)
			matrix[k++] = m[i][j];

	return;
}

void Matrix::randMatrix(int max)
{
	int i=0;

	for (i=0;i<dimM;i++) {
		matrix[i] = random(max)+1;
    }

	return;
}

int Matrix::detMatrix()			//Warning!! does not work (for reasons
{                               //unknown to me) for matrices => 7x7
        Matrix test2;
	float testMatrix[91]={0};
	int i=0, j=0, k=0, l=0,m=0;
	float x=0,y[11]={0}, z=0;

        if (dimR!=dimC) return(ERR);

		if (dimR==2) return(det2Matrix());
        if (dimR==3) return(det3Matrix());

        test2.changeDim(dimR-1,dimC-1);

        for(i=0;i<dimC;i++) {
           for (j=1;j<dimR;j++) {
              for (k=0;k<dimC;k++) {
                  x = dimR * j  + k;
                  for (l=1;l<dimR;l++) if ((l*dimR + i)==x) goto test;
		  testMatrix[m++] = matrix[x];
		  test:;
              }
           }

           test2.fillMatrix(testMatrix);
           if ((i%2)==1) k = -1; else k=1;
           y[i] = test2.detMatrix() * matrix[i] * k;
           m=0;
        }

		for (i=0;i<dimC;i++) z = z + y[i];



        return(z);
}

int Matrix::det2Matrix(void)
{
        float i=0,j=0,k=0;
        if (dimR!=2) return(ERR);
        i = matrix[0]*matrix[3];
        j = matrix[1]*matrix[2];
        k = i-j;

        return k;
}

int Matrix::det3Matrix()
{
        if (dimR!=3) return(ERR);
        float i[7] = {0} ;
        i[0] = matrix[0]*matrix[4]*matrix[8];
        i[1] = matrix[1]*matrix[5]*matrix[6];
        i[2] = matrix[2]*matrix[3]*matrix[7];
        i[3] = matrix[2]*matrix[4]*matrix[6];
        i[4] = matrix[1]*matrix[3]*matrix[8];
        i[5] = matrix[0]*matrix[5]*matrix[7];

        i[6] = (i[0] + i[1] + i[2]) - (i[3]  + i[4] + i[5]);
        return (i[6]);
}


int Matrix::inverseMatrix()
{
	int i=0, j=0, k=0;
    float oldMatrix[51] = {0};
    int oldDimC = 0;

	if (dimR!=dimC) return(ERR);
	if (detMatrix()==0) return(ERR);

	for (i=0;i<dimM;i++) oldMatrix[i] = matrix[i];
	oldDimC = dimC;

	changeDim(dimR,2*dimC);
    	
	for (i=0;i<dimR;i++) 
		for (j=0;j<oldDimC;j++)
			matrix[i*dimC + j] = oldMatrix[k++];

	for (i=0;i<dimR;i++)
		for (j=oldDimC;j<dimC;j++) {
			if ((j-dimR)==i) matrix[i*dimC+j] = 1;
			else matrix[i*dimC+j] = 0;
        }

	rrefMatrix();
	

    k=0;
	for (i=0;i<dimR;i++)
		for (j=oldDimC;j<dimC;j++) 
			oldMatrix[k++] = matrix[i*dimC+j];
		
	changeDim(dimR,dimR);

    k=0;
	for (i=0;i<dimR;i++)
		for (j=0;j<dimC;j++)
			matrix[i*dimC+j] = oldMatrix[k++];

	return(1);
}

int Matrix::multiMatrix(Matrix &c, Matrix &a)
{
	int i=0, j=0, k=0;
	float work=0;
    

	if (c.dimC!=a.dimR) return (ERR);

	a.changeDim(dimR,c.dimC);

	for (i=0;i<dimR;i++) {
		for (j=0;j<c.dimC;j++) {
			for (k=0;k<dimC;k++) {
				work = work + matrix[i*dimC + k] * c.matrix[k*c.dimC + j];
			}
			a.matrix[i*c.dimC + j] = work;
			work = 0;
		}
    }


	return (1);
}


int Matrix::identMatrix()
{
	if (dimC!=dimR) return (ERR);

	int i=0, j=0;

	for (i=0;i<dimR;i++) 
		for (j=0;j<dimC;j++) {
			if (j==i) matrix[POS] = 1;
			else matrix[POS]=0;
		}

	return (1);
}
        	
int Matrix::addMatrix(Matrix &c,Matrix &a)
{
	int i=0, j=0;

	if (dimR!=c.dimR) return(ERR);
	if (dimC!=c.dimC) return(ERR);

	a.changeDim(dimR,dimC);

	for (i=0;i<dimR;i++) 
		for (j=0;j<dimR;j++)
			a.matrix[POS] = matrix[POS] + c.matrix[POS];

	return(1);
}







void main()
{
	//randomize();
	 Matrix test(4,4);
	 Matrix pluto(4,4);
     Matrix neptune(4,4);    


     cout.precision(4);

	 test.randMatrix(9);
	 pluto.randMatrix(9);
	 
	 cout << "The determinant is :" << test.detMatrix() << endl;

     test.dispMatrix();
     test.inverseMatrix();
	 test.rrefMatrix();
	 test.dispMatrix();

     test.multiMatrix(pluto,neptune);
	 cout << endl; pluto.dispMatrix();
	 cout << endl; neptune.dispMatrix();	 

	 test.addMatrix(pluto,neptune);
	 cout << endl; pluto.dispMatrix();
	 cout << endl; neptune.dispMatrix();	 


	 test.fillMatrix(pluto);
	 neptune.fillMatrix(pluto);

	 cout << endl; test.dispMatrix();
	 cout << endl; pluto.dispMatrix();
	 cout << endl; neptune.dispMatrix();	 


     return;
}

