///////////////////////////////////////////
//
// grgrp.h
//
// functions for implementing pulldown menu
// groups with MenuPlus
//
// Copyright 1995 Jeffrey A. Schierenbeck
//
////////////////////////////////////////////

#ifndef GRGRPdotH
#define GRGRPdotH

#include <stdlib.h> // for NULL declaration
#include "d:\jssoft\jsmouse\jsmouse.h"

//
// grlist.h
//
// linked list class
//

#ifndef LISTdotH
#define LISTdotH

struct Node
    {grmenu *Item;
     Node *Previous;
    };

class List
    {public:
	Node *Node_ptr;
	List();
	~List();
	void Add(grmenu *NewItem);
	void Trim(void);
    };


List::List()
    {Node *N;
     N = new Node;
     N->Item = NULL;
     N->Previous = NULL;
     Node_ptr = NULL;
    };

List::~List()
    {while(Node_ptr != NULL)
	{Trim();
	};
    };


void List::Add(grmenu *NewItem)
    {Node *N;
     N = new Node;
     N->Item = NewItem;
     N->Previous = Node_ptr;
     Node_ptr = N;
    };


void List::Trim()
    {Node *N = Node_ptr;
     Node_ptr = N->Previous;
     delete N;
    };

#endif


List openedlist;
int topactive = 0;

void control(grmenu *top);
void closeall(void);


void control(grmenu *top)
     {int Selected = 0;
      char oldpos;
      char mcmd = 0;
      while(!Selected)
	  {while(!Selected && !kbhit())
	      {if(mouse.TimesPressed(0))
		    {Node *N = openedlist.Node_ptr;
		     while(N != NULL && !Selected)
			 {oldpos = N->Item->getcurrentpos();
			  mcmd = N->Item->getoption(mouse.x(),mouse.y());
			  if(mcmd)
			       {while(openedlist.Node_ptr != N)
				     {openedlist.Node_ptr->Item->close();
				      openedlist.Trim();
				     };
				Selected = 1;
				openedlist.Node_ptr->Item->refresh(oldpos,
								     mcmd);
				openedlist.Node_ptr->Item->handler(mcmd);
			       }
			  else N = N->Previous;
			 };
		    };
	      };
	   if(!Selected)
		    {char ch=getch();
		     if(topactive)
			  mcmd = openedlist.Node_ptr->Item->getoption(ch);
		     if(mcmd)
			 {if(mcmd == ESC)
			     {if(openedlist.Node_ptr->Previous != NULL)
				  {openedlist.Node_ptr->Item->close();
				   openedlist.Trim();
				   mouse.Show();
				  }
			      else top->refresh();
			     }
			  else openedlist.Node_ptr->Item->handler(mcmd);
			  Selected = 1;
			 };
		    };
	  };
     };



void closeall(void)
     {while(openedlist.Node_ptr->Previous != NULL)
	  {openedlist.Node_ptr->Item->close();
	   openedlist.Trim();
	  };
      openedlist.Node_ptr->Item->refresh();
     };

#endif
