///////////////////////////////////////////////
//
//  txdemo.cpp
//
//  demo for MenuPlus class (text version)
//
//  Copyright 1995 Jeffrey A. Schierenbeck
//
///////////////////////////////////////////////


#include <dos.h> // for interrupt handler functions
#include <conio.h> // for input/output functions
#include "menu.h"  // for menu functions
#include "txgrp.h" // for pull-down group functions
#include "infobox.h" // for dialog boxes
#include "txdemo.h"


void interrupt(*oldhandler)(...);
void interrupt newhandler(...);
void opening_screen(void);


main()
	{topmenubar.initialize();
	 optionmenu.initialize();
	 exitmenu.initialize();
	 helpmenu.initialize();
	 outerwidthmenu.initialize();
	 shadowmenu.initialize();
	 borderstylemenu.initialize();
	 colormenu.initialize();
	 COLORmenu.initialize();
	 samplemenu.initialize();

	 optionmenu.setlr_arrows(ON); // allow the three pulldown
	 exitmenu.setlr_arrows(ON);   // menus to read left and
	 helpmenu.setlr_arrows(ON);   // right arrow keys

	 textbackground(BLUE);
	 _setcursortype(_NOCURSOR);
	 clrscr();
	 opening_screen();

	 topmenubar.open(); // display top menu bar
	 openedlist.Add(&topmenubar); // add to list of opened menus

	 textbackground(BLUE);
	 textcolor(WHITE);
	 gotoxy(16,15);
	 cputs("This menu is a sample. ");
	 gotoxy(16,16);
	 cputs("It is not active.");
	 samplemenu.open();

	 oldhandler = getvect(0x09); // replace keyboard interrupt
	 setvect(0x09, newhandler);  // handler with newhandler

	 while(!done)               // pass control to menugrp.cpp
	     control(&topmenubar);   // control() function

	 _AX = 0x00;         // reset mouse
	 geninterrupt(0x33); //
	 _setcursortype(_NORMALCURSOR);  // restore cursor
	 textbackground(BLACK);
	 textcolor(LIGHTGRAY);
	 clrscr();
	 setvect(0x09, oldhandler);  // restore interrupt handler
	 return(0);
	};



void opening_screen(void)
	{infobox openmessage(14,4,14+52,4+16,CYAN);
	 mouse.Hide();
	 openmessage.open();
	 openmessage.draw_border(WHITE,""," Press any key to continue ");
	 textcolor(BLACK);
	 cputs("\r\nThis is a demonstration program for the MenuPlus\r\n");
	 cputs("menu class. The purpose of this demo is to:\r\n");
	 cputs("      1) serve as an example of how to use\r\n");
	 cputs("         MenuPlus in a program, and\r\n");
	 cputs("      2) show some of the menu formats available\r\n");
	 cputs("         in MenuPlus.\r\n\n");
	 cputs("Activate top menu bar by pressing <ALT> key or by");
	 cputs("left click of mouse on the menu. Once activated,\r\n");
	 cputs("menu items may be selected by left mouse click,\r\n");
	 cputs("by highlighted hotkeys, or by positioning\r\n");
	 cputs("highlight bar with arrow keys and pressing\r\n");
	 cputs("<ENTER> key.");
	 openmessage.wait();
	 openmessage.close();
	};


void techsupport(void)
	{infobox techsup(40,5,40+36,5+12,CYAN);
	 techsup.open();
	 techsup.draw_border(WHITE," Technical Support ",
					" Press any key to continue ");
	 textcolor(BLACK);
	 cputs("\r\nFor questions regarding MenuPlus,");
	 cputs("contact JS Software:\r\n\n");
	 cputs(" Mail:   517 Ingram Drive West\r\n");
	 cputs("         Eau Claire, WI  54701\r\n\n");
	 cputs(" Phone:  715-839-8938\r\n\n");
	 cputs(" E-mail: jssoft@aol.com");
	 techsup.wait();
	 techsup.close();
	};


void aboutmenuplus(void)
	{infobox aboutmp(10,5,10+55,5+11,CYAN);
	 aboutmp.open();
	 aboutmp.draw_border(WHITE," About MenuPlus ",
					" Press any key to continue ");
	 textcolor(BLACK);
	 cputs("\r\nMenuPlus is a menuing class for C++. It provides\r\n");
	 cputs("the programmer with a simple yet versatile tool for\r\n");
	 cputs("incorporating pop-up and pull-down menus in an\r\n");
	 cputs("application. MenuPlus has many features that allow\r\n");
	 cputs("customized menus to suit the needs and styles of\r\n");
	 cputs("individual programs. For more information about the\r\n");
	 cputs("features and operation of MenuPlus, see the\r\n");
	 cputs("MENUPLUS.DOC file distributed with this program.");
	 aboutmp.wait();
	 aboutmp.close();
	};


void gettingaround(void)
	{infobox getaround(10,3,10+57,3+20,CYAN);
	 getaround.open();
	 getaround.draw_border(WHITE," Getting Around Demo ",
					 " Press any key to continue ");
	 textcolor(BLACK);
	 cputs("\r\nMenus display a highlight bar when active. You may\r\n");
	 cputs("select a menu item in any of three ways:\r\n");
	 cputs("     1) Use arrow keys to position highlight bar over\r\n");
	 cputs("        desired menu option and press <ENTER>.\r\n");
	 cputs("     2) Use mouse to postion mouse cursor over desired");
	 cputs("        menu item and click left button of mouse.\r\n");
	 cputs("     3) Press 'hot key' for desired menu item.  Hot\r\n");
	 cputs("        key is highlighted in each item name.\r\n");
	 cputs("\r\nTo activate the menu bar at the top of the screen,\r\n");
	 cputs("either click on one of the items with left button\r\n");
	 cputs("of mouse or press <ALT> key.\r\n");
	 cputs("\r\nYou may move between topmost set of pull-down\r\n");
	 cputs("menus with left and right arrow keys.  Also, you\r\n");
	 cputs("may activate a parent menu item with the left mouse\r\n");
	 cputs("button. Press <ESC> key to exit from a menu.");
	 getaround.wait();
	 getaround.close();
	};


/////////////////////////////////////////////////
//  Newhandler checks each keypress for alt key.
//  If alt key pressed and top menu is not open,
//  top menu is made active (via topactive = 1).
/////////////////////////////////////////////////
void interrupt newhandler(...)
     {_AH = 0x02;
      geninterrupt(0x16);
      if(_AL & 0x08)  // if(alt key pressed)
	  {if(openedlist.Node_ptr->Previous == NULL) // if(topmenu not open)
		{topactive = 1;
		 ungetch(-1); // so control() doesn't pass
			      // 0 to getoption(char)
		};
	  };
      oldhandler();
     };

// end txdemo.cpp