#ifndef _DIALOGS_H
#define _DIALOGS_H

class ChooseDirDialog : public TFileOpenDialog {
	public:
		ChooseDirDialog(TWindow*        parent,
										TData&          data,
										TResId          templateId = 0,
										const char far* title = 0,
										TModule*        module = 0);
	protected:
		void SetupWindow();
		void CmOkClicked();
		TStatic* dir;

	DECLARE_RESPONSE_TABLE(ChooseDirDialog);
};

class TCenteredDialog : public TDialog {
	public:
		TCenteredDialog(TWindow* parent, TResId id, TModule* module = 0) :
			TDialog(parent, id, module) {};
		void SetupWindow();
};

class TimedDlg : public TCenteredDialog {
	public:
		TimedDlg(TWindow* parent, int resId, const char far* text,
			int timeout = 0, TModule* mod = 0);
	protected:
		void SetupWindow();
		void EvTimer(UINT);
    void EvLButtonDown(uint, TPoint&);
	private:
		int timeOut;
		char far* dlgText;
		TStatic* textWin;

	DECLARE_RESPONSE_TABLE(TimedDlg);
};

class ConfigDlg : public TCenteredDialog {
	public:
		ConfigDlg(TWindow* parent);
	protected:
		void SetupWindow();
		void CmOk();
		void AddItem();
		void RemoveItem();
		void ReadFile();
		void EditChanged();
		void DummyClicked() { AddItem(); }
		void SelChanged() { removeBtn->EnableWindow(true); }
	private:
		TListBox* listbox;
		TEdit* edit;
    TStatic* dir;
		TButton* addBtn;
		TButton* removeBtn;
		TRadioButton* globalBtn;
		TRadioButton* projectBtn;
		TOpenSaveDialog::TData fData;

	DECLARE_RESPONSE_TABLE(ConfigDlg);
};

#endif