// C++ class for a doubly linked list -- (c) 1992, PC-Innovations

#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <iostream.h>

struct Node {
  int *data;
  Node *prev;
  Node *next;
};

class List {
   Node *lastnode;
   Node *firstnode;
public:
   List();
   ~List();
   void add(int newdata);
   void show();
};

List::List () {
  lastnode = NULL;
  firstnode = NULL;
}

List::~List() {
  while (lastnode != NULL) {
    Node *n = lastnode;
    lastnode = n->prev;
    delete n;
  };
}

void List::add(int newdata) {
  Node *n;

  n = new Node;
  if (n == NULL) {
    fprintf(stderr, "Out of memory in List::add\n");
    exit(1);
  };
  n->data = new int;
  *n->data = newdata;
  n->prev = lastnode;
  lastnode->next = n;
  n->next = NULL;
  lastnode = n;
  if (firstnode == NULL) firstnode = n;
}

void List::show() {
  Node *current = firstnode;
  while (current != NULL) {
    cout << *current->data << " ";
    current = current->next;
  };
}

void main() {
  int i;
  List *alist;

  alist = new List;
  cout << "C++ Class for linked list -- (C) 1992, PC-Innovations\n\n";
  cout << "Building list\n";
  for (i = 0; i < 1000; i++) {
    alist->add(i);
    cout << i << " ";
  }
  cout << "\nHere it comes!\n";
  alist->show();
  delete alist;
}