// =========================================================
// TEST.CPP
//
// Test program for the stream-style transfer mechanism
//
// Author:  Steve Saxon (Compuserve: 100321,2355)
// Written: 25th August 1994
// =========================================================

#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\edit.h>
#include <owl\radiobut.h>

#include "tfarry.h"
#include "test.rh"

// =========================================================
// TestApp
//
// test application object
// =========================================================
class TestApp : public TApplication
{
public:
	TestApp ();
	virtual ~TestApp ();

	virtual void InitMainWindow();
};

// =========================================================
// TMainWindow
//
// main window object
// =========================================================
class TMainWindow : public TFrameWindow
{

public:
	TMainWindow (LPCSTR lpszTitle);

	void		GetWindowClass (WNDCLASS& wc);
	LPSTR		GetClassName ();

	void		TestDialog ();

	DECLARE_RESPONSE_TABLE (TMainWindow);
};

// =========================================================

TestApp::TestApp () : TApplication("Test System")
{
	EnableCtl3d (TRUE);
}

TestApp::~TestApp ()
{
}

void TestApp::InitMainWindow ()
{
	SetMainWindow (new TMainWindow (GetName ()) );
}

// =========================================================

DEFINE_RESPONSE_TABLE1(TMainWindow, TFrameWindow)
  EV_COMMAND(CM_TEST, TestDialog),
END_RESPONSE_TABLE;

TMainWindow::TMainWindow (LPCSTR lpszTitle)
	: TFrameWindow (NULL, lpszTitle)
{
}

void TMainWindow::GetWindowClass (WNDCLASS& wc)
{
	TFrameWindow::GetWindowClass (wc);

	wc.lpszMenuName = MAKEINTRESOURCE (MENU_1);
}

LPSTR TMainWindow::GetClassName ()
{
	return "Test:Main";
}

void TMainWindow::TestDialog ()
{
	TTransferDialog dlg (this, IDD_TEST);
	TTransferArray	tf;
	TComboBoxData	cbData;
	TListBoxData	lbData;

	new TEdit (&dlg, IDC_EDIT1);
	new TEdit (&dlg, IDC_EDIT2);
	new TComboBox (&dlg, IDC_COMBOBOX1, 20);
	new TRadioButton (&dlg, IDC_RADIOBUTTON1);
	new TRadioButton (&dlg, IDC_RADIOBUTTON2);
	new TCheckBox (&dlg, IDC_CHECKBOX1);
	new TListBox (&dlg, IDC_LISTBOX1);

	dlg.SetTransferArray (&tf);

	tf[IDC_EDIT1].SetText ("Hello World");
	tf[IDC_EDIT2].SetText ("Test of edit #2");
	tf[IDC_RADIOBUTTON2].SetCheck (1);
	tf[IDC_CHECKBOX1].SetCheck (2);

	tf[IDC_COMBOBOX1].SetTransferBuffer (&cbData);
	cbData.AddString ("String #1");
	cbData.AddString ("String #2");
	cbData.AddString ("String #3");
	cbData.AddString ("String #4");

	tf[IDC_LISTBOX1].SetTransferBuffer (&lbData);
	lbData.AddString ("List string #1");
	lbData.AddString ("List string #2");
	lbData.AddString ("List string #3");
	lbData.AddString ("List string #4");
	lbData.Select (2);

	if (dlg.Execute () == IDOK)
	{
		MessageBox (tf[IDC_EDIT1].GetText (), "Test", MB_OK | MB_ICONINFORMATION);

		switch (tf.GetRadioChecked (IDC_RADIOBUTTON1, IDC_RADIOBUTTON2))
		{
			case IDC_RADIOBUTTON1 :
			{
				MessageBox ("IDC_RADIOBUTTON1", "Test", MB_OK | MB_ICONINFORMATION);
				break;
			}
			case IDC_RADIOBUTTON2 :
			{
				MessageBox ("IDC_RADIOBUTTON2", "Test", MB_OK | MB_ICONINFORMATION);
				break;
			}
			default :
			{
				MessageBox ("No radio button checked", "Test", MB_OK | MB_ICONINFORMATION);
				break;
			}
		}
	}
}

// =========================================================

int OwlMain (int , char* [])
{
	TestApp		App;
	int			result;

	result = App.Run();

	return result;
}