


#ifndef TJHGARRY_HPP
#define TJHGARRY_HPP

template<class T>
class TJHugeArray
{
public:
    TJHugeArray( const T& ZeroValue )
    {
        pData_      = new T***[256];
        memset( pData_, 0, 256 * sizeof(T***) );
        pData_[0] = new T**[256];
        memset( pData_[0], 0, 256 * sizeof( T** ) );
        pData_[0][0] = new T*[256];
        memset( pData_[0][0], 0, 256 * sizeof( T* ) );
        pData_[0][0][0] = new T[256];
        lastIndex_ = 0L;
        lastData_  = pData_[0][0][0];
        pZeroValue_ = new T(ZeroValue);
    }

    TJHugeArray()
    {
        pZeroValue_= new T;
        pData_      = new T***[256];
        memset( pData_, 0, 256 * sizeof(T***) );
        pData_[0] = new T**[256];
        memset( pData_[0], 0, 256 * sizeof( T** ) );
        pData_[0][0] = new T*[256];
        memset( pData_[0][0], 0, 256 * sizeof( T* ) );
        pData_[0][0][0] = new T[256];
        lastIndex_ = 0L;
        lastData_  = pData_[0][0][0];
    }

    ~TJHugeArray()
    {
        for( int i = 0 ; i < 256 ; i++ )
        {
            if( pData_[i] )
            {
                for( int j = 0 ; j < 256 ; j++ )
                {
                    if( pData_[i][j] )
                    {
                        for( int k = 0 ; k < 256 ; k++ )
                        {
                            delete[] pData_[i][j][k];
                        }

                        delete[] pData_[i][j];
                    }
                }
                delete[] pData_[i];
            }
        }

        delete[] pData_;
        delete   pZeroValue_;
    }

    T& operator[]( const unsigned long index )
    {
        if( ( index & 0xffffff00 ) == lastIndex_ )
            return lastData_[index & 0x000000ff];

        unsigned long i1 = ( index & 0xff000000 ) >> 24;
        unsigned long i2 = ( index & 0x00ff0000 ) >> 16;
        unsigned long i3 = ( index & 0x0000ff00 ) >>  8;
        unsigned long i4 = ( index & 0x000000ff );

        if( pData_[i1] )
        {
            if( pData_[i1][i2] )
            {
                if( !pData_[i1][i2][i3] )
                {
                    pData_[i1][i2][i3] = new T[256];
                }
            }
            else
            {
                pData_[i1][i2] = new T*[256];
                memset( pData_[i1][i2], 0, 256 * sizeof( T* ) );
                pData_[i1][i2][i3] = new T[256];
            }
        }
        else
        {
            pData_[i1] = new T**[256];
            memset( pData_[i1], 0, 256 * sizeof ( T** ) );
            pData_[i1][i2] = new T*[256];
            memset( pData_[i1][i2], 0, 256 * sizeof( T* ) );
            pData_[i1][i2][i3] = new T[256];
        }

        lastIndex_ = index & 0xffffff00;
        lastData_  = pData_[i1][i2][i3];
        return pData_[i1][i2][i3][i4];
    }

    const T& operator[]( const unsigned long index ) const
    {
        if( ( index & 0xff000000 ) == lastIndex_ )
            return lastData_[index & 0x000000ff];

        unsigned long i1 = ( index & 0xff000000 ) >> 24;
        unsigned long i2 = ( index & 0x00ff0000 ) >> 16;
        unsigned long i3 = ( index & 0x0000ff00 ) >>  8;
        unsigned long i4 = ( index & 0x000000ff );

        if( pData_[i1] )
        {
            if( pData_[i1][i2] )
            {
                if( pData_[i1][i2][i3] )
                {
                    return pData_[i1][i2][i3][i4];
                }
            }
        }

        return (*pZeroValue_);
    }

private:
    T****         pData_;
    T*            pZeroValue_;
    unsigned long lastIndex_;
    T*            lastData_;
    
};

#endif