
#ifndef TJSTRING_HPP
#define TJSTRING_HPP

class TJString
{
public:
    TJString();
    TJString( const TJString& );
    TJString( const char* );

    ~TJString();

    const char& operator[]( const char ) const;
    const char& operator[]( const unsigned char ) const;
    const char& operator[]( const int ) const;
    const char& operator[]( const unsigned int ) const;
    const char& operator[]( const long ) const;
    const char& operator[]( const unsigned long ) const;

    char& operator[]( const char );
    char& operator[]( const unsigned char );
    char& operator[]( const int );
    char& operator[]( const unsigned int );
    char& operator[]( const long );
    char& operator[]( const unsigned long );

    operator char*();

    operator const char*() const;

    TJString& operator=( const TJString& );
    TJString& operator+=( const TJString& );

    TJString& operator=( const char* );
    TJString& operator+=( const char* );

    int operator==( const TJString& ) const;
    int operator!=( const TJString& ) const;
    int operator<( const TJString& )  const;
    int operator>( const TJString& )  const;
    int operator<=( const TJString& ) const;
    int operator>=( const TJString& ) const;

    int operator==( const char* ) const;
    int operator!=( const char* ) const;
    int operator<( const char* )  const;
    int operator>( const char* )  const;
    int operator<=( const char* ) const;
    int operator>=( const char* ) const;

    unsigned long length() const;

    char charAt( const char ) const;
    char charAt( const unsigned char ) const;
    char charAt( const int ) const;
    char charAt( const unsigned int ) const;
    char charAt( const long ) const;
    char charAt( const unsigned long ) const;

    int contains( const TJString& ) const;
    int contains( const char* ) const;

    TJString operator()( const unsigned long, const unsigned long ) const;

    TJString subString( const unsigned long, const unsigned long ) const;
    TJString subStringTo( const unsigned long ) const;
    TJString subStringFrom( const unsigned long ) const;

    TJString& toUpper();
    TJString& toLower();

    TJString& reverse();

    static const TJString TJNULLString;

    void setBufferAddSize( const unsigned long newSize );
    unsigned long bufferAddSize() const;

    unsigned long majorHash() const{return pData_->ulMajorHash_;}
    unsigned long minorHash() const{return pData_->ulMinorHash_;}

private:
    void cloneData();
    void findMajorHash()const;
    void findMinorHash()const;
    void checkReliable() const;
    static unsigned long findHashOf( const char* );
    static unsigned long orderOf( const char );
    static const unsigned long CharSetPriorities[256];

    typedef struct
    {
        char* pData_;
        unsigned long refCount_;
        unsigned long ulDataLength_;
        unsigned long ulBufferLength_;
        unsigned long ulMajorHash_;
        unsigned long ulMinorHash_;
        int           iHasMajorHash_;
        int           iHasMinorHash_;
    } TJStringInternalData;

    TJStringInternalData* pData_;

    int iReliable_;

    unsigned long ulBufferAddSize_;
};

TJString operator+( const TJString&, const TJString& );
TJString operator+( const TJString&, const char* );
TJString operator+( const char*, const TJString& );

unsigned long strlen( const TJString& );

TJString strcpy( TJString&, const TJString& );
TJString strcpy( TJString&, const char* );

TJString strcat( TJString&, const TJString& );
TJString strcat( TJString&, const char* );

int strcmp( const TJString&, const TJString& );
int strcmp( const TJString&, const char* );
int strcmp( const char*, const TJString& );

int strcmpi( const TJString&, const TJString& );
int strcmpi( const TJString&, const char* );
int strcmpi( const char*, const TJString& );

TJString reverseOf( const TJString& );
TJString upperCaseOf( const TJString& );
TJString lowerCaseOf( const TJString& );

int operator==( const char*, const TJString& );
int operator!=( const char*, const TJString& );
int operator<( const char*, const TJString& );
int operator<=( const char*, const TJString& );
int operator>(const char*, const TJString& );
int operator>=( const char*, const TJString& );

#endif
