// PIPE.HPP   Copyright 1989 by Dlugosz Software
// Pipes for the C++ multitasking system

class pipe {
   byte* buffer;
   unsigned bufsize, room;
   unsigned writepos, readpos;
   semaphore reader, writer;
   semaphore in_use, suspend;
   bool dynamic;
   // functions to manage a circular queue
   void get (void*, unsigned);
   void put (void*, unsigned);
protected:
   bool send (void* data, unsigned size);
   bool receive (void* buffer, unsigned size);
public:
   pipe (void* buffer, unsigned size);  //use this buffer
   pipe (unsigned size);  //allocate a buffer dynamically
   ~pipe();
   unsigned contents() { return bufsize - room; }  //how much is in there?
   };

class pipe_reader : public pipe {
   pipe_reader(unsigned size) : (size) {}  //never used, but keep the compiler happy
public:
   bool receive (void* buffer, unsigned size)
                { return pipe::receive(buffer, size); }
   };


class pipe_writer : public pipe {
   pipe_writer(unsigned size) : (size) {}  //never used, but keep the compiler happy
public:
   bool send (void* data, unsigned size) { return pipe::send (data,size); }
   };

