/*****************************************************
File: SEM.CPP       Copyright 1989 by Dlugosz Software
   Semaphore class from the C++ multitasking system.
*****************************************************/

#include "usual.hpp"
#include "task.hpp"
#include "sem.hpp"

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

semaphore::semaphore (unsigned initial_value)
{
value= initial_value;
// task_list is implicitly initialized
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

semaphore::semaphore()
{
// this constructor is provided so you can have arrays of semaphores
value= 1;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

bool semaphore::wait()
{
int newval;
// first, decrement the value
{  race_condition_cure _;
   newval= --value;
   }
if (newval < 0) {
   // gotta wait
   active_task->block(blocked);  //put it in my list
   /* ... in limbo ...*/
   //I'm back.  A siginal has caused this task to be resumed, or
   //the task was run as part of shutdown
   if (active_task->iskilled() || active_task->isfaulted()) {  //abnormal
      if (active_task->iskilled()) //fix up semaphore count
         value++;  //I left the blocked list, correct the count
         /* If you're wondering why I can just say value++ without
            worry, It is because the task on the 'kill run' is not
            preemptable. */
      return FALSE;  //abnormal return
      }
   }
return TRUE;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void semaphore::signal()
{
int newval;
// increment the value
{  race_condition_cure _;
   newval= ++value;
   }
if (newval < 1)  //I just freed up a blocked task
   blocked.resume_one();
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */
