// SEM.HPP   Copyright 1989 by Dlugosz Software
// from multitasking classes

class semaphore {
   int value;
   task_list blocked;
public:
   semaphore (unsigned initial_value);
   semaphore();  //uses initial value of 1
   ~semaphore() {}
      //the destructor for the blocked list sends errors to waiting tasks
   bool wait();
      /* normally returns TRUE.  Will return FALSE if the semaphore is
         destroyed before the Siginal is received.  */
   void signal();
   int count() { return value; }
      /* a positive or 0 value indicates how many more wait's can be sent.
         The absolute value of a negative value is the number of tasks
         waiting for siginals.  */
   // supply some synonyms for variety
   bool operator--() { return wait(); }
   void operator++() { signal(); }
   operator int() { return value; }
   };


// a class to impose structure on semaphores used for mutual exclusion
class resource_lock {
   semaphore* sem;
public:
   resource_lock (semaphore &x) { sem= &x;  x.wait(); }
   ~resource_lock() { sem->signal(); }
   };
