// TASK.HPP   Copyright 1989 by Dlugosz Software
// from multitasking classes

class task;  //forward reference

class task_head {  // allow tasks to be placed in lists
   task_head* prev;
   task_head* next;  // a two-way linked list
public:
   friend class task_iterator;
   void add_to_head (task *);   //place at beginning of list
   void add_to_end (task *);    //place at end of list
   void unlink();  //remove from its list
   void zero();  //initialize to empty
   task* fetch_and_remove();
   };

class task_list : public task_head {
   // add a constructor and destructor destructor to manage a list of tasks
   void unlink() {}
public:
   task_list() { zero(); }
   ~task_list();
   bool resume_one();
   };

class task_iterator {   //scan through a task_list
   task_list* start;
   task_head* current;
   inline task* result();
public:
   task_iterator (task_list& l) {current= start= &l;}
   ~task_iterator() {}
   task* next();  // next() and prev() return NULL when the list is done
   task* prev();
   task* same();  // don't move, but fetch the same one again
   };


typedef void (*starter_function) (void *);

class task : public task_head {
   friend void scheduler();
   friend void fall_through();
   friend void preemptable (bool);
   void far* stack;  //all other values on stack
   int priority_level;
   enum {preemptive=1, killable=2, killed=4, blocked=8, faulted=16 }  flags;
public:
   void kill();
   bool iskilled() { return flags&killed; }
   bool isblocked() { return flags&blocked; }
   bool isfaulted() { return flags&faulted; }
   task (starter_function f, int priority, void* stack, int stacksize, void* arg= NULL);
   ~task() { kill(); }
   //not generally used directly, but used by other classes in the system
   void block (task_list&);
   void unblock (bool error= FALSE);
   void add_to_list (task_list& l) { l.add_to_end(this); }
   };


extern void task_yield();
extern task* active_task;

extern void scheduler();  //call to enter multitasking mode

// do NOT call these functions yourself.
// There is no way to prevent entering the names into global scope if I
// want the class below to generate inline code.
extern void preempt_off();
extern void preempt_on();


// a dummy class for disableing preemption
// this makes sure preempt state cannot be messed up with
// mismatched off/on calls
struct race_condition_cure {
   race_condition_cure() {
      preempt_off();
      }
   ~race_condition_cure() {
      preempt_on();
      // >>should check for slice overrun
      }
   };
