/*****************************************************
File: TASKMEM.CPP   Copyright 1989 by Dlugosz Software
   make new and delete lock under multitasking
*****************************************************/

#include "usual.hpp"
#include "task.hpp"
#include "sem.hpp"
#include <stdlib.h>
   //for malloc() and free()

/* link this into a multitasking program so that new and delete
   will get an exclusive lock when processing.  Otherwise, you
   could clobber the heap when a malloc() is pre-empted and
   another malloc() is called in another task!  */

void (* _new_handler)()= NULL;
   /* I must define this, because Zortech's library defines it in the
      same module as operator new.  So if this symbol is fetched from
      the library, operator new comes with it and I get a linker
      error.  */

semaphore MEM;


/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void* operator new (long size)
{
if (size == 0) return NULL;
void* p;
{  resource_lock x(MEM);
   p= malloc((unsigned)size);
   }
if (!p && _new_handler) {
   // call handler and then retry
   _new_handler();
   resource_lock x(MEM);
   p= malloc((unsigned)size);
   }
return p;
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void operator delete (void* p)
{
resource_lock x(MEM);
free (p);
}
