#include "usual.hpp"
#include <stream.hpp>
#include "task.hpp"
#include "sem.hpp"
#include "mess.hpp"
#include "pipe.hpp"
#include <string.h>
   //need strlen()

static char pipe_buf[100];
pipe P (pipe_buf, sizeof pipe_buf);

semaphore master(0);  //used so master task can wait for sub-tasks to finish

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void task1 (pipe_reader* p)
{
char c;
/* loop until the task is killed.  When the task is killed, finish
   printing what is in the pipe.  Also, drop out if receive() fails which
   means the pipe was destroyed.  */
while (!(active_task->iskilled() && p->contents()==0) && p->receive (&c, 1))
   cout.put(c);
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void task2 (pipe_writer* p)
{
static char* strings[]= { "This is task2 reporting in\n",
   "Task2 is still on the line\n", "Task2 sending third string\n",
   "Task2 running out of things to say\n",
   "This is task2 again, really having a hard time coming up with material\n"
   "Task2 saying bye-bye\n",  NULL };
for (int loop= 0; strings[loop]; loop++)
   p->send(strings[loop], strlen(strings[loop]));

master.signal();  //inform master that I'm done
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void task3 (pipe_writer* p)
{
static char* strings[]= { "This is task3 reporting in\n",
   "Task3 is still on the line\n", "Task3 sending third string\n",
   "Task3 running out of things to say\n",
   "This is task3 again, really having a hard time coming up with material\n"
   "Task3 saying bye-bye\n",  NULL };
for (int loop= 0; strings[loop]; loop++)
   p->send(strings[loop], strlen(strings[loop]));

master.signal();  //inform master that I'm done
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

void master_task (void*)
{
preemptable(FALSE);
unsigned st1[512],st2[512],st3[512];  //stacks
static char pipe_buf[100];
pipe P (pipe_buf, sizeof pipe_buf);

task t1 (task1, 2, st1, 1024, (pipe_reader*)&P);
task t2 (task2, 2, st2, 1024, (pipe_writer*)&P);
task t3 (task3, 2, st3, 1024, (pipe_writer*)&P);
master.wait();  //wait for one writer to finish
master.wait();  //wait for other writer to finish
}

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

int _stack= 30000;  //used by Zortech to set stack size

main()
{
unsigned stack_space[2048];
task master (master_task, 20, stack_space, sizeof stack_space);
scheduler();
}

