

// A second version of the reminder program: prints out the data in
// chronological order.
//
// M. A. Sridhar
// Feb 13, 1994

#include <stdio.h>
#include "base/base.h"

class ReminderEntry: public CL_Object {

public:
    ReminderEntry (const CL_Date& dt, const CL_String& msg);

    // Override CL_Object's operator< and operator== so that we can sort
    // sequences of ReminderEntry objects: (alternatively, the Compare
    // method can be overridden)
    bool operator== (const CL_Object& o) const;
    bool operator<  (const CL_Object& o) const;

    // Data elements:
    CL_Date _date;
    CL_String _msg;
};


ReminderEntry::ReminderEntry (const CL_Date& dt, const CL_String& msg)
: _date (dt), _msg (msg)
{
}


// Override CL_Object's operator< and operator== so that we can sort
// sequences of ReminderEntry objects:
bool ReminderEntry::operator== (const CL_Object& o) const
{
    return (_date == ((const ReminderEntry&) o)._date &&
            _msg == ((const ReminderEntry&) o)._msg);
}

bool ReminderEntry::operator<  (const CL_Object& o) const
{
    return (_date < ((const ReminderEntry&) o)._date);
}


// -------------------------- Main program --------------------------    

void main ()
{
    char line[200];
    CL_Date today = CL_Date::Today();
    CL_ObjectSequence result;
    while (gets(line)) {
        CL_String s (line);
        if (s.Size() <= 0) continue; // Allow for blank lines
        CL_String fld[2];
        s.Split (fld, 2);
        short month = fld[0].Field (1, "/").AsLong();
        short day   = fld[0].Field (2, "/").AsLong();
        if (month >= 1 && month <= 12 && day >= 1 && day <=
            CL_Date::DaysInMonth (month, today.Year())) {
            CL_Date date (today.Year(), month, day);
            short ndays = date - today;
            if (ndays >= 0 && ndays <= 5)
                result.Add (new ReminderEntry (date, fld[1]));
        }
    }
    result.Sort ();
    for (short i = 0; i < result.Size(); i++) {
        ReminderEntry* p = (ReminderEntry*) result[i];
        printf ("%s: %s\n", p->_date.AsString().AsPtr(),
                p->_msg.AsPtr());
    }
    result.DestroyContents();
}

