

# -------------------------------------------------------------------------
#                 Control file for Borland C++ make                       |
#--------------------------------------------------------------------------

.AUTODEPEND

#
# ---------------------- What platform do we want? -------------
#

!if !$d(YACLPLATFORM)
!if $d(__OS2__)
YACLPLATFORM = os2
!elif $d(WINDOWS) || $d(__MS_WINDOWS__)
YACLPLATFORM = windows
!elif $d(__DOS__) || $d(DOS)
YACLPLATFORM = dos
!else
YACLPLATFORM = windows # By default, develop for Windows
!endif
!endif




#
# ---------------------  Command names -------------------------
#

COPY    = copy
DELETE  = del
RENAME  = mv
SED     = sed
FIND    = find
AWK     = gawk
LIBR    = tlib
CC      = bcc
UNZIP   = unzip
!if $(YACLPLATFORM) == dos || $(YACLPLATFORM) == windows
ZIP     = zip386
!else
ZIP     = zip
!endif
!if $(YACLPLATFORM) == os2
SH      = bash
!else
SH      = sh
!endif




#
# ---------------------- Path names ----------------------------
#

!if !$d(BCPATH)
!if $(YACLPLATFORM) == os2
BCPATH      = d:\bcos2
!else
BCPATH      = d:\BORLANDC
!endif
!endif

!if !$d(YACLPATH)
!error Please define the environment variable YACLPATH.
!endif


# ------------- Should not need to change anything below this line --------

YACLLIB     = $(YACLPATH)\lib\$(YACLPLATFORM)
INCLUDE     = $(BCPATH)\INCLUDE;$(YACLPATH)
LIB         = $(BCPATH)\LIB;$(YACLLIB)


#
# ---------------------- YACL components --------------------
#

BASE     = base
MEMORY   = memory
IO       = io
BASELIB  = $(YACLLIB)\$(BASE).lib
IOLIB    = $(YACLLIB)\$(IO).lib
!if $(YACLPLATFORM) == windows || $(YACLPLATFORM) == os2
# UI with Borland C++ is currently only supported under Windows
UI       = ui
UILIB    = $(YACLLIB)\$(UI).lib
!endif



#
#  ---------------------------- Compile options ------------------------
#



!if !$d(NOINLINE)
INLINE  = -vi
!endif

!if $d(DEBUG)
DEBUG  = -v
!endif

!if $(YACLPLATFORM) == os2
C0OBJ=c02
CLIB =c2 os2
MATH = 
EMU =
IMPORT =
CCOPTS  = -Pcxx -c -I$(INCLUDE) $(INLINE)
LNKOPTS = $(DEBUG) -c 
!elif $(YACLPLATFORM) == dos
C0OBJ    = c0l
CLIB     = cl
MATH     = mathl
EMU      = emu
MODEL    = -ml
DEFINE = -D__DOS__
CCOPTS  = -Pcxx -c -3  $(DEFINE) $(WINOPTS) $(MODEL) \
-I$(INCLUDE) $(INLINE)
LNKOPTS = $(DEBUG) -L$(YACLPATH)\lib\$(YACLPLATFORM) $(WINLINK) \
-C -c -m -s -Vt
!else
WINOPTS  = -WS -Vf
WINLINK  = -Twe
C0OBJ    = c0wl
CLIB     = cwl
MATH     = mathwl
EMU      =
IMPORT   = import
MODEL    = -ml
THREED   = ctl3d
DEFINE = -D__MS_WINDOWS__ -DWINDOWS
CCOPTS  = -Pcxx -c -3  $(DEFINE) $(WINOPTS) $(MODEL) \
-I$(INCLUDE) $(INLINE)
LNKOPTS = $(DEBUG) -L$(YACLPATH)\lib\$(YACLPLATFORM) $(WINLINK) \
-C -c -m -s -Vt
!endif



# Processor options:

OPTIMIZE  = -O1
# Without optimizing, the Map object file will be too big under
# Borland C++ 4.0.

WARNINGS = -wbbf -weas -wamb -wamp -wdef -wnod -wstv -wuse -wcln \
-wucp -wpre
# -wsig is omitted, because we get lots of those warnings

!if $d(DEBUG)
CCOPTS = $(CCOPTS) -v -DDEBUG
!endif

LNKLIB  = $(BASE) $(IO) $(UI) $(MEMORY) $(THREED) $(EMU)  $(MATH) \
$(IMPORT)  $(CLIB) 


