




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#include <setjmp.h>

#if defined(__MS_WINDOWS__)
#    include <dos.h>
#    include <windows.h>
#    include <ctl3d.h>
#elif defined(__X_MOTIF__)
#    include <X11/Xlib.h>
#    include <X11/Intrinsic.h>
#    include <iostream.h>
#elif defined(__OS2__)
#    include <stdlib.h>
#    define INCL_PM
#    include <os2.h>
#endif


#include "base/error.h"
#include "base/string.h"
#include "base/strgseq.h"

#include "ui/applic.h"
#include "ui/composit.h"
#include "ui/cntroler.h"

// --------------------------- Global variables ------------------------

UI_Application* _TheApplication = NULL;

#if defined(__UNIX__)
#define ENVIRONMENT environ
extern char** environ;
#elif __BCPLUSPLUS__ > 0x310
#define ENVIRONMENT _environ
#else
#define ENVIRONMENT environ
#endif


// ----------------------------------------------------------------


#if defined(__MS_WINDOWS__) && defined(DEBUG)
static HWND _DebugWindow = 0;
static HFONT _DebugFont = 0;
static long  count = 0;
#endif

static bool ErrorHandler (const char* message)
{
#if defined(__MS_WINDOWS__)
#if defined(DEBUG)
    if (_DebugWindow) {
        CL_String s = "(" + CL_String(++count) + ") " +
            CL_String (message) + "\r\n";
        SendMessage (_DebugWindow, EM_REPLACESEL, 0,
                     (LPARAM) s.AsPtr());
    }
#else
    MessageBox (NULL, message, "YACL", MB_ICONEXCLAMATION | MB_OK);
#endif
#elif defined(__X_MOTIF__)
    cerr << "YACL: " <<  message << endl;
#elif defined(__OS2__)
#if defined(DEBUG)
    static HWND dbugWin = 0;
    static HWND dbugWinFrame = 0;
    static short count = 0;
    if (!dbugWin) {
        ulong style = FCF_SHELLPOSITION | FCF_TITLEBAR | FCF_SIZEBORDER |
            FCF_VERTSCROLL;
        dbugWinFrame = WinCreateStdWindow
            (HWND_DESKTOP, WS_VISIBLE, &style,
             WC_MLE, "DEBUG", 0, 0, 0, &dbugWin);
    }
    CL_String s = "(" + CL_String (++count) + ") " + message;
    WinSendMsg (dbugWin, MLM_INSERT, (MPARAM) s.AsPtr(), 0);
#else
    static const short ID_MESSAGEBOX = 501; // Arbitrary value
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, (PCH) message,
                  (PCH) "YACL", ID_MESSAGEBOX,
                  MB_OK | MB_APPLMODAL | MB_MOVEABLE | MB_ERROR);
#endif
#endif
    return TRUE;
}



UI_Application::UI_Application()
{
    CL_Error::SetWarningHandler    (ErrorHandler);
    CL_Error::SetFatalErrorHandler (ErrorHandler);

    if (_TheApplication)
        CL_Error::Fatal ("Application constructor: attempt to construct"
                         "more than one Application object!");
    _TheApplication = this;
    // Set up the environment map
    for (short i = 0; ENVIRONMENT[i] != NULL; i++) {
        CL_String s (ENVIRONMENT[i]);
        short j = s.CharIndex ('=');
        if (j >= 0)
            _env.Add (s(0,j), s.Suffix(j+1));
    }
}



UI_Application::~UI_Application()
{
    delete _controller;
#if defined(__MS_WINDOWS__)
#if defined(DEBUG)
    DestroyWindow (_DebugWindow);
    DeleteObject (_DebugFont);
#endif
    Ctl3dUnregister (pid);
#endif
}


CL_String UI_Application::Name () const
{
    return _name;
}


CL_String UI_Application::AppClass () const
{
    CL_String t = _name;
    t.WordCapitalize();
    return t;
}



#if defined(__MS_WINDOWS__)

void UI_Application::Initialize
    (HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdln, int nCmdShow)
{
    pid = hInstance;
    _name = CL_String (lpCmdln).Field (1);
    _controller = new UI_Controller ( this );
    _controller->Initialize (hInstance, hPrevInstance, lpCmdln, nCmdShow);

#if defined(DEBUG)
    _DebugWindow = CreateWindow
        ("edit", "DEBUG",
         ES_MULTILINE  | WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_VSCROLL,
         CW_USEDEFAULT, CW_USEDEFAULT, 500, 400,
         NULL, NULL, hInstance, NULL);
    _DebugFont = CreateFont (10, 0, 0, 0, FW_BOLD, 0, 0, 0, DEFAULT_CHARSET,
                              OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS,
                              DEFAULT_QUALITY, DEFAULT_PITCH | FF_DONTCARE,
                              "Courier");
    SendMessage (_DebugWindow, WM_SETFONT, _DebugFont, 0);
#endif
    Ctl3dRegister (pid);
    Ctl3dAutoSubclass (pid);
}


#elif defined(__X_MOTIF__)
void UI_Application::Initialize (int& argc, char* argv[])
{
    CL_StringSequence seq =  CL_String (argv[0]).Split ("/");
    _name = seq[seq.Size()-1];
    _controller = new UI_Controller (this);
    _controller->Initialize (argc, argv);
    _controller->DispatchPendingEvents();
}
#elif defined(__OS2__)
void UI_Application::Initialize (int /* argc */, char* argv[])
{
    _name = argv[0];
    _controller = new UI_Controller (this);
    _controller->Initialize ();
    //    _controller->DispatchPendingEvents();
}
#endif



void UI_Application::MakeTopWindow (UI_CompositeVObject* root)
{
    _controller-> MakeTopWindow (root);
}



void UI_Application::Destroy(UI_VisualObject *v)
{
    if (v !=NULL && _controller->Root() != NULL)
        _controller->AddEvent (new UI_Event (Event_Quit, v));
    // Instead of: _controller->Destroy (v);
}



bool UI_Application::ConditionalDestroy (UI_VisualObject *v)
{
    if ( v == NULL || _controller->Root () == NULL )
        return FALSE;

    if ( v->WantToQuit () ) {
        _controller->AddEvent (new UI_Event (Event_Quit, v));
        // Instead of: _controller->Destroy (v);
        return TRUE;
    }

    return FALSE;
}



void UI_Application::Run ()
{   
    if ( _controller  ) 
        _controller->Run ();
}



void UI_Application::End ()
{
    _controller->AddEvent (new UI_Event
                           (Event_Quit, _controller->Root ()));
}




UI_CompositeVObject* UI_Application::MainWindow () const
{
    return _controller->Root();
}


CL_String UI_Application::InstanceName (UI_VisualObject* v)
{
    return CL_String (v->ClassName()) + "_" +
        CL_String (_controller->GetNextWidgetCount());
}


UI_Rectangle UI_Application::ScreenRect () const
{
#if defined(__MS_WINDOWS__)
    RECT r;
    GetClientRect (GetDesktopWindow (), &r);
    return UI_Rectangle (r.left, r.top, r.right-r.left+1,
                         r.bottom-r.top+1
                        );

#elif defined (__X_MOTIF__)
    Screen* screen;
    screen = DefaultScreenOfDisplay
        (XtDisplay ((Widget) (_controller->Root()->ViewHandle())));
    long height = HeightOfScreen (screen);
    long width  = WidthOfScreen  (screen);
    return UI_Rectangle (0, 0, width, height);

#elif defined(__OS2__)
    RECTL rect;
    WinQueryWindowRect  (HWND_DESKTOP, &rect);
    return UI_Rectangle (rect.xLeft, rect.yTop, rect.xRight - rect.xLeft + 1,
                          rect.yTop  - rect.yBottom + 1);
#endif
}


UI_Point UI_Application::AsScreenPoint (const UI_Point& p,
                                        UI_VisualObject* vObj) const
{
    if (!vObj)
        return UI_Point (0, 0);
#if defined(__X_MOTIF__)
    Position x, y;
    XtTranslateCoords (vObj->ViewHandle(), p.XCoord(), p.YCoord(),
                       &x, &y);
    return UI_Point (x, y);

#elif defined(__OS2__)
    POINTL pt;
    pt.x = p.XCoord();
    pt.y = p.YCoord();
    WinMapWindowPoints (vObj->ViewHandle(), HWND_DESKTOP, &pt, 1);
    return UI_Point (pt.x, pt.y);
#elif defined(__MS_WINDOWS__)
    POINT pt;
    pt.x = p.XCoord();
    pt.y = p.YCoord();
    ClientToScreen (vObj->ViewHandle(), &pt);
    return UI_Point (pt.x, pt.y);
#elif defined(__OS2__)
    NotImplemented ("AsScreenPoint");
    return UI_Point (0, 0);
#endif
}



#if defined(__OS2__)
UI_Rectangle UI_Application::YACLRect (UI_ViewHandle parent, const RECTL&
                                       rect) const
{
    long ht = _YACLWindowHeight (parent);
    return UI_Rectangle (rect.xLeft, ht - rect.yTop,
                         rect.xRight - rect.xLeft + 1,
                         rect.yTop - rect.yBottom + 1);
}


void UI_Application::PMError ()
{
    PERRINFO  errInfo;
    PSZ       offset;
    PSZ  errMsg;

    HAB hab = _TheApplication->_controller->AnchorBlockHandle();
    if ((errInfo = WinGetErrorInfo (hab)) != NULL) {
        offset = ((PSZ) errInfo) + errInfo->offaoffszMsg;
        errMsg = ((PSZ) errInfo) + *((PSHORT) offset);
        CL_Error::Warning ("PM Error: %s\n", errMsg);
        WinFreeErrorInfo (errInfo);
    }
}

#endif

