#ifndef _applic_h_
#define _applic_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik


// This class provides the basic behaviour of ``global state'' of an
// application. It includes methods for destroying individual views,
// (conditionally) terminating the application itself, creating and
// destroying the root window for the application, and the like.  It also
// includes the main entry point and initialization code for the
// application.


#include "ui/composit.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>
#endif

class UI_Controller;

class UI_Application: public CL_Object {

public:

    // --------------- Construction and destruction ---------------------
    UI_Application();
    // Default constructor.

    virtual ~UI_Application();
    // Destructor.

#if defined(__MS_WINDOWS__)
    virtual void Initialize (HANDLE hInstance, HANDLE hPrevInstance,
                             LPSTR lpCmdln, int nCmdShow);
    // [MS-Windows-specific method]
    // Instantiates and initializes the controller.
    
    
#elif defined(__X_MOTIF__)
    virtual void Initialize (int& argc, char *argv[]);
    // [X-Windows-specific method]
    // Instantiates and initializes the controller.

#elif defined(__OS2__)
    virtual void Initialize (int argc, char *argv[]);
    // [OS/2-specific method]
    // Instantiates and initializes the controller.

#endif

    // ------------------------- Querying -----------------------------
    
    long ProcessId () const {return pid; };
    // Return the process id of this process. This method returns the
    // handle to the instance under MS-Windows.

    const CL_StringStringMap& Environment () const {return _env;};
    // Return a reference to a map containing the environment variables and
    // their values. Note that some environment variables may have null
    // values associated with them, because they were set that way;
    // therefore, unlike the conventions with YACL Maps, the fact that {\tt
    // Environment ()[v] == ""} does not mean that {\tt v} is not a defined
    // environment variable. This must be ascertained explicitly via the
    // {\tt IncludesKey} method.
    
    UI_CompositeVObject* MainWindow () const;
    // Return the root window of the application.

    UI_Rectangle ScreenRect () const;
    // Return the rectangle corresponding to the screen. Its origin will
    // be set at (0,0).

    UI_Point AsScreenPoint (const UI_Point& windowPoint,
                            UI_VisualObject* vObj) const;
    // Given a point in the co-ordinate space of {\tt vObj}, translate it to
    // screen co-ordinates and return the result.
    
    
    UI_Controller& Controller();  
    // Return a reference to the underlying controller object. 

    // --------------- Creating and destroying views ------------------
    
    void MakeTopWindow (UI_CompositeVObject* topWindow);
    // Make the given object the root window of the application. This method
    // must be called only once, at the beginning of the application.

    virtual bool ConditionalDestroy (UI_VisualObject* v);
    // ConditionalDestroy invokes {\small\tt v->WantToQuit()}; if
    // the latter returns TRUE, then {\small\tt v} is destroyed. This
    // method returns TRUE if {\small\tt v}
    // was destroyed, FALSE if the {\small\tt WantToQuit()} returned FALSE.

    virtual void Destroy (UI_VisualObject* v);
    // Unconditionally destroys the given visual object.

    // --------------------------- Execution ------------------------

    int Main (int argc, char* argv[]);
    // Alternate entry point for the user interface library.
    
    virtual void Run ();
    // Execute the application. Simply invokes {\tt Run()} on the controller.

    virtual void End ();
    // Terminate the application. This method generates a CloseDown event for
    // the root window. This results in calling the WantToQuit method of the
    // root, and if the latter returns TRUE, closing the application.

    virtual void IdleAction() {};
    // Perform any necessary idle action; called when the controller is
    // idle, with no events available. The default implementation does
    // nothing.

    // ------------------------- Miscellaneous services --------------
    virtual CL_String InstanceName (UI_VisualObject* v);
    // Return the instance name of the given visual object. This method is
    // used under X-windows to set the instance name at the time of widget
    // creation; it is not used inder MS-Windows.

    virtual CL_String Name () const;
    // Return the name of this application. The default implementation
    // returnes the name of the application's executable file. This method
    // is used to determine the application's name under X windows, and
    // derived classes may override it; it is
    // not used under MS-Windows.
    
    virtual CL_String AppClass () const;
    // Return the class name of this application. The default implementation
    // returnes the string returned by the {\tt Name} method with its first
    // letter capitalized (to meet the X windows convention). This method
    // is used to determine the application's class under X windows; it is
    // not used under MS-Windows.
    
    // --------------------- End public protocol -----------------------
    
protected:
    
    UI_Controller*     _controller;
    CL_StringStringMap _env;
    
#if defined(__MS_WINDOWS__)
    HANDLE pid;
#elif defined(__OS2__)
    ulong  pid;
#elif defined(__X_MOTIF__)
    long pid;
#endif
    CL_String _name;

public:
#if defined(__OS2__)
    UI_Rectangle YACLRect (UI_ViewHandle parent, const RECTL& rect) const;
    // [OS/2-specific, internal use only]

    static void PMError ();
    // [OS/2-specific, internal use only] Ask PM for the most recent error
    // string, and send it out as {\tt CL_Error::Warning}.
    
#endif
    
};



extern UI_Application* _TheApplication; // The single application instance


inline UI_Controller& UI_Application::Controller ()
{
    return *_controller; 

}


#endif
