





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



#if defined (__MS_WINDOWS__)
#define OEMRESOURCE
#include <windows.h>

#elif defined (__X_MOTIF__)
#include <X11/Intrinsic.h>
#endif



#include "base/string.h"

#include "ui/bitmap.h"
#include "ui/cntroler.h"
#include "ui/dsplsurf.h"


UI_Bitmap::UI_Bitmap ()
{
    _handle = 0;
    _width  = 0;
    _height = 0;
}


#if defined (__MS_WINDOWS__)
static struct {
    char* name;
    long  code;
} BuiltIn [] = {
"+OBM_CLOSE"   , OBM_CLOSE   ,
"+OBM_UPARROW" , OBM_UPARROW ,
"+OBM_DNARROW" , OBM_DNARROW ,
"+OBM_RGARROW" , OBM_RGARROW ,
"+OBM_LFARROW" , OBM_LFARROW ,
"+OBM_REDUCE"  , OBM_REDUCE  ,
"+OBM_ZOOM"    , OBM_ZOOM    ,
"+OBM_RESTORE" , OBM_RESTORE ,
"+OBM_REDUCED" , OBM_REDUCED ,
"+OBM_ZOOMD"   , OBM_ZOOMD   ,
"+OBM_RESTORED", OBM_RESTORED,
"+OBM_UPARROWD", OBM_UPARROWD,
"+OBM_DNARROWD", OBM_DNARROWD,
"+OBM_RGARROWD", OBM_RGARROWD,
"+OBM_LFARROWD", OBM_LFARROWD,
"+OBM_MNARROW" , OBM_MNARROW ,
"+OBM_COMBO"   , OBM_COMBO   ,
"+OBM_UPARROWI", OBM_UPARROWI,
"+OBM_DNARROWI", OBM_DNARROWI,
0, 0
};

#endif

#if defined (__MS_WINDOWS__)
UI_Bitmap::UI_Bitmap (const char* name)
{
    if (name && name[0] == '+') {
        for (short i = 0; BuiltIn[i].name != 0; i++) {
            if (CL_String (name) == BuiltIn[i].name)
                break;
        }
        _handle = LoadBitmap (NULL, (LPSTR) BuiltIn[i].code);
    }
    else
        _handle = LoadBitmap (NULL, (LPSTR) name);
    if (_handle) {
        BITMAP  bm;
        GetObject (_handle, sizeof (BITMAP), (LPSTR) &bm);
        _bitsPerPixel = bm.bmBitsPixel;
        _width        = bm.bmWidth;
        _height       = bm.bmHeight;
    }
    else
        _bitsPerPixel = _width = _height = 0;
}

#endif



UI_Bitmap::~UI_Bitmap ()
{
#if defined (__MS_WINDOWS__)
    if (_handle)
        DeleteObject (_handle);
#elif defined(__OS2__)
    _handle = 0;
#elif defined (__X_MOTIF__)
    XDestroyImage (_handle);
//     if (_handle) {
//         Display *dpy = XtDisplay (_TheApplication->Controller().ShellWidget());
//         XFreePixmap (dpy, _handle);
//     }
#endif
}



// UI_Color& UI_Bitmap::operator[] (short i, short j)
// {
// }



bool UI_Bitmap::DrawOn (UI_DrawingSurface& s, const UI_Point& p) const
{
    s.DrawBitmap ((const UI_Bitmap&) *this, p);
    return TRUE;
}



void UI_Bitmap::CopyFrom (UI_DisplaySurface& s, const UI_Rectangle& r)
{
#if defined (__MS_WINDOWS__)
    HDC srcdc = s.Handle();
    if (!srcdc)
        return;
    HDC destdc = CreateCompatibleDC (srcdc);
    if (!destdc)
        return;
    if (_handle)
        DeleteObject (_handle);
    long w = r.Width() ;
    long h = r.Height();
    _handle = CreateCompatibleBitmap (srcdc, w, h);
    HBITMAP hOldBm = SelectObject (destdc, _handle);
    SetMapMode (destdc, GetMapMode (srcdc));
    BitBlt (destdc, 0, 0,  r.Width(), r.Height(), srcdc, r.Left(), r.Top(),
            SRCCOPY);
    _handle = SelectObject (destdc, hOldBm);
    if (_handle) {
        BITMAP  bm;
        GetObject (_handle, sizeof (BITMAP), (LPSTR) &bm);
        _bitsPerPixel = bm.bmBitsPixel;
        _width        = bm.bmWidth;
        _height       = bm.bmHeight;
    }
    else
        _bitsPerPixel = _width = _height = 0;

    DeleteDC (destdc);

#elif defined(__OS2__)
    HDC hdc = GpiQueryDevice ((HPS) s.Handle());
    HAB hab = _TheApplication->Controller().AnchorBlockHandle();
    HDC hdcMem = DevOpenDC (hab, OD_MEMORY, "*", 0L, NULL, hdc);
    SIZEL sizel;
    sizel.cx = sizel.cy = 0;
    HPS hpsMem = GpiCreatePS (hab, hdcMem, &sizel, PU_ARBITRARY |
                              GPIT_MICRO | GPIA_ASSOC);
    long colorPlanes, colorBitCount;
    DevQueryCaps (s.Handle(), CAPS_COLOR_PLANES, 1L, &colorPlanes);
    DevQueryCaps (hdc, CAPS_COLOR_BITCOUNT, 1L, &colorBitCount);

    if (_handle != NULLHANDLE)
        GpiDeleteBitmap (_handle);

    // Now create a bitmap.
    BITMAPINFOHEADER bmp;
    bmp.cbFix = sizeof(BITMAPINFOHEADER);
    bmp.cx = (SHORT) r.Width();
    bmp.cy = (SHORT) r.Height();
    bmp.cPlanes   = (SHORT) colorPlanes;
    bmp.cBitCount = (SHORT) colorBitCount;
    _handle = GpiCreateBitmap (hpsMem, (PBITMAPINFOHEADER2) &bmp,
                               0x0000, NULL, NULL);
    GpiSetBitmap (hpsMem, _handle);

    GpiSetColor (hpsMem, CLR_TRUE);
    GpiSetBackColor (hpsMem, CLR_FALSE);
    GpiSetBackMix (hpsMem, BM_OVERPAINT);
    
    POINTL pt[4];
    pt[0].x = pt[0].y = 0;
    pt[1].x = r.Width()  - 1;
    pt[1].y = r.Height() - 1;
    pt[2].x = r.Left ();
    pt[2].y = s.DrawingArea().Height() - r.Bottom() + 1;
    pt[3].x = pt[2].x + r.Width()  - 1;
    pt[3].y = pt[2].y + r.Height() - 1;
    GpiBitBlt (hpsMem, (HPS) s.Handle(), 4, pt, ROP_SRCCOPY, BBO_AND);
    _bitsPerPixel = colorPlanes * colorBitCount;
    _width  = r.Width();
    _height = r.Height();
    GpiDestroyPS (hpsMem);
    DevCloseDC   (hdcMem);
    
#elif defined (__X_MOTIF__)
    Widget    w   = s.Client();
    Display *dpy  = XtDisplay (w);
    Window    win = XtWindow  (w);
    _width  = r.Width();
    _height = r.Height();
    
//     if (_handle)
//         XFreePixmap (dpy, _handle);
//    _handle = XCreatePixmap (dpy, DefaultRootWindow (dpy), _width, _height, 
//                              DefaultDepthOfScreen (XtScreen (s.Client())));
    
//     XCopyArea (dpy, win, _handle, s.Handle(), r.Left(), r.Top(), _width,
//                _height, 0, 0);
    if (_handle)
        XDestroyImage (_handle);
    int format = DefaultDepth (dpy, DefaultScreen(dpy)) == 1 ? XYPixmap
        : ZPixmap;
    _handle = XGetImage (dpy, win, r.Left(), r.Top(), r.Width(), r.Height(),
                         AllPlanes, format);
    _bitsPerPixel = _handle->bits_per_pixel;
    // Must fix the above to check for r being within client area
#endif
}





