

#ifndef _bitmap_h_ /* Wed Mar 23 12:51:01 1994 */
#define _bitmap_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Author: M. A. Sridhar



#include "ui/rectangl.h"

#if defined (__MS_WINDOWS__)
typedef ulong UI_BitmapHandle;

#elif defined (__OS2__)
typedef ulong UI_BitmapHandle;

#elif defined (__X_MOTIF__)
typedef struct _XImage* UI_BitmapHandle;

#endif


// This class is just the beginning of an encapsulation of bitmaps. It is
// nowhere near complete.

class UI_DrawingSurface;
class UI_DisplaySurface;


class UI_Bitmap: public UI_GraphicObject {
    
public:
    
    UI_Bitmap ();

#if defined(__MS_WINDOWS__)
    UI_Bitmap (const char* name);
    // MS-Windows-specific. Creates a Bitmap from the given resource name.
    // If {\tt name} begins with a {\tt +}, the built-in bitmap with given
    // name is constructed.

#endif
    
    ~UI_Bitmap ();

    UI_BitmapHandle Handle() const { return _handle;};
    
    long BitsPerPixel () const;
    
    long Height () const;
    
    long Width  () const;
    
    UI_Rectangle Shape () const;
    // Return the shape of the bitmap as a rectangle. The origin of the
    // returned rectangle will be (0,0).
    
    UI_Rectangle BoundingRectangle() const {return Shape();};
    
    bool OnBoundary (const UI_Point& p) const {return Shape().OnBoundary(p);};
    
    bool Includes (const UI_Point& p) const {return Shape().Includes (p);};
    
    // UI_Color& operator[] (short i, short j);
    
    bool DrawOn   (UI_DrawingSurface& s,
                   const UI_Point& p = UI_Point (0, 0)) const;
    
    void CopyFrom (UI_DisplaySurface& s, const UI_Rectangle& r);
    
    
protected:
    
    ulong           _width;
    ulong           _height;
    long            _bitsPerPixel;
    UI_BitmapHandle _handle;
    char*           _name;
};





inline long UI_Bitmap::BitsPerPixel () const
{
    return _bitsPerPixel;
}

inline long UI_Bitmap::Height () const
{
    return _height;
}

inline long UI_Bitmap::Width  () const
{
    return _width;
}



inline UI_Rectangle UI_Bitmap::Shape () const
{
    return UI_Rectangle (0, 0, _width, _height);
}




#endif /* _bitmap_h_ */
