




/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




#include "ui/btngroup.h"
#include "ui/cntroler.h"
#include "ui/simple.h"
#include "ui/applic.h"

#if defined (__MS_WINDOWS__)
#include <windows.h>
#include <ctl3d.h>

#if defined(__BORLANDC__)
#define DEFAULT_STYLE BS_GROUPBOX | WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS
#else
#define DEFAULT_STYLE BS_GROUPBOX | WS_CHILD | WS_VISIBLE
#endif


#elif defined (__X_MOTIF__)
#include <Xm/BulletinB.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#endif

UI_ButtonGroup::UI_ButtonGroup
    (UI_VObjCollection* parent, const UI_Rectangle& r,  UI_ViewID id)
: UI_VObjCollection (parent, r, id)
{
    if (!_parent)
        CL_Error::Warning ("ButtonGroup constructor: id %d: NULL parent!",
                           id);
#ifdef __MS_WINDOWS__
    _style = DEFAULT_STYLE;
#elif defined(__OS2__)
    _style = SS_GROUPBOX | WS_VISIBLE | WS_GROUP;
#endif
}



#if defined(__MS_WINDOWS__)
// For resource-based construction (only under MS-Windows):

UI_ButtonGroup::UI_ButtonGroup
    (UI_VObjCollection* parent, UI_ViewID id, UI_ViewHandle h)
: UI_VObjCollection (parent, UI_Rectangle(), id)
{
    _id = id;
    _handle = h;
}

#endif



UI_ButtonGroup::~UI_ButtonGroup ()
{
}



typedef CL_Binding<UI_ButtonGroup> BtnGroupBind;

bool UI_ButtonGroup::MakeVisualElement ()
{
#if defined(__MS_WINDOWS__)
    if (!UI_VObjCollection::MakeVisualElement())
        return FALSE;
    if (Has3DLook())
        Ctl3dSubclassCtl (_handle);

    // This hack is needed to ensure that group boxes get correctly
    // repainted under Windows:
    WNDPROC realProc = (WNDPROC) SetWindowLong
        (_handle, GWL_WNDPROC, (long) YACLBtnGroupProc);
    // Set the property to our address
    SetProp (_handle, BTNGROUP_PROPERTY1, LOWORD (realProc));
    SetProp (_handle, BTNGROUP_PROPERTY2, HIWORD (realProc));

    BtnGroupBind bind (this, &UI_ButtonGroup::_GetFocus);
    AddEventDependent (Event_KeyTyped, bind, 1);
    
    return TRUE;
#elif defined(__OS2__)
    bool b = UI_VObjCollection::MakeVisualElement();
    // And, just like under Windows, we need to subclass the button group,
    // otherwise it doesn't repaint itself right.
    // _Subclass ();
    BtnGroupBind bind (this, &UI_ButtonGroup::_GetFocus);
    AddEventDependent (Event_KeyTyped, bind, 1);
    return b;
#elif defined(__X_MOTIF__)
    // GNU C seems to have a strange bug, so we work around it. Instead of
    // saying
    //    Widget pw = (Widget) (_parent->ViewHandle());
    // we say
    UI_VisualObject* p = _parent;
    Widget pw = (Widget) p->ViewHandle();

    // First, we'll create a Frame widget
    CL_String instance_name = InstanceName();
    CL_String frame_name    = instance_name  + "_frame";

    Arg arg [20];
    short argn = 0;
    _SetupStyle (arg, argn); // Set up the X resources
    XtSetArg (arg[argn ], XmNshadowType, XmSHADOW_ETCHED_OUT); argn++;
    XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
    XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
    _frameWidget = XtCreateWidget (frame_name.AsPtr(), xmFrameWidgetClass,
                                   pw, arg, argn);

    // Next, create a label child of the frame
    CL_String label_name = instance_name + "_label";
    argn = 0;
    XmString title = XmStringCreate
        ((char *) _title.AsPtr (), XmSTRING_DEFAULT_CHARSET);    
    XtSetArg (arg [argn], XmNlabelString, title); argn++;
    XtSetArg (arg [argn], XmNchildType, XmFRAME_TITLE_CHILD); argn++;
    _frameLabel = XtCreateWidget
        (label_name.AsPtr(), xmLabelWidgetClass, _frameWidget, arg, argn);

    // Finally, create the bulletin board widget
    const char* inst_name = instance_name.AsPtr();
    struct _WidgetClassRec *class_name = WindowClass ();
    argn = 0;
//     XtSetArg (arg [argn], XmNmarginWidth,  0);     argn++;
//     XtSetArg (arg [argn], XmNmarginHeight, 0);     argn++;
    _xwidget = XtCreateWidget (inst_name, class_name, _frameWidget, arg,
                               argn);
    // Clean up
    XtRealizeWidget (_frameWidget);
    XtRealizeWidget (_xwidget);
    XmStringFree (title);

    return TRUE;
#endif
}


void UI_ButtonGroup::_PrivateInitialize ()
{
    UI_VObjCollection::_PrivateInitialize ();
#if defined(__MS_WINDOWS__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    if (h && !_parent->CreatedViaResource()) {
        SendMessage (_handle, WM_SETFONT, h, TRUE);
    }
#elif defined(__X_MOTIF__)
    if (_visible) {
        XtManageChild (_frameWidget);
        XtManageChild (_frameLabel);
    }
#endif
}


void UI_ButtonGroup::MakeInvisible ()
{
    UI_VObjCollection::MakeInvisible ();
#if defined(__X_MOTIF__)
    if (_frameWidget)   // We've been created
        XtUnmanageChild (_frameWidget);
#endif
}


void UI_ButtonGroup::MakeVisible ()
{
    UI_VObjCollection::MakeVisible ();
#if defined(__X_MOTIF__)
    if (_frameWidget) {   // We've been created
        XtManageChild (_frameWidget);
        XtManageChild (_frameLabel);
    }
#endif
}


#if defined(__MS_WINDOWS__) || defined(__OS2__)
bool UI_ButtonGroup::_GetFocus (CL_Object& obj, long)
{
    UI_Event& e = (UI_Event&) obj;
#if defined(__OS2__)
    ushort virtKey = SHORT2FROMMP (((QMSG*) e._nativeEvent)->mp2);
#else
    ushort virtKey = e.key;
#endif
    if (virtKey != VK_UP && virtKey != VK_DOWN)
        return TRUE;
    CL_ObjectSequence seq = _Controller->ChildrenOf (*this);
    short n = seq.Size();
    if (n > 0) {
        long index = seq.LinearSearch (e.Origin());
        if (index >= 0) {
            short next = virtKey == VK_UP ? index-1 : (index+1) % n;
            if (next == -1)
                next += n;
            _Controller->GiveFocusTo (*(UI_VisualObject*) seq[next]);
        }
    }
    return TRUE;
}

void UI_ButtonGroup::TakeFocus ()
{
    CL_ObjectSequence seq = _Controller->ChildrenOf (*this);
    short n = seq.Size();
    if (n > 0)
        _Controller->GiveFocusTo (*(UI_VisualObject*) seq[0]);
}

#endif


UI_WindowClass UI_ButtonGroup::WindowClass () const
{
#if defined(__MS_WINDOWS__)
    return  "button";
#elif defined(__OS2__)
    return WC_STATIC;
#elif defined(__X_MOTIF__)
    return xmBulletinBoardWidgetClass;
#endif
}





bool UI_ButtonGroup::_TitleChanged (CL_Object& o, long l)
{
#if defined(__MS_WINDOWS__)
    return UI_VObjCollection::_TitleChanged (o, l);

#elif defined(__OS2__)
    return UI_VObjCollection::_TitleChanged (o, l);

#elif defined(__X_MOTIF__)
    if (!_xwidget)
        return TRUE; // Not yet set up
    XmString xmtitle;
    xmtitle = XmStringCreate ((char*)_title.AsPtr(),
                              XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (_frameWidget, XmNlabelString, xmtitle, NULL);
    XmStringFree (xmtitle);
    XmUpdateDisplay (_xwidget);
    return TRUE;
#endif
}


bool UI_ButtonGroup :: _FontChanged (CL_Object& o, long l)
{
#if defined (__X_MOTIF__)
    UI_ResourceHandle h = _font ? _font->Handle() : 0;
    
    if (h <= 0 || !_frameLabel)
        return FALSE;

    Display *dpy = XtDisplay (_frameLabel);
    XmFontList f = XmFontListCreate (XQueryFont (dpy, h),
                                     XmSTRING_DEFAULT_CHARSET);
    Arg arg [1];
    XtSetArg       (arg [0], XmNfontList,  f);
    XtSetValues    (_frameLabel, arg, 1);
    XmFontListFree (f);
#endif
    return UI_VObjCollection::_FontChanged (o, l);
}


#if defined(__OS2__)

MRESULT EXPENTRY UI_ButtonGroup::ButtonGroupProc
    (HWND hWnd, ULONG msg, MPARAM p1, MPARAM p2)
{
    UI_ButtonGroup* grp = (UI_ButtonGroup*) (*_Controller)[hWnd];
    switch (msg) {
    case WM_ERASEBACKGROUND:
        CL_Error::Warning ("ButtonGroup erase: hwnd %d\n", hWnd);
        break;
        
    case WM_PAINT: {
        if (grp) {
            CL_Error::Warning ("ButtonGroup paint: hwnd %d\n", hWnd);
        }
        break;
    }
        
//         HPS hps = WinGetPS (hWnd);
//         RECTL rect;
//         WinQueryWindowRect (hWnd, &rect);
//         HRGN hrgn = GpiCreateRegion (hps, 1, &rect);
//         GpiSetClipRegion (hps, hrgn, NULL);
//         GpiErase (hps);
//         GpiDestroyRegion (hps, hrgn);
//         WinReleasePS (hps);

    default:
        break;
    }
    if (grp)
        return (*(grp->_oldProc))(hWnd, msg, p1, p2);
    return WinDefWindowProc (hWnd, msg, p1, p2);
    
}

void UI_ButtonGroup::_Subclass ()
{
    _oldProc = WinSubclassWindow (_handle, UI_ButtonGroup::ButtonGroupProc);
}

#endif


