
#ifndef _color_h_
#define _color_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik
// Modified:  R. Sampath


// This encapsulates all platform dependent details of the resource
// Color while providing sufficient functionality to initialize and
// modify colors in a platform independent manner.
// This being a very platform dependent feature, some alternative
// methods that are platform specific are also provided.


#include "base/object.h"

enum UI_ColorScheme {
    UIColor_Black, UIColor_Green, UIColor_Blue,
    UIColor_Red,   UIColor_White, UIColor_MediumGray
};


// Native platform's representation of color: a COLORREF under MS/Windows,
// and an XColor under X Windows.

#if defined (__MS_WINDOWS__)
#include <windows.h>
#define UI_MAXCOLORS  255

typedef COLORREF UI_NativeColorRep;

#elif defined (__OS2__)
#define UI_MAXCOLORS 255
typedef long     UI_NativeColorRep;

#elif defined (__X_MOTIF__)
#include <X11/Xlib.h>
#define  UI_MAXCOLORS 65535

typedef XColor UI_NativeColorRep;
#endif


class UI_Color: public CL_Object {

public:
    UI_Color ();
    // Default constuctor: construct a black color.

    UI_Color (UI_ColorScheme c);
    // Construct the color defined by the given ColorScheme.

    UI_Color (double red, double green, double blue);
    // All parameters should be between 0 and 1. This constructor is
    // platform-independent.
    
    UI_Color (const UI_Color&);
    // Copy constructor.

    void Red (double red);
    // Set the red intensity of this color. The least amount of red is 0,
    // and the highest is 255.

    double Red() const;

    void Green (double green) ;
    // Set the green intensity of this color. The least amount of green is 0,
    // and the highest is 255.

    double Green() const;

    void Blue (double blue) ;
    // Set the blue intensity of this color. The least amount of blue is 0,
    // and the highest is 255.

    double Blue() const;

    void Set (UI_ColorScheme c);

    UI_NativeColorRep& NativeForm () const;
    // However, the following platform specific method may be used 
    // in lieu of the above 
    // [For YACL internal use only.]

    
    bool operator==  (const UI_Color& x) const;

    bool operator==  (const CL_Object& x) const
        {return *this == ( (const UI_Color &) x); };

    void operator=   (const CL_Object& x)
        {*this = ((const UI_Color&) x);};

    void operator= (const UI_Color& color);

    const char* ClassName () const { return "UI_Color";};

protected:

         
    UI_NativeColorRep getColorVal (double, double, double);//convenience func

    UI_NativeColorRep getAbsVal (UI_ColorScheme);       //convenience func

    double _red, _blue, _green;

    UI_NativeColorRep _colorVal;
 
};

inline double UI_Color::Red() const
{
    return _red;
}


inline double UI_Color::Green() const
{
    return _green;
}



inline double UI_Color::Blue() const
{
    return _blue;
}


#endif
