
#ifndef _composit_h_
#define _composit_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik

#include "base/intseq.h"


#include "ui/vobjcoll.h"
#include "ui/event.h"


class UI_Menu;
class UI_MenuBar;

// The Composite is an object whose visual representation is a window, on
// which other visual objects can be placed. The other objects so placed
// are thought of as children of the Composite. Thus the Composite
// provides the heterogeneous composition mechanism in YACL. Typical
// applications for the Composite are modeless and modal dialogs. The
// operator[] provided by the Composite allows access to its children via
// their view ID. The Composite manages the setting of focus on its
// children when the user types the TAB (or SHIFT-TAB) key.
//
// From another viewpoint, a Composite can be thought of as essentially a
// mechanism for accessing its child VisualObjects via their ViewID's.
//
// The children of a composite may be drawn anywhere; however, only those
// that are within its client area (and have not been made invisible by
// the programmer) will be visible.
//
// A Composite can be created with an array of descriptors of its
// children. When so created, the Composite creates all of the children
// described by those descriptors. When the Composite is destroyed, these
// children are all destroyed; in fact, so is the entire subtree of the view
// tree rooted at the Composite being destroyed.
//
// A Composite may have other Composites as its children (although this
// doesn't always seem to work under MS-Windows, possibly because of a
// Windows bug.) 
//
// It is possible to associate a MenuBar with a Composite, using the
// {\small\tt UseMenuBar} method.
//
// In response to each event in the windowing
// system, the controller first sends the event to its destination (e.g.,
// when the mouse is clicked on a button, a click event is sent to the
// button) by invoking the destination's {\small\tt HandleEvent} method.
// Then, the event is sent to the each of the ancestors of the destination
// in the view tree, in order from leaf to root, via their {\small\tt
// HandleChildEvent} methods. This allows a Composite to inspect events
// that occur in its children (in fact, all its descendants) by overriding
// the {\small\tt HandleChildEvent}, and taking the necessary action.
//

class UI_CompositeVObject: public UI_VObjCollection {

public:

    // ---------------------- Construction ----------------------------

    UI_CompositeVObject (UI_CompositeVObject* parent,
                         const UI_Rectangle& shape, UI_ViewID id = -1);
    
    UI_CompositeVObject (UI_CompositeVObject* parent,
                         UI_ViewDescriptor* vd, bool sticky = FALSE,
                         const UI_Rectangle& shape = UI_Rectangle (),
                         UI_ViewID id = -1);
    // Descriptor-based construction: the second parameter points to an
    // array of ViewDescriptor structures, the last of which has type set to
    // View_None. The data structure pointer to by vd is "borrowed" for
    // reading by this composite object, and therefore may not be destroyed
    // until the composite becomes visible. (But the composite does not
    // write into the vd data structure.) The parameter "sticky" indicates
    // whether this composite "sticks" to its parent's surface, and moves
    // along with the parent; if it is FALSE, the composite appears as a
    // separate window with its own caption bar. (Composites that stick to
    // parent composites seem to behave erroneously under MS-Windows,
    // perhaps because of a Windows bug?)


#if defined(__MS_WINDOWS__)
    UI_CompositeVObject (UI_CompositeVObject* parent,
                         const char* resource_name, UI_ViewID id = -1);
    // Resource-based construction: currently supported only under
    // MS-Windows. This creates a non-sticky composite.

#endif

    // ------------------- View-related methods ---------------

    UI_Rectangle Area () const;
    
    virtual void ShowTitleBar ();

    virtual void HideTitleBar ();

    virtual bool IsTitleBarShown ();

    virtual bool IsIconified () {return _iconified;};

    bool SticksToParent () const {return _stickToParent;};
    
#if defined(__MS_WINDOWS__)
    virtual void Set3DLook ();
    // [MS-Windows-specific] Use the Borland 3-dimensional look on this
    // Composite  and all its descendants. This method must be called
    // before the Composite is displayed. [NOT YET IMPLEMENTED]

    bool Has3DLook () const;
    // [MS-Windows-specific] Does this Composite have a 3-d look?

#endif
    // -------------------- Subview manipulation ---------------------
    
    virtual UI_VisualObject*  CreateChild (const UI_ViewDescriptor& vd);
    //  Create a child with given descriptor, and return a pointer to it.
    //  This array cannot include any ExOrToggleButton descriptors.
    
    virtual UI_VisualObject* RemoveChild (UI_VisualObject* view);
    // Remove the given VisualObject from the composite and
    // return it. The caller must destroy the returned object via the
    // Application's Destroy method.

    // ------------------ Convenience methods ----------------------

    CL_Object& Model ();
    // The returned model is an IntPtrMap whose keys are the view id's of
    // the children, and whose values are pointers to the corresponding
    // model objects.
    
#if defined(__MS_WINDOWS__)
    bool CreatedViaResource () {return _rname.Size() > 0;};
    // [MS-Windows-specific] Return TRUE if this object was created using a
    // resource name.

#endif
    // --------------------- Menu methods ---------------------------
    
    UI_MenuBar* MenuBar () const;
    // Return the menu used by this composite. Return NULL if there is no
    // associated menu.

    
    // ---------------------- Basic methods -----------------------

    virtual UI_WindowClass WindowClass () const;
    
    const char* ClassName() const { return "UI_CompositeVObject";};



protected:
    

    ~UI_CompositeVObject();

    virtual bool MakeVisualElement ();
    
    // 
    // Composite method for child event inspection:
    // 

    virtual bool HandleChildEvent (const UI_Event& e);
    // This is a hook for inspecting and processing any event originating
    // in any of the contained objects that are passed up to this
    // composite -- the parent. The default implementation does nothing and
    // simply returns FALSE.

    
    bool DestroyVisualElement ();

    void initSimple (UI_VisualObject*);

    void _PrivateInitialize();



#if defined(__X_MOTIF__)
    static void DeleteWindowCallback (struct _WidgetRec* w,
                                      void *client, void *call);
    
#endif
    
public:

    // -------------- For YACL internal use only -----------------
    
#if defined(__MS_WINDOWS__)
    bool CreateResourceChild (UI_ViewHandle, const CL_String& name);
    //  [YACL internal use only] MS-Windows-specific: Create a child if
    //  instantiated from a resource file.

#endif
    void AddChild (UI_VisualObject* child);
    // [YACL internal use only]
    
    bool UseMenuBar  (UI_MenuBar* menu);
    // [YACL internal use only]

#if defined(__MS_WINDOWS__) || defined(__OS2__)
    void TakeFocus ();
    // [Specific to OS/2 and Windows. YACL internal use only.]

    virtual void MoveFocusTo (UI_VisualObject* child);
    // [Specific to OS/2 and Windows. YACL internal use only.] This method
    // moves the focus to the specified child. Called by the child on mouse
    // click.

    virtual bool AdvanceFocus (short n);
    // [Specific to OS/2 and Windows. YACL internal use only.] This method
    // advances focus to the next child if n is +1, and to the previous
    // child if n is -1. Returns TRUE on success, FALSE if it hits the ends
    // of the tab sequence.

protected:
    void _SetFocusTo (short i);
    // [Specific to OS/2 and Windows. YACL internal use only.] Set the focus
    // to child $i$ in the tab sequence.
    
#endif
    
    
protected:
    // 
    // Instance Variables:
    // 

    UI_MenuBar*        _menuBar;
    bool               _stickToParent; // Do we stick to our parent's
                                       // surface?
    short              _currentChild;  // Index of current child in map
    CL_ObjectSequence  _tabSequence;   // The sequence of children in
                                       // tabbing order

    bool               _titleBarShown; // Is the title bar currently shown?

    bool               _iconified;     // Are we currently iconified?

#if defined(__OS2__)
    UI_ViewHandle      _frameHandle;
#endif
    
private:

    bool  _ShapeRectChanged (CL_Object&, long);
    // Override VisualObject's method

    bool _TitleChanged (CL_Object&, long);
    // Override VisualObject's method
    
#if defined(__X_MOTIF__)
    _WidgetRec* _popup;
#endif

#if defined(__MS_WINDOWS__)
    bool               _3dLook;
    CL_String          _rname;         // Resource  name
                                       // (used only under MS-Windows)
#endif

private:
    void _Init ();

    
    bool _EventOccurred (CL_Object& o, long);
    // [Internal use only. Meant for handling tab sequences.]

};




#endif
