
#ifndef _dialog_h_
#define _dialog_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik



// The behavior of the Dialog is an enhancement of that of the Composite,
// in that that Dialog supports the notion of "dialog events" on certain
// designated children. A Dialog is created with a set of "dialog events"
// that are significant to it, and remembers the most recent dialog event
// that occurred on it. The
// types of dialog events, and the identities of the children they must occur
// on, can be specified when the dialog is constructed. 
//
// The Dialog also includes the method ExecuteModal, which causes the
// Dialog to run modally until one of the dialog events occurs on the
// corresponding child. If this
// method is not invoked, the Dialog is modeless.



#include "base/objset.h"
#include "ui/composit.h"


#define UI_IDOK     1
#define UI_IDCANCEL 2

struct UI_DialogEventDescriptor {
    UI_ViewID  id;
    UI_EventType type;
};
                 
class UI_Dialog : public UI_CompositeVObject {

public:

    // -------------------- Construction and destruction ------------------

    UI_Dialog (UI_CompositeVObject* parent, UI_ViewDescriptor* children,
               const UI_Rectangle& shape,
               UI_DialogEventDescriptor* events = NULL,
               long id = -1);
    // Constructor: build a dialog ``manually'', by specifying the parent and
    // shape, all the children of the dialog (in the {\tt children} array), and
    // the dialog events for this Dialog. Both {\tt children}
    // and {\tt events} must point to arrays of elements whose
    // last element has id <= 0. If the {\tt children} pointer is NULL, it is
    // assumed that any events originating from either of children with id's
    // UI_IDOK and UI_IDCANCEL are the dialog events.


#if defined(__MS_WINDOWS__)
    UI_Dialog(UI_CompositeVObject* parent, const char* resourceName,
               UI_DialogEventDescriptor* events = NULL,
               UI_ViewID id = -1);
    // Resource-based construction (only under MS-Windows).

#endif
    
    // ---------------------- Dialog events ----------------------------
    virtual bool AddDialogEvent    (UI_ViewID id, UI_EventType type);
    // Add to the set of dialog events recognized by this Dialog.

    virtual bool RemoveDialogEvent (UI_ViewID id, UI_EventType type);
    // Remove a dialog event. Return FALSE if no such dialog event was
    // recognized by this Dialog.

    UI_DialogEventDescriptor LastDialogEvent () { return _lastEvent;};
    // Return the most recent dialog event. If this event contains an id of
    // -1, then no dialog events have occurred yet.
    
    // ---------------------- Modal execution ----------------------------
    
    UI_DialogEventDescriptor ExecuteModal ();
    // Execute the given dialog modally until a dialog event occurs, and
    // return that event.

    bool InModalState ();
    // Are we currently running modally?
    
    // ---------------- Basic methods ---------------------------------
    
    const char* ClassName() const {return "UI_Dialog";};

    // ------------------- End public protocol -------------------------

    
protected:
    virtual bool MakeVisualElement ();
    // Override method inherited from VisualObject.
    
    ~UI_Dialog ();
    // Destructor.

    void CloseDown ();
    
    //
    // Instance Variables:
    //
    UI_DialogEventDescriptor    _lastEvent;
    CL_ObjectSet                _dialogEvents;

private:

    void _Init (UI_DialogEventDescriptor*);
    
    bool EventFilter (CL_Object&, long);
    // The event filter used by the modal event loop.
    
    bool RunFinished (CL_Object&, long);
    // The termination filter used by the modal event loop.

    bool _DialogEventOccurred (CL_Object&, long);
    // The event dependent method.

    bool                        _closed;
    bool                        _modalState;
    
};



inline bool UI_Dialog::InModalState ()
{
    return _modalState;
}


#endif
