#ifndef _dsplsurf_h_
#define _dsplsurf_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */



// Authors:   M. A. Sridhar
//            N. Bhowmik


// A DisplaySurface is an encapsulation of a region on the screen that
// provides drawing operations. This region must be associated with the
// window of the  'client display' - a VisualObject that is
// specified during construction. The DisplaySurface inherits its abstract
// behavior from the DrawingSurface, and overrides appropriate methods to
// provide drawing facilities on a screen.
// Each DisplaySurface object maintains default Font,
// Brush and Pen objects.  It is important that a
// display surface not be kept open for very long.



#include "ui/uidefs.h"
#include "ui/dwgsurf.h"

class UI_VisualObject;

class UI_DisplaySurface: public UI_DrawingSurface {


public:

    UI_VisualObject& Client () const;

    double HorzPixelsPerMM () const {return _horzPPM;};
    // Return the number of pixels per millimeter in the horizontal direction.

    double VertPixelsPerMM () const {return _vertPPM;};
    // Return the number of pixels per inch in the vertical direction.
    
    UI_Rectangle DrawingArea () const;

    UI_Rectangle DrawingAreaInMM () const;

    // UI_ColorMap& ColorMap () const;
    

    //    UI_Point PenPosition();
    // Returns the current pen position.


    // ------------------------ Graphic modes ----------------------
    enum GraphicsMode {
        GMode_Clear = 0,        //
        GMode_And,
        GMode_AndReverse,
        GMode_Copy,
        GMode_AndInverted,
        GMode_NoOp,
        GMode_Xor,
        GMode_Or,
        GMode_Nor,
        GMode_Equiv,
        GMode_Invert,
        GMode_OrReverse,
        GMode_CopyInverted,
        GMode_OrInverted,
        GMode_Nand,
        GMode_Set
    };

    virtual GraphicsMode Mode () const;
    // Return the current graphics mode.

    virtual void Mode (GraphicsMode mode);
    // Set the current graphics mode.
    
    // 
    // Draw  operations:
    // 


    void ClearDisplay();
    // Paints client surface with current background color.

    void DrawPoint (const UI_Point& p, const UI_Color& color);
    // Draw a point at position {\tt p} with given color.
    
    void ColorRectangle (const UI_Rectangle& r, const UI_Color& cs);

    
    bool InvertRectangle (const UI_Rectangle&);
    // Reverse the forground and background in the given rectangle. Return
    // TRUE on success, FALSE on failure.

    
    void DrawRectangle (const UI_Rectangle& rect,
                        ushort opt = UID_Outline); 
    // Draw a rectangle using the current pen. The second parameter
    // specifies the outline and fill options.
                
    void DrawEllipse (const UI_Rectangle& rect,
                      ushort opt = UID_Outline); 
    // Draw an ellipse with given bounding rectangle, using the current pen.
    // The second parameter specifies the outline and fill options.
    // (If the "rectangle" happens to be a square, then a circle is drawn.)
                
    virtual void DrawArc (const UI_Arc &arc);
    // Draw an arc with the using the parameters given to UI_Arc.

    virtual void DrawChord (const UI_Chord& chord,
                            ushort opt = UID_Outline); 
    // Draw a chord using the current pen. The second parameter
    // specifies the outline and fill options.

    virtual void DrawPieWedge (const UI_PieWedge& pie,
                               ushort opt = UID_Outline); 
    // Draw a pie wedge using the current pen. The second parameter
    // specifies the outline and fill options.
        
    void DrawPolygon (UI_Point pointArray[], short numPoints,
                      ushort opt = UID_Outline);
    // Draw a closed polygon by connecting the points in the array with
    // line segments, in the order of occurrence of the points.  The second
    // parameter specifies the outline and fill options.
    // The first point in the array is taken as the starting point.

    bool DrawLine (const UI_Point& p, const UI_Point& q);
    // Draw a line from  p to q, using our pen.

    // For the following drawing methods, if no starting point is
    // specified then the figure is drawn at the current pen position.

    void DrawPolyLine (UI_Point* pointarray, short numPoints);
    // Draw a figure by connecting the points in the array with
    // line segments, in the order of occurrence of the points. 
    // The first point in the array is taken as the starting point.
    
    bool DrawBitmap (const UI_Bitmap& b, const UI_Point& topLeft);
    // Draw the given bitmap on this surface.
     

    // 
    // Text operations:
    // 

    UI_Font& Font();
    
    void WriteString (const CL_String& str, const UI_Rectangle& text_rect,
                      UI_TextStyle style = UIText_Left);

    
    virtual short TextWidth (const char* s) const;
    // Return the width (in pixels) of the text string s if it were drawn
    // on this DisplaySurface using its current font.

    const char* ClassName () const {return "UI_DisplaySurface";};

protected:

    UI_DisplaySurface  (UI_VisualObject* o);

    ~UI_DisplaySurface ();

    void _Init ();

    void SetFont (UI_Font*);
    // SetFont: called only by UI_VisualObject and no one else!
    
    friend class UI_VisualObject;


    

protected:
    
    bool             _ownFont;
    UI_VisualObject& _client;
    //    UI_ColorMap*     _colorMap;

    double           _horzPPM;
    double           _vertPPM;

private:
    bool _FontWillChange (CL_Object&, long);

    bool _FontChanged    (CL_Object&, long);

    UI_Point _ProjectToCorner (UI_Rectangle &rect, UI_Point &p);

#if defined(__X_MOTIF__)
    void _DrawFontLine (const UI_Point& p1, const UI_Point& p2);
    // [X-windows-specific; internal use only]
    
    
#endif
};





// inline UI_ColorMap& UI_DisplaySurface::ColorMap () const
// {
//     return *_colorMap;
// }
 



#endif

