


#include "ui/ellipse.h"
#include "ui/dwgsurf.h"

#if defined(__MS_WINDOWS__)
#include <windows.h>
#endif


UI_Ellipse::UI_Ellipse ()
{
    _majorAxis = _minorAxis = 0;
}


UI_Ellipse::UI_Ellipse (const UI_Rectangle& r)
{
    _majorAxis = r.Width();
    _minorAxis = r.Height ();
    _origin = UI_Point (r.Left() + _majorAxis/2, r.Top() + _minorAxis/2);
}


UI_Ellipse::UI_Ellipse (long major_axis, long minor_axis, UI_Point origin)
: _origin (origin)
{
    _majorAxis = major_axis;
    _minorAxis = minor_axis;
}


bool UI_Ellipse::DrawOn (UI_DrawingSurface& sfc, const UI_Point& p) const
{
    UI_Rectangle e (p + _origin - UI_Point (_majorAxis/2, _minorAxis/2),
                    _majorAxis, _minorAxis);
    sfc.DrawEllipse (e);
    return TRUE;
}

bool UI_Ellipse::Fill (UI_DrawingSurface& s) const
{
    s.DrawEllipse (BoundingRectangle(), UID_Fill);
    return TRUE;
}



bool UI_Ellipse::ReshapeTo (const UI_Point& p1, const UI_Point& p2)
{
    if (!PrepareToChange())
        return FALSE;
    UI_Rectangle r (p1, p2.XCoord() - p1.XCoord(), p2.YCoord() -
                    p1.YCoord());
    long major = r.Width();
    long minor = r.Height();
    _origin = r.Origin() + UI_Point (major/2, minor/2);
    _majorAxis = major;
    _minorAxis = minor;
    Notify();
    return TRUE;
}



UI_Rectangle UI_Ellipse::BoundingRectangle() const
{
    long x = _origin.XCoord();
    long y = _origin.YCoord();
    return UI_Rectangle (x -_majorAxis/2, y - _minorAxis/2, _majorAxis,
                         _minorAxis);
}


bool UI_Ellipse::IntersectsBoundary (const UI_Rectangle& r) const
{
    // We chicken out and use the facilities of the window system
#if defined(__MS_WINDOWS__)
    UI_Rectangle br = BoundingRectangle();
    HRGN eRgn = CreateEllipticRgn (br.Left(), br.Top(), br.Right(),
                                   br.Bottom());
    RECT rect = r.AsMSRect ();
    bool b = RectInRegion (eRgn,  &rect);
    DeleteObject (eRgn);
    return b;
#else
    NotImplemented ("IntersectsBoundary");
    return FALSE;
#endif
}
