



#ifndef _ellipse_h_ /* Sat Oct 29 09:47:06 1994 */
#define _ellipse_h_


#include "ui/graphic.h"

class UI_Ellipse: public UI_GraphicObject {

public:
    UI_Ellipse (long major_axis, long minor_axis, UI_Point origin =
                UI_Point (0, 0));
    // Create an ellipse with given origin and given major and minor axes.
    // If the two axes are equal, the result is a circle with given
    // diameter.

    UI_Ellipse (const UI_Rectangle&);
    // Construct an ellipse whose bounding box is the given rectangle.
    
    UI_Ellipse ();
    // Create an ellipse at position (0, 0) of size 0.

    bool DrawOn (UI_DrawingSurface& sfc,
                 const UI_Point& p = UI_Point (0,0)) const;
    // Draw the ellipse on the surface {\tt sfc} (overrides inherited
    // method).

    bool Fill   (UI_DrawingSurface& s) const;
        
    
    bool ReshapeTo (const UI_Point& p1, const UI_Point& p2);
    // Override method inherited from GraphicObject. The implementation
    // reshapes the ellipse so that its bounding rectangle is the rectangle
    // whose diagonally opposite points are p1 and p2.


    UI_Rectangle BoundingRectangle() const;

    bool IntersectsBoundary (const UI_Rectangle& r) const;
    
    const char* ClassName() const {return "UI_Ellipse";};


protected:
    UI_Point _origin;
    long     _majorAxis;
    long     _minorAxis;

};

#endif /* _ellipse_h_ */
