

#ifndef _event_h_
#define _event_h_





/*
 *
 *          Copyright (C) 1994, M. A. Sridhar
 *  
 *
 *     This software is Copyright M. A. Sridhar, 1994. You are free
 *     to copy, modify or distribute this software  as you see fit,
 *     and to use  it  for  any  purpose, provided   this copyright
 *     notice and the following   disclaimer are included  with all
 *     copies.
 *
 *                        DISCLAIMER
 *
 *     The author makes no warranties, either expressed or implied,
 *     with respect  to  this  software, its  quality, performance,
 *     merchantability, or fitness for any particular purpose. This
 *     software is distributed  AS IS.  The  user of this  software
 *     assumes all risks  as to its quality  and performance. In no
 *     event shall the author be liable for any direct, indirect or
 *     consequential damages, even if the  author has been  advised
 *     as to the possibility of such damages.
 *
 */




// Authors:   M. A. Sridhar
//            N. Bhowmik


// This  class represents a YACL event.   An event may   be thought of as a
// message  from one object  to  another.   It  therefore  encapsulates all
// relevant  information for  communication  between  objects. An  event is
// characterized  by  its  origin, type  and  destination,  the  origin and
// destination being any VisualObject.  The type is further categorized  to
// be hard or soft. A hard event is any event  captured from the underlying
// system, i.e., one that represents the occurance  of a physical event.  A
// soft event on  the  other hand   denotes  a conceptual event.  An  event
// contains additional information like the point of occurance, key pressed
// (if any), in order to make a message more informative.
// 
// The Event class includes an instance variable _nativeEvent, which is a
// pointer to the platform-specific event (an MSG under Windows, and an
// XEvent under X) which was translated to this high-level event. The
// _nativeEvent can be used for platform-dependent processing if necessary.

#include "ui/rectangl.h"

class UI_VisualObject;

enum UI_EventCategory {Event_Hard,Event_Soft};
enum UI_EventType { // All these are sent from the controller.
    Event_None = 0,

    // --------------------- Hard Events -----------------------

                              // ------------- Mouse events ------------
    Event_MouseMove, 
    Event_LButtonPress,
    Event_MButtonPress,       
    Event_RButtonPress,     
    Event_LButtonRelease,   
    Event_MButtonRelease,   
    Event_RButtonRelease,   
    Event_LButtonDblClk,
    Event_MButtonDblClk,       
    Event_RButtonDblClk,
    
                              // ------------- Scrolling events -----
    Event_Scroll,             // Continuous scroll
    Event_FinishScroll,       // End of continuous scroll
    Event_ScrollToBegin,      // Scroll to the beginning of the interval
    Event_ScrollToEnd,        // Scroll to the end of the interval
    Event_ScrollForwardLine,
    Event_ScrollBackwardLine,
    Event_ScrollForwardPage,
    Event_ScrollBackwardPage,
    Event_ScrollToPosition,   // For this event, the param field contains
                              // the position to scroll to
    
                              // -------------  Keyboard events ------
    Event_KeyTyped,
    Event_KeyDown,
    Event_KeyUp,
    
                              // --------------- View events -----------    
    Event_GetFocus,          
    Event_LoseFocus,         
    Event_Paint,              // View is exposed: needs painting
    Event_GraphicsExpose,
    Event_Reconfigure,        // View is moved or resized: curPos contains
                              // the new shape rectangle
    Event_ViewEnter,          // Mouse enters this view
    Event_ViewLeave,          // Mouse leaves this view
    Event_Iconify,
    Event_Deiconify,
    Event_FullScreen,         // Sent when the window is maximized

    // ------------------------ Soft Events ---------------------

    Event_FirstSoftEvent,     // Used only for deciding event category
                              // New soft events must be added AFTER this!
    Event_ChildCreated,       // A SimpleVObject creation event.
    Event_CloseDown,          // Close down a visualobject if it is ready
    Event_MakeInterface,      // 
    Event_Quit,               // Unequivocal destroy. 
    Event_Select,             // The recipient of the event has changed in
                              // some way; e.g., the recipient is a
                              // button, and it has been clicked, or it is a
                              // menu item that has been selected
    Event_Other
        
}; // End  event enumeration





class UI_Event: public CL_Object {

public:

    UI_Event (UI_EventType type,UI_VisualObject* origin,
              UI_VisualObject* dest = NULL,
              void* nativeEvent = NULL);
    // If dest == NULL, it is set to origin
    
    UI_Event (const UI_Event&);

    ~UI_Event ();

    UI_VisualObject* Origin () const {return _origin;};

    UI_VisualObject* Destination () const {return _dest;};

    UI_EventType Type () const {return _type;} ;

    UI_EventCategory Category () const {return _category;};
  
    void SetDestination (UI_VisualObject* ); 

    void operator= (const UI_Event& );

    void operator= (const CL_Object& o)
        {*this = (const UI_Event&) o;};

    void operator= (const CL_String&)
        {NotImplemented ("Operator= (CL_String)");};

    //
    //-------------------Attributes-------------------
    //

    UI_Rectangle   curPos;    // Position of the event. The meaning of
                              // this inst var depends on the kind of
                              // event.
    ulong          duration;
    char           key;       // ASCII value of key pressed if any
    ulong          param;     // Additional info if any
    bool           _shiftKey; // Was the shift key pressed?
    bool           _metaKey;  // Was the meta (alt) key pressed?
    bool           _ctrlKey;  // Was the control key pressed?
    void*          _nativeEvent; // Pointer to actual event structure
                                 // received from underlying system
    
protected:
    
    UI_VisualObject* _origin;    // View where event occured 
    UI_VisualObject* _dest;      // View for whom event is intended
    UI_EventType     _type;
    UI_EventCategory _category;

    friend class UI_Controller;
};

#endif
